/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortCommandSwitch;
import java.io.UnsupportedEncodingException;

public class SignatureCommand
extends ComPortCommand {
    public static final String ENCODING = "ISO-8859-1";
    private final String signature;
    private boolean decodeFailed;

    public SignatureCommand(int[] bytes) {
        super("SIGNATURE", 0, bytes);
        String sig;
        boolean failed = false;
        try {
            sig = new String(this.getPayload(), ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            sig = "(string decode failed)";
            failed = true;
        }
        this.signature = sig;
        this.decodeFailed = failed;
    }

    public SignatureCommand(boolean client, String signature) {
        this(SignatureCommand.encode(client, signature));
    }

    public SignatureCommand(boolean client) {
        this(SignatureCommand.encode(client, ""));
    }

    @Override
    public String toString() {
        return this.getName() + " " + (this.signature.length() > 0 ? "\"" + this.signature + "\"" : "REQUEST");
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseSignature(this);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean decodeFailed() {
        return this.decodeFailed;
    }

    @Override
    int getMinPayloadLength() {
        return 0;
    }

    @Override
    int getMaxPayloadLength() {
        return 0x7FFFFFFD;
    }

    private static int[] encode(boolean client, String signature) {
        byte[] buf;
        try {
            buf = signature.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            buf = new byte[]{63};
        }
        int[] ibuf = new int[2 + buf.length];
        ibuf[0] = 44;
        ibuf[1] = client ? 0 : 100;
        for (int i = 0; i < buf.length; ++i) {
            ibuf[2 + i] = buf[i] & 0xFF;
        }
        return ibuf;
    }
}

