/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.factory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.module.script.ScriptDependencyTracker;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.automation.module.script.internal.handler.ScriptActionHandler;
import org.openhab.core.automation.module.script.internal.handler.ScriptConditionHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ModuleHandlerFactory.class, ScriptDependencyTracker.Listener.class})
public class ScriptModuleHandlerFactory
extends BaseModuleHandlerFactory
implements ScriptDependencyTracker.Listener {
    private final Logger logger = LoggerFactory.getLogger(ScriptModuleHandlerFactory.class);
    private static final Collection<String> TYPES = List.of("script.ScriptAction", "script.ScriptCondition");
    @NonNullByDefault(value={})
    private ScriptEngineManager scriptEngineManager;
    private Map<String, ScriptActionHandler> trackedHandlers = new ConcurrentHashMap<String, ScriptActionHandler>();

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    public Collection<String> getTypes() {
        return TYPES;
    }

    /*
     * WARNING - void declaration
     */
    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        Module module2;
        Module module3;
        this.logger.trace("create {} -> {}", (Object)module.getId(), (Object)module.getTypeUID());
        String moduleTypeUID = module.getTypeUID();
        if ("script.ScriptCondition".equals(moduleTypeUID) && (module3 = module) instanceof Condition) {
            void condition;
            Condition condition2 = (Condition)module3;
            Condition cfr_ignored_0 = (Condition)module3;
            return new ScriptConditionHandler((Condition)condition, ruleUID, this.scriptEngineManager);
        }
        if ("script.ScriptAction".equals(moduleTypeUID) && (module2 = module) instanceof Action) {
            void action;
            Action action2 = (Action)module2;
            Action cfr_ignored_1 = (Action)module2;
            ScriptActionHandler handler = new ScriptActionHandler((Action)action, ruleUID, this.scriptEngineManager, this::onHandlerRemoval);
            this.trackedHandlers.put(handler.getEngineIdentifier(), handler);
            return handler;
        }
        this.logger.error("The ModuleHandler is not supported: {}", (Object)moduleTypeUID);
        return null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void unsetScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = null;
    }

    private void onHandlerRemoval(ScriptActionHandler handler) {
        this.trackedHandlers.values().remove((Object)handler);
    }

    @Override
    public void onDependencyChange(String engineIdentifier) {
        ScriptActionHandler handler = this.trackedHandlers.get(engineIdentifier);
        if (handler != null) {
            this.logger.debug("Resetting script engine for script {}", (Object)engineIdentifier);
            handler.resetScriptEngine();
            try {
                handler.compile();
            }
            catch (ScriptException e) {
                this.logger.error("Failed to recompile script for rule {}: {}", (Object)handler.getRuleUID(), (Object)e.getMessage());
            }
        }
    }
}

