/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Di;
import org.lwjgl.openxr.XrOffset2Di;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect2Di
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    public XrRect2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRect2Di.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset2Di offset() {
        return XrRect2Di.noffset(this.address());
    }

    public XrExtent2Di extent() {
        return XrRect2Di.nextent(this.address());
    }

    public XrRect2Di offset(XrOffset2Di value) {
        XrRect2Di.noffset(this.address(), value);
        return this;
    }

    public XrRect2Di offset(Consumer<XrOffset2Di> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect2Di extent(XrExtent2Di value) {
        XrRect2Di.nextent(this.address(), value);
        return this;
    }

    public XrRect2Di extent(Consumer<XrExtent2Di> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect2Di set(XrOffset2Di offset, XrExtent2Di extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect2Di set(XrRect2Di src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRect2Di malloc() {
        return (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrRect2Di calloc() {
        return (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrRect2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrRect2Di create(long address) {
        return (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)address);
    }

    @Nullable
    public static XrRect2Di createSafe(long address) {
        return address == 0L ? null : (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrRect2Di.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrRect2Di.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrRect2Di.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect2Di.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrRect2Di.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrRect2Di.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrRect2Di.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrRect2Di malloc(MemoryStack stack) {
        return (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRect2Di calloc(MemoryStack stack) {
        return (XrRect2Di)XrRect2Di.wrap(XrRect2Di.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrRect2Di.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrRect2Di.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static XrOffset2Di noffset(long struct) {
        return XrOffset2Di.create(struct + (long)OFFSET);
    }

    public static XrExtent2Di nextent(long struct) {
        return XrExtent2Di.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset2Di value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)XrOffset2Di.SIZEOF);
    }

    public static void nextent(long struct, XrExtent2Di value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)XrExtent2Di.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect2Di.__struct((Struct.Member[])new Struct.Member[]{XrRect2Di.__member((int)XrOffset2Di.SIZEOF, (int)XrOffset2Di.ALIGNOF), XrRect2Di.__member((int)XrExtent2Di.SIZEOF, (int)XrExtent2Di.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect2Di, Buffer>
    implements NativeResource {
        private static final XrRect2Di ELEMENT_FACTORY = XrRect2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrRect2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset2Di offset() {
            return XrRect2Di.noffset(this.address());
        }

        public XrExtent2Di extent() {
            return XrRect2Di.nextent(this.address());
        }

        public Buffer offset(XrOffset2Di value) {
            XrRect2Di.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset2Di> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent2Di value) {
            XrRect2Di.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent2Di> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

