/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.tinyexr.EXRAttribute;
import org.lwjgl.util.tinyexr.EXRBox2i;
import org.lwjgl.util.tinyexr.EXRChannelInfo;

public class EXRHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXEL_ASPECT_RATIO;
    public static final int LINE_ORDER;
    public static final int DATA_WINDOW;
    public static final int DISPLAY_WINDOW;
    public static final int SCREEN_WINDOW_CENTER;
    public static final int SCREEN_WINDOW_WIDTH;
    public static final int CHUNK_COUNT;
    public static final int TILED;
    public static final int TILE_SIZE_X;
    public static final int TILE_SIZE_Y;
    public static final int TILE_LEVEL_MODE;
    public static final int TILE_ROUNDING_MODE;
    public static final int LONG_NAME;
    public static final int NON_IMAGE;
    public static final int MULTIPART;
    public static final int HEADER_LEN;
    public static final int NUM_CUSTOM_ATTRIBUTES;
    public static final int CUSTOM_ATTRIBUTES;
    public static final int CHANNELS;
    public static final int PIXEL_TYPES;
    public static final int NUM_CHANNELS;
    public static final int COMPRESSION_TYPE;
    public static final int REQUESTED_PIXEL_TYPES;
    public static final int NAME;

    public EXRHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EXRHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float pixel_aspect_ratio() {
        return EXRHeader.npixel_aspect_ratio(this.address());
    }

    public int line_order() {
        return EXRHeader.nline_order(this.address());
    }

    public EXRBox2i data_window() {
        return EXRHeader.ndata_window(this.address());
    }

    public EXRBox2i display_window() {
        return EXRHeader.ndisplay_window(this.address());
    }

    @NativeType(value="float[2]")
    public FloatBuffer screen_window_center() {
        return EXRHeader.nscreen_window_center(this.address());
    }

    public float screen_window_center(int index) {
        return EXRHeader.nscreen_window_center(this.address(), index);
    }

    public float screen_window_width() {
        return EXRHeader.nscreen_window_width(this.address());
    }

    public int chunk_count() {
        return EXRHeader.nchunk_count(this.address());
    }

    @NativeType(value="int")
    public boolean tiled() {
        return EXRHeader.ntiled(this.address()) != 0;
    }

    public int tile_size_x() {
        return EXRHeader.ntile_size_x(this.address());
    }

    public int tile_size_y() {
        return EXRHeader.ntile_size_y(this.address());
    }

    public int tile_level_mode() {
        return EXRHeader.ntile_level_mode(this.address());
    }

    public int tile_rounding_mode() {
        return EXRHeader.ntile_rounding_mode(this.address());
    }

    @NativeType(value="int")
    public boolean long_name() {
        return EXRHeader.nlong_name(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean non_image() {
        return EXRHeader.nnon_image(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean multipart() {
        return EXRHeader.nmultipart(this.address()) != 0;
    }

    @NativeType(value="unsigned int")
    public int header_len() {
        return EXRHeader.nheader_len(this.address());
    }

    public int num_custom_attributes() {
        return EXRHeader.nnum_custom_attributes(this.address());
    }

    @Nullable
    @NativeType(value="EXRAttribute *")
    public EXRAttribute.Buffer custom_attributes() {
        return EXRHeader.ncustom_attributes(this.address());
    }

    @NativeType(value="EXRChannelInfo *")
    public EXRChannelInfo.Buffer channels() {
        return EXRHeader.nchannels(this.address());
    }

    @NativeType(value="int *")
    public IntBuffer pixel_types() {
        return EXRHeader.npixel_types(this.address());
    }

    public int num_channels() {
        return EXRHeader.nnum_channels(this.address());
    }

    public int compression_type() {
        return EXRHeader.ncompression_type(this.address());
    }

    @NativeType(value="int *")
    public IntBuffer requested_pixel_types() {
        return EXRHeader.nrequested_pixel_types(this.address());
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return EXRHeader.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return EXRHeader.nnameString(this.address());
    }

    public EXRHeader pixel_aspect_ratio(float value) {
        EXRHeader.npixel_aspect_ratio(this.address(), value);
        return this;
    }

    public EXRHeader line_order(int value) {
        EXRHeader.nline_order(this.address(), value);
        return this;
    }

    public EXRHeader data_window(EXRBox2i value) {
        EXRHeader.ndata_window(this.address(), value);
        return this;
    }

    public EXRHeader data_window(Consumer<EXRBox2i> consumer) {
        consumer.accept(this.data_window());
        return this;
    }

    public EXRHeader display_window(EXRBox2i value) {
        EXRHeader.ndisplay_window(this.address(), value);
        return this;
    }

    public EXRHeader display_window(Consumer<EXRBox2i> consumer) {
        consumer.accept(this.display_window());
        return this;
    }

    public EXRHeader screen_window_center(@NativeType(value="float[2]") FloatBuffer value) {
        EXRHeader.nscreen_window_center(this.address(), value);
        return this;
    }

    public EXRHeader screen_window_center(int index, float value) {
        EXRHeader.nscreen_window_center(this.address(), index, value);
        return this;
    }

    public EXRHeader screen_window_width(float value) {
        EXRHeader.nscreen_window_width(this.address(), value);
        return this;
    }

    public EXRHeader chunk_count(int value) {
        EXRHeader.nchunk_count(this.address(), value);
        return this;
    }

    public EXRHeader tiled(@NativeType(value="int") boolean value) {
        EXRHeader.ntiled(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRHeader tile_size_x(int value) {
        EXRHeader.ntile_size_x(this.address(), value);
        return this;
    }

    public EXRHeader tile_size_y(int value) {
        EXRHeader.ntile_size_y(this.address(), value);
        return this;
    }

    public EXRHeader tile_level_mode(int value) {
        EXRHeader.ntile_level_mode(this.address(), value);
        return this;
    }

    public EXRHeader tile_rounding_mode(int value) {
        EXRHeader.ntile_rounding_mode(this.address(), value);
        return this;
    }

    public EXRHeader long_name(@NativeType(value="int") boolean value) {
        EXRHeader.nlong_name(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRHeader non_image(@NativeType(value="int") boolean value) {
        EXRHeader.nnon_image(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRHeader multipart(@NativeType(value="int") boolean value) {
        EXRHeader.nmultipart(this.address(), value ? 1 : 0);
        return this;
    }

    public EXRHeader header_len(@NativeType(value="unsigned int") int value) {
        EXRHeader.nheader_len(this.address(), value);
        return this;
    }

    public EXRHeader num_custom_attributes(int value) {
        EXRHeader.nnum_custom_attributes(this.address(), value);
        return this;
    }

    public EXRHeader custom_attributes(@Nullable @NativeType(value="EXRAttribute *") EXRAttribute.Buffer value) {
        EXRHeader.ncustom_attributes(this.address(), value);
        return this;
    }

    public EXRHeader channels(@NativeType(value="EXRChannelInfo *") EXRChannelInfo.Buffer value) {
        EXRHeader.nchannels(this.address(), value);
        return this;
    }

    public EXRHeader pixel_types(@NativeType(value="int *") IntBuffer value) {
        EXRHeader.npixel_types(this.address(), value);
        return this;
    }

    public EXRHeader num_channels(int value) {
        EXRHeader.nnum_channels(this.address(), value);
        return this;
    }

    public EXRHeader compression_type(int value) {
        EXRHeader.ncompression_type(this.address(), value);
        return this;
    }

    public EXRHeader requested_pixel_types(@NativeType(value="int *") IntBuffer value) {
        EXRHeader.nrequested_pixel_types(this.address(), value);
        return this;
    }

    public EXRHeader name(@NativeType(value="char[256]") ByteBuffer value) {
        EXRHeader.nname(this.address(), value);
        return this;
    }

    public EXRHeader set(float pixel_aspect_ratio, int line_order, EXRBox2i data_window, EXRBox2i display_window, FloatBuffer screen_window_center, float screen_window_width, int chunk_count, boolean tiled, int tile_size_x, int tile_size_y, int tile_level_mode, int tile_rounding_mode, boolean long_name, boolean non_image, boolean multipart, int header_len, int num_custom_attributes, @Nullable EXRAttribute.Buffer custom_attributes, EXRChannelInfo.Buffer channels, IntBuffer pixel_types, int num_channels, int compression_type, IntBuffer requested_pixel_types, ByteBuffer name) {
        this.pixel_aspect_ratio(pixel_aspect_ratio);
        this.line_order(line_order);
        this.data_window(data_window);
        this.display_window(display_window);
        this.screen_window_center(screen_window_center);
        this.screen_window_width(screen_window_width);
        this.chunk_count(chunk_count);
        this.tiled(tiled);
        this.tile_size_x(tile_size_x);
        this.tile_size_y(tile_size_y);
        this.tile_level_mode(tile_level_mode);
        this.tile_rounding_mode(tile_rounding_mode);
        this.long_name(long_name);
        this.non_image(non_image);
        this.multipart(multipart);
        this.header_len(header_len);
        this.num_custom_attributes(num_custom_attributes);
        this.custom_attributes(custom_attributes);
        this.channels(channels);
        this.pixel_types(pixel_types);
        this.num_channels(num_channels);
        this.compression_type(compression_type);
        this.requested_pixel_types(requested_pixel_types);
        this.name(name);
        return this;
    }

    public EXRHeader set(EXRHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EXRHeader malloc() {
        return (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static EXRHeader calloc() {
        return (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static EXRHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static EXRHeader create(long address) {
        return (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)address);
    }

    @Nullable
    public static EXRHeader createSafe(long address) {
        return address == 0L ? null : (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)EXRHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)EXRHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)EXRHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EXRHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)EXRHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)EXRHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)EXRHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static EXRHeader mallocStack() {
        return EXRHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRHeader callocStack() {
        return EXRHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EXRHeader mallocStack(MemoryStack stack) {
        return EXRHeader.malloc(stack);
    }

    @Deprecated
    public static EXRHeader callocStack(MemoryStack stack) {
        return EXRHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EXRHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EXRHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EXRHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EXRHeader.calloc(capacity, stack);
    }

    public static EXRHeader malloc(MemoryStack stack) {
        return (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EXRHeader calloc(MemoryStack stack) {
        return (EXRHeader)EXRHeader.wrap(EXRHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)EXRHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)EXRHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float npixel_aspect_ratio(long struct) {
        return UNSAFE.getFloat(null, struct + (long)PIXEL_ASPECT_RATIO);
    }

    public static int nline_order(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINE_ORDER);
    }

    public static EXRBox2i ndata_window(long struct) {
        return EXRBox2i.create(struct + (long)DATA_WINDOW);
    }

    public static EXRBox2i ndisplay_window(long struct) {
        return EXRBox2i.create(struct + (long)DISPLAY_WINDOW);
    }

    public static FloatBuffer nscreen_window_center(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)SCREEN_WINDOW_CENTER), (int)2);
    }

    public static float nscreen_window_center(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)SCREEN_WINDOW_CENTER + Checks.check((int)index, (int)2) * 4L);
    }

    public static float nscreen_window_width(long struct) {
        return UNSAFE.getFloat(null, struct + (long)SCREEN_WINDOW_WIDTH);
    }

    public static int nchunk_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHUNK_COUNT);
    }

    public static int ntiled(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILED);
    }

    public static int ntile_size_x(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILE_SIZE_X);
    }

    public static int ntile_size_y(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILE_SIZE_Y);
    }

    public static int ntile_level_mode(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILE_LEVEL_MODE);
    }

    public static int ntile_rounding_mode(long struct) {
        return UNSAFE.getInt(null, struct + (long)TILE_ROUNDING_MODE);
    }

    public static int nlong_name(long struct) {
        return UNSAFE.getInt(null, struct + (long)LONG_NAME);
    }

    public static int nnon_image(long struct) {
        return UNSAFE.getInt(null, struct + (long)NON_IMAGE);
    }

    public static int nmultipart(long struct) {
        return UNSAFE.getInt(null, struct + (long)MULTIPART);
    }

    public static int nheader_len(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEADER_LEN);
    }

    public static int nnum_custom_attributes(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_CUSTOM_ATTRIBUTES);
    }

    @Nullable
    public static EXRAttribute.Buffer ncustom_attributes(long struct) {
        return EXRAttribute.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CUSTOM_ATTRIBUTES)), EXRHeader.nnum_custom_attributes(struct));
    }

    public static EXRChannelInfo.Buffer nchannels(long struct) {
        return EXRChannelInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)CHANNELS)), EXRHeader.nnum_channels(struct));
    }

    public static IntBuffer npixel_types(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXEL_TYPES)), (int)EXRHeader.nnum_channels(struct));
    }

    public static int nnum_channels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_CHANNELS);
    }

    public static int ncompression_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPRESSION_TYPE);
    }

    public static IntBuffer nrequested_pixel_types(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)REQUESTED_PIXEL_TYPES)), (int)EXRHeader.nnum_channels(struct));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)NAME));
    }

    public static void npixel_aspect_ratio(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)PIXEL_ASPECT_RATIO, value);
    }

    public static void nline_order(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LINE_ORDER, value);
    }

    public static void ndata_window(long struct, EXRBox2i value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DATA_WINDOW), (long)EXRBox2i.SIZEOF);
    }

    public static void ndisplay_window(long struct, EXRBox2i value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DISPLAY_WINDOW), (long)EXRBox2i.SIZEOF);
    }

    public static void nscreen_window_center(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)SCREEN_WINDOW_CENTER), (long)(value.remaining() * 4));
    }

    public static void nscreen_window_center(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)SCREEN_WINDOW_CENTER + Checks.check((int)index, (int)2) * 4L, value);
    }

    public static void nscreen_window_width(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)SCREEN_WINDOW_WIDTH, value);
    }

    public static void nchunk_count(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHUNK_COUNT, value);
    }

    public static void ntiled(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILED, value);
    }

    public static void ntile_size_x(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILE_SIZE_X, value);
    }

    public static void ntile_size_y(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILE_SIZE_Y, value);
    }

    public static void ntile_level_mode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILE_LEVEL_MODE, value);
    }

    public static void ntile_rounding_mode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TILE_ROUNDING_MODE, value);
    }

    public static void nlong_name(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LONG_NAME, value);
    }

    public static void nnon_image(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NON_IMAGE, value);
    }

    public static void nmultipart(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MULTIPART, value);
    }

    public static void nheader_len(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEADER_LEN, value);
    }

    public static void nnum_custom_attributes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_CUSTOM_ATTRIBUTES, value);
    }

    public static void ncustom_attributes(long struct, @Nullable EXRAttribute.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CUSTOM_ATTRIBUTES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        EXRHeader.nnum_custom_attributes(struct, value == null ? 0 : value.remaining());
    }

    public static void nchannels(long struct, EXRChannelInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CHANNELS), (long)value.address());
    }

    public static void npixel_types(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXEL_TYPES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nnum_channels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM_CHANNELS, value);
    }

    public static void ncompression_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPRESSION_TYPE, value);
    }

    public static void nrequested_pixel_types(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REQUESTED_PIXEL_TYPES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)NAME), (long)value.remaining());
    }

    public static void validate(long struct) {
        int num_custom_attributes = EXRHeader.nnum_custom_attributes(struct);
        long custom_attributes = MemoryUtil.memGetAddress((long)(struct + (long)CUSTOM_ATTRIBUTES));
        if (custom_attributes != 0L) {
            EXRHeader.validate((long)custom_attributes, (int)num_custom_attributes, (int)EXRAttribute.SIZEOF, EXRAttribute::validate);
        }
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CHANNELS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXEL_TYPES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REQUESTED_PIXEL_TYPES)));
    }

    static {
        Struct.Layout layout = EXRHeader.__struct((Struct.Member[])new Struct.Member[]{EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)EXRBox2i.SIZEOF, (int)EXRBox2i.ALIGNOF), EXRHeader.__member((int)EXRBox2i.SIZEOF, (int)EXRBox2i.ALIGNOF), EXRHeader.__array((int)4, (int)2), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)POINTER_SIZE), EXRHeader.__member((int)POINTER_SIZE), EXRHeader.__member((int)POINTER_SIZE), EXRHeader.__member((int)4), EXRHeader.__member((int)4), EXRHeader.__member((int)POINTER_SIZE), EXRHeader.__array((int)1, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXEL_ASPECT_RATIO = layout.offsetof(0);
        LINE_ORDER = layout.offsetof(1);
        DATA_WINDOW = layout.offsetof(2);
        DISPLAY_WINDOW = layout.offsetof(3);
        SCREEN_WINDOW_CENTER = layout.offsetof(4);
        SCREEN_WINDOW_WIDTH = layout.offsetof(5);
        CHUNK_COUNT = layout.offsetof(6);
        TILED = layout.offsetof(7);
        TILE_SIZE_X = layout.offsetof(8);
        TILE_SIZE_Y = layout.offsetof(9);
        TILE_LEVEL_MODE = layout.offsetof(10);
        TILE_ROUNDING_MODE = layout.offsetof(11);
        LONG_NAME = layout.offsetof(12);
        NON_IMAGE = layout.offsetof(13);
        MULTIPART = layout.offsetof(14);
        HEADER_LEN = layout.offsetof(15);
        NUM_CUSTOM_ATTRIBUTES = layout.offsetof(16);
        CUSTOM_ATTRIBUTES = layout.offsetof(17);
        CHANNELS = layout.offsetof(18);
        PIXEL_TYPES = layout.offsetof(19);
        NUM_CHANNELS = layout.offsetof(20);
        COMPRESSION_TYPE = layout.offsetof(21);
        REQUESTED_PIXEL_TYPES = layout.offsetof(22);
        NAME = layout.offsetof(23);
    }

    public static class Buffer
    extends StructBuffer<EXRHeader, Buffer>
    implements NativeResource {
        private static final EXRHeader ELEMENT_FACTORY = EXRHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected EXRHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float pixel_aspect_ratio() {
            return EXRHeader.npixel_aspect_ratio(this.address());
        }

        public int line_order() {
            return EXRHeader.nline_order(this.address());
        }

        public EXRBox2i data_window() {
            return EXRHeader.ndata_window(this.address());
        }

        public EXRBox2i display_window() {
            return EXRHeader.ndisplay_window(this.address());
        }

        @NativeType(value="float[2]")
        public FloatBuffer screen_window_center() {
            return EXRHeader.nscreen_window_center(this.address());
        }

        public float screen_window_center(int index) {
            return EXRHeader.nscreen_window_center(this.address(), index);
        }

        public float screen_window_width() {
            return EXRHeader.nscreen_window_width(this.address());
        }

        public int chunk_count() {
            return EXRHeader.nchunk_count(this.address());
        }

        @NativeType(value="int")
        public boolean tiled() {
            return EXRHeader.ntiled(this.address()) != 0;
        }

        public int tile_size_x() {
            return EXRHeader.ntile_size_x(this.address());
        }

        public int tile_size_y() {
            return EXRHeader.ntile_size_y(this.address());
        }

        public int tile_level_mode() {
            return EXRHeader.ntile_level_mode(this.address());
        }

        public int tile_rounding_mode() {
            return EXRHeader.ntile_rounding_mode(this.address());
        }

        @NativeType(value="int")
        public boolean long_name() {
            return EXRHeader.nlong_name(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean non_image() {
            return EXRHeader.nnon_image(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean multipart() {
            return EXRHeader.nmultipart(this.address()) != 0;
        }

        @NativeType(value="unsigned int")
        public int header_len() {
            return EXRHeader.nheader_len(this.address());
        }

        public int num_custom_attributes() {
            return EXRHeader.nnum_custom_attributes(this.address());
        }

        @Nullable
        @NativeType(value="EXRAttribute *")
        public EXRAttribute.Buffer custom_attributes() {
            return EXRHeader.ncustom_attributes(this.address());
        }

        @NativeType(value="EXRChannelInfo *")
        public EXRChannelInfo.Buffer channels() {
            return EXRHeader.nchannels(this.address());
        }

        @NativeType(value="int *")
        public IntBuffer pixel_types() {
            return EXRHeader.npixel_types(this.address());
        }

        public int num_channels() {
            return EXRHeader.nnum_channels(this.address());
        }

        public int compression_type() {
            return EXRHeader.ncompression_type(this.address());
        }

        @NativeType(value="int *")
        public IntBuffer requested_pixel_types() {
            return EXRHeader.nrequested_pixel_types(this.address());
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return EXRHeader.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return EXRHeader.nnameString(this.address());
        }

        public Buffer pixel_aspect_ratio(float value) {
            EXRHeader.npixel_aspect_ratio(this.address(), value);
            return this;
        }

        public Buffer line_order(int value) {
            EXRHeader.nline_order(this.address(), value);
            return this;
        }

        public Buffer data_window(EXRBox2i value) {
            EXRHeader.ndata_window(this.address(), value);
            return this;
        }

        public Buffer data_window(Consumer<EXRBox2i> consumer) {
            consumer.accept(this.data_window());
            return this;
        }

        public Buffer display_window(EXRBox2i value) {
            EXRHeader.ndisplay_window(this.address(), value);
            return this;
        }

        public Buffer display_window(Consumer<EXRBox2i> consumer) {
            consumer.accept(this.display_window());
            return this;
        }

        public Buffer screen_window_center(@NativeType(value="float[2]") FloatBuffer value) {
            EXRHeader.nscreen_window_center(this.address(), value);
            return this;
        }

        public Buffer screen_window_center(int index, float value) {
            EXRHeader.nscreen_window_center(this.address(), index, value);
            return this;
        }

        public Buffer screen_window_width(float value) {
            EXRHeader.nscreen_window_width(this.address(), value);
            return this;
        }

        public Buffer chunk_count(int value) {
            EXRHeader.nchunk_count(this.address(), value);
            return this;
        }

        public Buffer tiled(@NativeType(value="int") boolean value) {
            EXRHeader.ntiled(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer tile_size_x(int value) {
            EXRHeader.ntile_size_x(this.address(), value);
            return this;
        }

        public Buffer tile_size_y(int value) {
            EXRHeader.ntile_size_y(this.address(), value);
            return this;
        }

        public Buffer tile_level_mode(int value) {
            EXRHeader.ntile_level_mode(this.address(), value);
            return this;
        }

        public Buffer tile_rounding_mode(int value) {
            EXRHeader.ntile_rounding_mode(this.address(), value);
            return this;
        }

        public Buffer long_name(@NativeType(value="int") boolean value) {
            EXRHeader.nlong_name(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer non_image(@NativeType(value="int") boolean value) {
            EXRHeader.nnon_image(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer multipart(@NativeType(value="int") boolean value) {
            EXRHeader.nmultipart(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer header_len(@NativeType(value="unsigned int") int value) {
            EXRHeader.nheader_len(this.address(), value);
            return this;
        }

        public Buffer num_custom_attributes(int value) {
            EXRHeader.nnum_custom_attributes(this.address(), value);
            return this;
        }

        public Buffer custom_attributes(@Nullable @NativeType(value="EXRAttribute *") EXRAttribute.Buffer value) {
            EXRHeader.ncustom_attributes(this.address(), value);
            return this;
        }

        public Buffer channels(@NativeType(value="EXRChannelInfo *") EXRChannelInfo.Buffer value) {
            EXRHeader.nchannels(this.address(), value);
            return this;
        }

        public Buffer pixel_types(@NativeType(value="int *") IntBuffer value) {
            EXRHeader.npixel_types(this.address(), value);
            return this;
        }

        public Buffer num_channels(int value) {
            EXRHeader.nnum_channels(this.address(), value);
            return this;
        }

        public Buffer compression_type(int value) {
            EXRHeader.ncompression_type(this.address(), value);
            return this;
        }

        public Buffer requested_pixel_types(@NativeType(value="int *") IntBuffer value) {
            EXRHeader.nrequested_pixel_types(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            EXRHeader.nname(this.address(), value);
            return this;
        }
    }
}

