/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;
import org.snmp4j.log.NoLogger;

public class LogFactory {
    public static final String SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY = "snmp4j.LogFactory";
    public static final String SNMP4J_LOG_FACTORY_LOGGER_DEFAULT_PREFIX = "snmp4j.log.logger.";
    public static final String SNMP4J_LOG_FACTORY_LOG_HANDLER_DEFAULT_PREFIX = "snmp4j.log.handler.";
    public static final String SNMP4J_LOG_ID = "id";
    public static final String SNMP4J_LOG_LEVEL = "level";
    public static final String SNMP4J_LOG_HANDLER = "handler";
    public static final String SNMP4J_LOG_HANDLER_LIST = "handlers";
    private static LogFactory snmp4jLogFactory = null;
    private static boolean configChecked = false;
    private String loggerConfigPrefix = "snmp4j.log.logger.";
    private String logHandlerConfigPrefix = "snmp4j.log.handler.";
    private final ReentrantLock configurationLock = new ReentrantLock();

    public static LogAdapter getLogger(Class<?> c) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(c.getName());
    }

    private static void checkConfig() {
        if (!configChecked) {
            configChecked = true;
            LogFactory.getFactoryFromSystemProperty();
        }
    }

    private static synchronized void getFactoryFromSystemProperty() {
        block4: {
            try {
                String factory = System.getProperty(SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY, null);
                if (factory == null) break block4;
                try {
                    Class<?> c = Class.forName(factory);
                    snmp4jLogFactory = (LogFactory)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (SecurityException sec) {
                throw new RuntimeException(sec);
            }
        }
    }

    public LogAdapter getRootLogger() {
        return NoLogger.instance;
    }

    public static LogAdapter getLogger(String className) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(className);
    }

    protected LogAdapter createLogger(Class<?> c) {
        return NoLogger.instance;
    }

    protected LogAdapter createLogger(String className) {
        return NoLogger.instance;
    }

    public static void setLogFactory(LogFactory factory) {
        configChecked = true;
        if (snmp4jLogFactory != null && snmp4jLogFactory.getRootLogger().isWarnEnabled()) {
            snmp4jLogFactory.getRootLogger().warn((Serializable)((Object)("LogFactory " + String.valueOf(snmp4jLogFactory) + " is being reset by " + String.valueOf(factory))));
        }
        snmp4jLogFactory = factory;
    }

    public static LogFactory getLogFactory() {
        if (snmp4jLogFactory == null) {
            return new LogFactory();
        }
        return snmp4jLogFactory;
    }

    public Iterator<LogAdapter> loggers() {
        return Collections.singletonList(NoLogger.instance).iterator();
    }

    public void resetLogger(LogAdapter logger) {
    }

    public String getLoggerConfigPrefix() {
        return this.loggerConfigPrefix;
    }

    public void setLoggerConfigPrefix(String loggerConfigPrefix) {
        this.loggerConfigPrefix = loggerConfigPrefix;
    }

    public String getLogHandlerConfigPrefix() {
        return this.logHandlerConfigPrefix;
    }

    public void setLogHandlerConfigPrefix(String logHandlerConfigPrefix) {
        this.logHandlerConfigPrefix = logHandlerConfigPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.configurationLock.lock();
        try {
            LogAdapter rootLogger = this.getRootLogger();
            Iterator<LogAdapter> it = this.loggers();
            while (it.hasNext()) {
                LogAdapter logAdapter = it.next();
                logAdapter.setLogLevel(null);
            }
            rootLogger.setLogLevel(LogLevel.INFO);
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Properties config) {
        HashMap<String, Map<String, String>> loggerConfig = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> logHandlerConfig = new HashMap<String, Map<String, String>>();
        String loggerConfigPrefix = this.getLoggerConfigPrefix();
        String logHandlerConfigPrefix = this.getLogHandlerConfigPrefix();
        for (Object object : config.keySet()) {
            if (!(object instanceof String)) continue;
            if (((String)object).startsWith(loggerConfigPrefix)) {
                this.extractConfigProperty(config, loggerConfig, (String)object);
                continue;
            }
            if (!((String)object).startsWith(logHandlerConfigPrefix)) continue;
            this.extractConfigProperty(config, logHandlerConfig, (String)object);
        }
        this.configurationLock.lock();
        try {
            Iterator<LogAdapter> it = this.loggers();
            while (it.hasNext()) {
                LogAdapter logAdapter = it.next();
                if (loggerConfig.containsKey(logAdapter.getName())) {
                    Map<String, String> newConfigAttributes = loggerConfig.getOrDefault(logAdapter.getName(), Collections.emptyMap());
                    this.updateLogger(logAdapter, newConfigAttributes);
                    if (newConfigAttributes.containsKey(SNMP4J_LOG_HANDLER_LIST)) {
                        String[] handlerNames;
                        String handlerList = newConfigAttributes.get(SNMP4J_LOG_HANDLER_LIST);
                        for (String handlerName : handlerNames = handlerList.split("(\\s|,)*")) {
                            this.addHandler(logAdapter, handlerName, (Map)logHandlerConfig.get(handlerName));
                        }
                    }
                    loggerConfig.remove(logAdapter.getName());
                    continue;
                }
                this.resetLogger(logAdapter);
            }
            for (Map.Entry entry : loggerConfig.entrySet()) {
                LogAdapter logAdapter = this.createLogger((String)entry.getKey());
                logAdapter.setLogLevel(LogLevel.toLevel((String)((Map)entry.getValue()).get(SNMP4J_LOG_LEVEL)));
            }
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    private void extractConfigProperty(Properties newProperties, Map<String, Map<String, String>> config, String key) {
        try {
            int endOfPrefixPos = this.getLoggerConfigPrefix().length();
            String attribute = key.substring(endOfPrefixPos, key.indexOf(46, endOfPrefixPos));
            String id = key.substring(endOfPrefixPos + attribute.length() + 1);
            Map attributes = config.computeIfAbsent(id, k -> new TreeMap());
            attributes.put(attribute, newProperties.getProperty(key));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void removeAllHandlers(LogAdapter logAdapter) {
    }

    protected void addHandler(LogAdapter logAdapter, String handlerName, Map<String, String> handlerConfig) {
    }

    protected void updateLogger(LogAdapter logAdapter, Map<String, String> loggerConfig) {
        logAdapter.setLogLevel(LogLevel.toLevel(loggerConfig.get(SNMP4J_LOG_LEVEL)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(Properties config) {
        this.configurationLock.lock();
        try {
            Iterator<LogAdapter> it = this.loggers();
            while (it.hasNext()) {
                LogAdapter logAdapter = it.next();
                this.writeConfiguration(config, logAdapter);
            }
        }
        finally {
            this.configurationLock.unlock();
        }
    }

    protected void writeConfiguration(Properties config, LogAdapter logAdapter) {
        config.put(this.getLoggerConfigPrefix() + "level." + logAdapter.getName(), logAdapter.getLogLevel().toString());
        Iterator<?> handler = logAdapter.getLogHandler();
        StringBuilder stringBuilder = new StringBuilder();
        while (handler.hasNext()) {
            String handlerName = this.writeConfiguration(config, logAdapter, handler.next());
            stringBuilder.append(handlerName);
            if (!handler.hasNext()) continue;
            stringBuilder.append(' ');
        }
        if (!stringBuilder.toString().trim().isEmpty()) {
            config.put(this.getLoggerConfigPrefix() + logAdapter.getName() + ".handlers", stringBuilder.toString());
        } else {
            config.remove(this.getLoggerConfigPrefix() + logAdapter.getName() + ".handlers");
        }
    }

    protected String writeConfiguration(Properties config, LogAdapter logAdapter, Object handler) {
        return "";
    }
}

