/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class KeepAliveSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory delegate;
    private static final KeepAliveSocketFactory singletonKeepAliveSocketFactory = new KeepAliveSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory());

    KeepAliveSocketFactory(SSLSocketFactory delegate) {
        this.delegate = delegate;
    }

    public static KeepAliveSocketFactory getInstance() {
        return singletonKeepAliveSocketFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        Socket ret = this.delegate.createSocket(socket, s, i, b);
        ret.setKeepAlive(true);
        return ret;
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
        Socket ret = this.delegate.createSocket(s, i);
        ret.setKeepAlive(true);
        return ret;
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        Socket ret = this.delegate.createSocket(s, i, inetAddress, i1);
        ret.setKeepAlive(true);
        return ret;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        Socket ret = this.delegate.createSocket(inetAddress, i);
        ret.setKeepAlive(true);
        return ret;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        Socket ret = this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
        ret.setKeepAlive(true);
        return ret;
    }
}

