/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import nokogiri.NokogiriService;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriEntityResolver;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.ParserContext;
import nokogiri.internals.ReaderNode;
import org.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.EntityResolver2Wrapper;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.ext.EntityResolver2;

@JRubyClass(name={"Nokogiri::XML::Reader"})
public class XmlReader
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final int XML_TEXTREADER_MODE_INITIAL = 0;
    private static final int XML_TEXTREADER_MODE_INTERACTIVE = 1;
    private static final int XML_TEXTREADER_MODE_ERROR = 2;
    private static final int XML_TEXTREADER_MODE_EOF = 3;
    private static final int XML_TEXTREADER_MODE_CLOSED = 4;
    private static final int XML_TEXTREADER_MODE_READING = 5;
    List<ReaderNode> nodeQueue;
    private int state;
    private int position = 0;
    private XMLPullParserConfiguration config;
    private boolean continueParsing = true;

    public XmlReader(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void init(Ruby ruby) {
        this.nodeQueue = new LinkedList<ReaderNode>();
        this.nodeQueue.add(new ReaderNode.EmptyNode(ruby));
    }

    private void setInput(ThreadContext threadContext, InputStream inputStream, IRubyObject iRubyObject, ParserContext.Options options) {
        this.setState(5);
        this.config = this.createReader(threadContext.getRuntime(), options);
        InputSource inputSource = new InputSource();
        ParserContext.setUrl(threadContext, inputSource, iRubyObject);
        XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null, inputStream, null);
        try {
            this.config.setInputSource(xMLInputSource);
        }
        catch (IOException iOException) {
            throw threadContext.getRuntime().newRuntimeError(iOException.getMessage());
        }
        this.setState(4);
    }

    private void setState(int n) {
        this.state = n;
    }

    @JRubyMethod
    public IRubyObject attribute(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.currentNode().getAttributeByName(iRubyObject);
    }

    @JRubyMethod
    public IRubyObject attribute_at(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.currentNode().getAttributeByIndex(iRubyObject);
    }

    @JRubyMethod
    public IRubyObject attribute_count(ThreadContext threadContext) {
        return this.currentNode().getAttributeCount();
    }

    @JRubyMethod
    public IRubyObject attribute_hash(ThreadContext threadContext) {
        return this.currentNode().getAttributes(threadContext);
    }

    @JRubyMethod(name={"attributes?"})
    public IRubyObject attributes_p(ThreadContext threadContext) {
        return this.currentNode().hasAttributes();
    }

    @JRubyMethod
    public IRubyObject base_uri(ThreadContext threadContext) {
        return this.currentNode().getXmlBase();
    }

    @JRubyMethod(name={"default?"})
    public IRubyObject default_p(ThreadContext threadContext) {
        return this.currentNode().isDefault();
    }

    @JRubyMethod
    public IRubyObject depth(ThreadContext threadContext) {
        return this.currentNode().getDepth();
    }

    @JRubyMethod(name={"empty_element?", "self_closing?"})
    public IRubyObject empty_element_p(ThreadContext threadContext) {
        ReaderNode readerNode = this.currentNode();
        this.ensureNodeClosed(threadContext);
        if (readerNode == null) {
            return threadContext.getRuntime().getNil();
        }
        if (!(readerNode instanceof ReaderNode.ElementNode)) {
            threadContext.getRuntime().getFalse();
        }
        return RubyBoolean.newBoolean((Ruby)threadContext.getRuntime(), (!readerNode.hasChildren ? 1 : 0) != 0);
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext threadContext) {
        IRubyObject iRubyObject = this.getInstanceVariable("@encoding");
        if (!iRubyObject.isNil()) {
            return iRubyObject;
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject from_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray[0].isNil()) {
            throw ruby.newArgumentError("io cannot be nil");
        }
        XmlReader xmlReader = (XmlReader)NokogiriService.XML_READER_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Reader"));
        xmlReader.init(ruby);
        xmlReader.setInstanceVariable("@source", iRubyObjectArray[0]);
        xmlReader.setInstanceVariable("@errors", (IRubyObject)ruby.newArray());
        IRubyObject iRubyObject2 = threadContext.nil;
        if (iRubyObjectArray.length > 1) {
            iRubyObject2 = iRubyObjectArray[1];
        }
        if (iRubyObjectArray.length > 2) {
            xmlReader.setInstanceVariable("@encoding", iRubyObjectArray[2]);
        }
        ParserContext.Options options = iRubyObjectArray.length > 3 ? new ParserContext.Options((Long)iRubyObjectArray[3].toJava(Long.class)) : new ParserContext.Options(2049L);
        IOInputStream iOInputStream = new IOInputStream(iRubyObjectArray[0]);
        xmlReader.setInput(threadContext, (InputStream)iOInputStream, iRubyObject2, options);
        return xmlReader;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject from_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObjectArray[0].isNil()) {
            throw ruby.newArgumentError("string cannot be nil");
        }
        XmlReader xmlReader = (XmlReader)NokogiriService.XML_READER_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Reader"));
        xmlReader.init(ruby);
        xmlReader.setInstanceVariable("@source", iRubyObjectArray[0]);
        xmlReader.setInstanceVariable("@errors", (IRubyObject)ruby.newArray());
        IRubyObject iRubyObject2 = threadContext.nil;
        if (iRubyObjectArray.length > 1) {
            iRubyObject2 = iRubyObjectArray[1];
        }
        if (iRubyObjectArray.length > 2) {
            xmlReader.setInstanceVariable("@encoding", iRubyObjectArray[2]);
        }
        ParserContext.Options options = iRubyObjectArray.length > 3 ? new ParserContext.Options((Long)iRubyObjectArray[3].toJava(Long.class)) : new ParserContext.Options(2049L);
        IRubyObject iRubyObject3 = ruby.getClass("StringIO").newInstance(threadContext, iRubyObjectArray[0], Block.NULL_BLOCK);
        IOInputStream iOInputStream = new IOInputStream(iRubyObject3);
        xmlReader.setInput(threadContext, (InputStream)iOInputStream, iRubyObject2, options);
        return xmlReader;
    }

    @JRubyMethod
    public IRubyObject node_type(ThreadContext threadContext) {
        IRubyObject iRubyObject = this.currentNode().getNodeType();
        return iRubyObject == null ? RubyFixnum.zero((Ruby)threadContext.getRuntime()) : iRubyObject;
    }

    @JRubyMethod
    public IRubyObject inner_xml(ThreadContext threadContext) {
        this.ensureNodeClosed(threadContext);
        return NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), this.getInnerXml(this.currentNode()));
    }

    private String getInnerXml(ReaderNode readerNode) {
        if (readerNode.depth < 0) {
            return null;
        }
        if (!readerNode.hasChildren) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = readerNode.startOffset + 1; i <= readerNode.endOffset - 1; ++i) {
            stringBuffer.append(this.nodeQueue.get(i).getString());
        }
        return new String(stringBuffer);
    }

    @JRubyMethod
    public IRubyObject outer_xml(ThreadContext threadContext) {
        this.ensureNodeClosed(threadContext);
        return NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), this.getOuterXml());
    }

    private String getOuterXml() {
        ReaderNode readerNode = this.currentNode();
        if (readerNode == null || readerNode.depth < 0) {
            return null;
        }
        if (readerNode instanceof ReaderNode.ClosingNode) {
            return "<" + readerNode.name + "/>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.position; i <= readerNode.endOffset; ++i) {
            stringBuilder.append(this.nodeQueue.get(i).getString());
        }
        return new String(stringBuilder);
    }

    @JRubyMethod
    public IRubyObject lang(ThreadContext threadContext) {
        return this.currentNode().getLang();
    }

    @JRubyMethod
    public IRubyObject local_name(ThreadContext threadContext) {
        return this.currentNode().getLocalName();
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext threadContext) {
        return this.currentNode().getName();
    }

    @JRubyMethod
    public IRubyObject namespace_uri(ThreadContext threadContext) {
        return this.currentNode().getUri();
    }

    @JRubyMethod
    public IRubyObject namespaces(ThreadContext threadContext) {
        return this.currentNode().getNamespaces(threadContext);
    }

    @JRubyMethod
    public IRubyObject prefix(ThreadContext threadContext) {
        return this.currentNode().getPrefix();
    }

    private void readMoreData(ThreadContext threadContext) {
        if (!this.continueParsing) {
            throw threadContext.runtime.newRuntimeError("Cannot parse more data");
        }
        try {
            this.continueParsing = this.config.parse(false);
        }
        catch (XNIException xNIException) {
            throw XmlSyntaxError.createXMLSyntaxError(threadContext.runtime, (Exception)((Object)xNIException)).toThrowable();
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newRuntimeError(iOException.toString());
        }
    }

    private void ensureNodeClosed(ThreadContext threadContext) {
        ReaderNode readerNode = this.currentNode();
        if (readerNode instanceof ReaderNode.TextNode) {
            return;
        }
        while (readerNode.endOffset < 1) {
            this.readMoreData(threadContext);
        }
    }

    @JRubyMethod
    public IRubyObject read(ThreadContext threadContext) {
        ++this.position;
        try {
            while (this.nodeQueue.size() <= this.position && this.continueParsing) {
                this.readMoreData(threadContext);
            }
            return this.setAndRaiseErrorsIfAny(threadContext.runtime, null);
        }
        catch (RaiseException raiseException) {
            return this.setAndRaiseErrorsIfAny(threadContext.runtime, raiseException);
        }
    }

    private IRubyObject setAndRaiseErrorsIfAny(Ruby ruby, RaiseException raiseException) throws RaiseException {
        ReaderNode readerNode = this.currentNode();
        if (readerNode == null) {
            return ruby.getNil();
        }
        if (readerNode.isError()) {
            RubyArray rubyArray = (RubyArray)this.getInstanceVariable("@errors");
            IRubyObject iRubyObject = readerNode.toSyntaxError();
            rubyArray.append(iRubyObject);
            this.setInstanceVariable("@errors", (IRubyObject)rubyArray);
            throw raiseException != null ? raiseException : ((XmlSyntaxError)iRubyObject).toThrowable();
        }
        if (raiseException != null) {
            throw raiseException;
        }
        return this;
    }

    private ReaderNode currentNode() {
        if (this.position >= this.nodeQueue.size()) {
            return null;
        }
        return this.nodeQueue.get(this.position);
    }

    @JRubyMethod
    public IRubyObject state(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.state);
    }

    @JRubyMethod
    public IRubyObject value(ThreadContext threadContext) {
        return this.currentNode().getValue();
    }

    @JRubyMethod(name={"value?"})
    public IRubyObject value_p(ThreadContext threadContext) {
        return this.currentNode().hasValue();
    }

    @JRubyMethod
    public IRubyObject xml_version(ThreadContext threadContext) {
        return this.currentNode().getXmlVersion();
    }

    protected XMLPullParserConfiguration createReader(Ruby ruby, ParserContext.Options options) {
        StandardParserConfiguration standardParserConfiguration = new StandardParserConfiguration();
        DocumentHandler documentHandler = new DocumentHandler(ruby);
        standardParserConfiguration.setDocumentHandler((XMLDocumentHandler)documentHandler);
        standardParserConfiguration.setDTDHandler((XMLDTDHandler)documentHandler);
        standardParserConfiguration.setErrorHandler((XMLErrorHandler)documentHandler);
        standardParserConfiguration.setEntityResolver((XMLEntityResolver)new EntityResolver2Wrapper((EntityResolver2)new NokogiriEntityResolver(ruby, null, options)));
        standardParserConfiguration.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", options.dtdLoad || options.dtdValid);
        return standardParserConfiguration;
    }

    private class DocumentHandler
    extends DefaultXMLDocumentHandler
    implements XMLErrorHandler {
        Stack<String> langStack;
        int depth;
        Stack<String> xmlBaseStack;
        Stack<ReaderNode.ElementNode> elementStack;
        private final Ruby ruby;

        public DocumentHandler(Ruby ruby) {
            this.ruby = ruby;
        }

        public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
            Object object;
            if (augmentations != null && (object = augmentations.getItem("ENTITY_SKIPPED")) != null && ((Boolean)object).booleanValue()) {
                XmlReader.this.nodeQueue.add(new ReaderNode.ExceptionNode(this.ruby, null));
            }
        }

        public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) {
            this.depth = 0;
            this.langStack = new Stack();
            this.xmlBaseStack = new Stack();
            this.elementStack = new Stack();
        }

        public void endDocument(Augmentations augmentations) {
            this.langStack = null;
            this.xmlBaseStack = null;
            this.elementStack = null;
        }

        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
            this.commonElement(qName, xMLAttributes, false);
        }

        public void endElement(QName qName, Augmentations augmentations) {
            String string = qName.uri;
            String string2 = qName.localpart;
            String string3 = qName.rawname;
            --this.depth;
            ReaderNode.ElementNode elementNode = this.elementStack.pop();
            ReaderNode.ClosingNode closingNode = ReaderNode.createClosingNode(this.ruby, string, string2, string3, this.depth, this.langStack, this.xmlBaseStack);
            elementNode.endOffset = XmlReader.this.nodeQueue.size() - 1;
            if (elementNode.endOffset != elementNode.startOffset) {
                closingNode.attributeList = elementNode.attributeList;
                closingNode.namespaces = elementNode.namespaces;
                closingNode.startOffset = elementNode.startOffset;
                closingNode.endOffset = ++elementNode.endOffset;
                elementNode.hasChildren = true;
                closingNode.hasChildren = true;
                XmlReader.this.nodeQueue.add(closingNode);
            }
            if (!this.langStack.isEmpty()) {
                this.langStack.pop();
            }
            if (!this.xmlBaseStack.isEmpty()) {
                this.xmlBaseStack.pop();
            }
        }

        public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
            this.commonElement(qName, xMLAttributes, true);
        }

        private void commonElement(QName qName, XMLAttributes xMLAttributes, boolean bl) {
            String string = qName.rawname;
            String string2 = qName.uri;
            String string3 = qName.localpart;
            ReaderNode.ElementNode elementNode = ReaderNode.createElementNode(this.ruby, string2, string3, string, xMLAttributes, this.depth, this.langStack, this.xmlBaseStack);
            if (!this.elementStack.isEmpty()) {
                ReaderNode.ElementNode elementNode2 = this.elementStack.peek();
                elementNode2.hasChildren = true;
            }
            XmlReader.this.nodeQueue.add(elementNode);
            elementNode.startOffset = XmlReader.this.nodeQueue.size() - 1;
            if (!bl) {
                ++this.depth;
                if (elementNode.lang != null) {
                    this.langStack.push(elementNode.lang);
                }
                if (elementNode.xmlBase != null) {
                    this.xmlBaseStack.push(elementNode.xmlBase);
                }
                this.elementStack.push(elementNode);
            } else {
                elementNode.endOffset = elementNode.startOffset;
                elementNode.hasChildren = false;
            }
        }

        public void characters(XMLString xMLString, Augmentations augmentations) {
            ReaderNode.TextNode textNode = ReaderNode.createTextNode(this.ruby, xMLString.toString(), this.depth, this.langStack, this.xmlBaseStack);
            XmlReader.this.nodeQueue.add(textNode);
            textNode.startOffset = textNode.endOffset = XmlReader.this.nodeQueue.size() - 1;
        }

        public void error(String string, String string2, XMLParseException xMLParseException) {
            XmlReader.this.nodeQueue.add(new ReaderNode.ExceptionNode(this.ruby, (Exception)xMLParseException));
            throw xMLParseException;
        }

        public void fatalError(String string, String string2, XMLParseException xMLParseException) {
            XmlReader.this.nodeQueue.add(new ReaderNode.ExceptionNode(this.ruby, (Exception)xMLParseException));
            throw xMLParseException;
        }

        public void warning(String string, String string2, XMLParseException xMLParseException) {
            XmlReader.this.nodeQueue.add(new ReaderNode.ExceptionNode(this.ruby, (Exception)xMLParseException));
            throw xMLParseException;
        }
    }
}

