/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class BinaryOperatorNode
extends OperatorNode {
    String operator;
    String methodName;
    ValueNode receiver;
    static final int PLUS = 1;
    static final int MINUS = 2;
    static final int TIMES = 3;
    static final int DIVIDE = 4;
    static final int CONCATENATE = 5;
    static final int EQ = 6;
    static final int NE = 7;
    static final int GT = 8;
    static final int GE = 9;
    static final int LT = 10;
    static final int LE = 11;
    static final int AND = 12;
    static final int OR = 13;
    static final int LIKE = 14;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String leftInterfaceType;
    String rightInterfaceType;
    String resultInterfaceType;
    static final int K_XMLEXISTS = 0;
    static final int K_XMLQUERY = 1;
    static final int K_BASE = 2;
    final int kind;
    static final String[] BinaryOperators = new String[]{"xmlexists", "xmlquery"};
    static final String[] BinaryMethodNames = new String[]{"XMLExists", "XMLQuery"};
    static final String[] BinaryResultTypes = new String[]{"org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    static final String[][] BinaryArgTypes = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"}};
    private String xmlQuery;

    BinaryOperatorNode(ContextManager cm) {
        super(cm);
        this.kind = 2;
    }

    BinaryOperatorNode(ValueNode leftOperand, ValueNode rightOperand, String operator, String methodName, String leftInterfaceType, String rightInterfaceType, ContextManager cm) {
        super(cm);
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.operator = operator;
        this.methodName = methodName;
        this.leftInterfaceType = leftInterfaceType;
        this.rightInterfaceType = rightInterfaceType;
        this.kind = 2;
    }

    BinaryOperatorNode(ValueNode leftOperand, ValueNode rightOperand, String leftInterfaceType, String rightInterfaceType, ContextManager cm) {
        super(cm);
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.leftInterfaceType = leftInterfaceType;
        this.rightInterfaceType = rightInterfaceType;
        this.kind = 2;
    }

    BinaryOperatorNode(ValueNode leftOperand, ValueNode rightOperand, int kind, ContextManager cm) {
        super(cm);
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.kind = kind;
        this.operator = BinaryOperators[this.kind];
        this.methodName = BinaryMethodNames[this.kind];
        this.leftInterfaceType = BinaryArgTypes[this.kind][0];
        this.rightInterfaceType = BinaryArgTypes[this.kind][1];
        this.resultInterfaceType = BinaryResultTypes[this.kind];
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\nmethodName: " + this.methodName + "\n" + super.toString();
    }

    void setOperator(String operator) {
        this.operator = operator;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    void setLeftRightInterfaceType(String iType) {
        this.leftInterfaceType = iType;
        this.rightInterfaceType = iType;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperand != null) {
            this.printLabel(depth, "rightOperand: ");
            this.rightOperand.treePrint(depth + 1);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregates);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, aggregates);
        if (this.kind == 0 || this.kind == 1) {
            return this.bindXMLQuery();
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperand.requiresTypeFromContext()) {
                throw StandardException.newException((String)"42X35", (Object[])new Object[]{this.operator});
            }
            this.leftOperand.setType(this.rightOperand.getTypeServices());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(this.leftOperand.getTypeServices());
        }
        return this.genSQLJavaSQLTree();
    }

    public ValueNode bindXMLQuery() throws StandardException {
        TypeId rightOperandType = this.rightOperand.getTypeId();
        if (!(this.leftOperand instanceof CharConstantNode)) {
            throw StandardException.newException((String)"42Z75", (Object[])new Object[0]);
        }
        this.xmlQuery = ((CharConstantNode)this.leftOperand).getString();
        if (rightOperandType != null && !rightOperandType.isXMLTypeId()) {
            throw StandardException.newException((String)"42Z77", (Object[])new Object[]{rightOperandType.getSQLTypeName()});
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            throw StandardException.newException((String)"42Z70", (Object[])new Object[0]);
        }
        if (this.kind == 0) {
            this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        } else {
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
        }
        return this.genSQLJavaSQLTree();
    }

    @Override
    ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId rightTypeId;
        TypeId leftTypeId = this.leftOperand.getTypeId();
        if (leftTypeId.userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((rightTypeId = this.rightOperand.getTypeId()).userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        LocalField resultField;
        int numArgs;
        String receiverType;
        boolean xmlGen;
        InListOperatorNode ilon;
        if (this instanceof BinaryRelationalOperatorNode && (ilon = ((BinaryRelationalOperatorNode)this).getInListOp()) != null) {
            ilon.generateExpression(acb, mb);
            return;
        }
        boolean bl = xmlGen = this.kind == 1 || this.kind == 0;
        if (this.leftOperand.getTypeId().typePrecedence() > this.rightOperand.getTypeId().typePrecedence()) {
            this.receiver = this.leftOperand;
            receiverType = this.kind == 2 ? this.getReceiverInterfaceName() : this.leftInterfaceType;
            this.leftOperand.generateExpression(acb, mb);
            mb.cast(receiverType);
            mb.dup();
            mb.cast(this.leftInterfaceType);
            this.rightOperand.generateExpression(acb, mb);
            mb.cast(this.rightInterfaceType);
            numArgs = 2;
        } else {
            this.receiver = this.rightOperand;
            receiverType = this.kind == 2 ? this.getReceiverInterfaceName() : this.rightInterfaceType;
            this.rightOperand.generateExpression(acb, mb);
            mb.cast(receiverType);
            if (xmlGen) {
                numArgs = 1;
                BinaryOperatorNode.pushSqlXmlUtil(acb, mb, this.xmlQuery, this.operator);
            } else {
                numArgs = 2;
                mb.dup();
                mb.cast(this.rightInterfaceType);
                this.leftOperand.generateExpression(acb, mb);
                mb.cast(this.leftInterfaceType);
                mb.swap();
            }
        }
        String resultTypeName = this.kind == 2 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        LocalField localField = resultField = this.getTypeId().isBooleanTypeId() ? null : acb.newFieldDeclaration(2, resultTypeName);
        if (resultField != null) {
            int jdbcType;
            mb.getField(resultField);
            ++numArgs;
            if (this.getTypeServices() != null && ((jdbcType = this.getTypeServices().getJDBCTypeId()) == 3 || jdbcType == 2) && this.operator.equals("/")) {
                mb.push(this.getTypeServices().getScale());
                ++numArgs;
            }
        }
        mb.callMethod((short)185, receiverType, this.methodName, resultTypeName, numArgs);
        if (resultField != null) {
            if (this.getTypeId().variableLength() && this.getTypeId().isNumericTypeId()) {
                mb.dup();
                mb.push(this.getTypeServices().getPrecision());
                mb.push(this.getTypeServices().getScale());
                mb.push(true);
                mb.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
            }
            mb.putField(resultField);
        }
    }

    void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    void setRightOperand(ValueNode newRightOperand) {
        this.rightOperand = newRightOperand;
    }

    ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly);
        pushable = this.rightOperand.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperand.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return this.leftOperand.constantExpression(whereClause) && this.rightOperand.constantExpression(whereClause);
    }

    String getReceiverInterfaceName() throws StandardException {
        SanityManager.ASSERT((this.receiver != null ? 1 : 0) != 0, (String)"can't get receiver interface name until receiver is set");
        return this.receiver.getTypeCompiler().interfaceName();
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int leftType = this.leftOperand.getOrderableVariantType();
        int rightType = this.rightOperand.getOrderableVariantType();
        return Math.min(leftType, rightType);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(v);
        }
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((BinaryOperatorNode)o).kind == this.kind;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            BinaryOperatorNode other = (BinaryOperatorNode)o;
            return this.methodName.equals(other.methodName) && this.leftOperand.isEquivalent(other.leftOperand) && this.rightOperand.isEquivalent(other.rightOperand);
        }
        return false;
    }
}

