/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.store;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;

public final class SecretStoreUtil {
    private static final Random RANDOM = new Random();

    private SecretStoreUtil() {
    }

    public static char[] asciiBytesToChar(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)bytes[i];
            bytes[i] = 0;
        }
        return chars;
    }

    public static byte[] asciiCharToBytes(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
            chars[i] = '\u0000';
        }
        return bytes;
    }

    public static byte[] base64Encode(byte[] b) {
        byte[] bytes = Base64.getEncoder().encode(b);
        SecretStoreUtil.clearBytes(b);
        return bytes;
    }

    public static char[] base64EncodeToChars(byte[] bytes) {
        return SecretStoreUtil.asciiBytesToChar(SecretStoreUtil.base64Encode(bytes));
    }

    public static char[] base64Encode(char[] chars) {
        return SecretStoreUtil.asciiBytesToChar(SecretStoreUtil.base64Encode(SecretStoreUtil.asciiCharToBytes(chars)));
    }

    public static byte[] base64Decode(byte[] b) {
        byte[] bytes = Base64.getDecoder().decode(b);
        SecretStoreUtil.clearBytes(b);
        return bytes;
    }

    public static byte[] base64Decode(char[] chars) {
        return SecretStoreUtil.base64Decode(SecretStoreUtil.asciiCharToBytes(chars));
    }

    public static void clearChars(char[] chars) {
        Arrays.fill(chars, '\u0000');
    }

    public static void clearBytes(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
    }

    public static char[] deObfuscate(char[] chars) {
        byte[] bytes = SecretStoreUtil.asciiCharToBytes(chars);
        byte[] random = Arrays.copyOfRange(bytes, bytes.length / 2, bytes.length);
        byte[] deObfuscated = new byte[random.length];
        for (int i = 0; i < random.length; ++i) {
            int xor = bytes[i] ^ random[i];
            deObfuscated[i] = (byte)(xor & 0xFF);
        }
        return SecretStoreUtil.asciiBytesToChar(deObfuscated);
    }

    public static char[] obfuscate(char[] chars) {
        byte[] bytes = SecretStoreUtil.asciiCharToBytes(chars);
        byte[] random = new byte[bytes.length];
        RANDOM.nextBytes(random);
        ByteBuffer obfuscated = ByteBuffer.allocate(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int xor = bytes[i] ^ random[i];
            obfuscated.put((byte)(0xFF & xor));
        }
        obfuscated.put(random);
        char[] result = SecretStoreUtil.asciiBytesToChar(obfuscated.array());
        SecretStoreUtil.clearBytes(obfuscated.array());
        return result;
    }
}

