/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.io.IOException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.common.io.DeadLetterQueueWriter;
import org.logstash.common.io.QueueStorageType;

public class DeadLetterQueueFactory {
    private static final Logger logger = LogManager.getLogger(DeadLetterQueueFactory.class);
    private static final ConcurrentHashMap<String, DeadLetterQueueWriter> REGISTRY = new ConcurrentHashMap();
    private static final long MAX_SEGMENT_SIZE_BYTES = 0xA00000L;

    private DeadLetterQueueFactory() {
    }

    public static DeadLetterQueueWriter getWriter(String id, String dlqPath, long maxQueueSize, Duration flushInterval, QueueStorageType storageType) {
        return REGISTRY.computeIfAbsent(id, key -> DeadLetterQueueFactory.newWriter(key, dlqPath, maxQueueSize, flushInterval, storageType));
    }

    public static DeadLetterQueueWriter getWriter(String id, String dlqPath, long maxQueueSize, Duration flushInterval, QueueStorageType storageType, Duration age) {
        return REGISTRY.computeIfAbsent(id, key -> DeadLetterQueueFactory.newWriter(key, dlqPath, maxQueueSize, flushInterval, storageType, age));
    }

    public static DeadLetterQueueWriter release(String id) {
        return REGISTRY.remove(id);
    }

    private static DeadLetterQueueWriter newWriter(String id, String dlqPath, long maxQueueSize, Duration flushInterval, QueueStorageType storageType) {
        try {
            return DeadLetterQueueWriter.newBuilder(Paths.get(dlqPath, id), 0xA00000L, maxQueueSize, flushInterval).storageType(storageType).build();
        }
        catch (IOException e) {
            logger.error("unable to create dead letter queue writer", (Throwable)e);
            return null;
        }
    }

    private static DeadLetterQueueWriter newWriter(String id, String dlqPath, long maxQueueSize, Duration flushInterval, QueueStorageType storageType, Duration age) {
        try {
            return DeadLetterQueueWriter.newBuilder(Paths.get(dlqPath, id), 0xA00000L, maxQueueSize, flushInterval).storageType(storageType).retentionTime(age).build();
        }
        catch (IOException e) {
            logger.error("unable to create dead letter queue writer", (Throwable)e);
            return null;
        }
    }
}

