/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import co.elastic.logstash.api.NamespacedMetric;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.CompressionCodec;
import org.logstash.ackedqueue.Settings;
import org.logstash.ackedqueue.SettingsImpl;
import org.logstash.ackedqueue.ext.JRubyWrappedAckedQueueExt;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.ext.JrubyWrappedSynchronousQueueExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.plugins.NamespacedMetricImpl;

@JRubyClass(name={"QueueFactory"})
public final class QueueFactoryExt
extends RubyBasicObject {
    public static String PERSISTED_TYPE = "persisted";
    public static String MEMORY_TYPE = "memory";
    public static String QUEUE_TYPE_CONTEXT_NAME = "queue.type";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(QueueFactoryExt.class);

    public QueueFactoryExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @Deprecated
    @JRubyMethod(meta=true)
    public static AbstractWrappedQueueExt create(ThreadContext context, IRubyObject recv, IRubyObject settings) throws IOException {
        return QueueFactoryExt.create(context, settings, null);
    }

    public static AbstractWrappedQueueExt create(ThreadContext context, IRubyObject settings, AbstractNamespacedMetricExt metric) throws IOException {
        String type = QueueFactoryExt.getSetting(context, settings, QUEUE_TYPE_CONTEXT_NAME).asJavaString();
        BatchMetricMode batchMetricMode = QueueFactoryExt.decodeBatchMetricMode(context, settings);
        if (PERSISTED_TYPE.equals(type)) {
            Settings queueSettings = QueueFactoryExt.extractQueueSettings(settings);
            Path queuePath = Paths.get(queueSettings.getDirPath(), new String[0]);
            if (!Files.exists(queuePath, new LinkOption[0])) {
                Files.createDirectories(queuePath, new FileAttribute[0]);
            }
            NamespacedMetric namespacedMetric = QueueFactoryExt.getMetric(context, metric);
            return JRubyWrappedAckedQueueExt.create(context, queueSettings, namespacedMetric, batchMetricMode);
        }
        if (MEMORY_TYPE.equals(type)) {
            int batchSize = QueueFactoryExt.getSetting(context, settings, "pipeline.batch.size").convertToInteger().getIntValue();
            int workers = QueueFactoryExt.getSetting(context, settings, "pipeline.workers").convertToInteger().getIntValue();
            int queueSize = batchSize * workers;
            return JrubyWrappedSynchronousQueueExt.create(context, queueSize, batchMetricMode);
        }
        throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Invalid setting `%s` for `queue.type`, supported types are: 'memory' or 'persisted'", type));
    }

    private static BatchMetricMode decodeBatchMetricMode(ThreadContext context, IRubyObject settings) {
        String batchMetricModeStr = QueueFactoryExt.getSetting(context, settings, "pipeline.batch.metrics.sampling_mode").asJavaString();
        if (batchMetricModeStr == null || batchMetricModeStr.isEmpty()) {
            return BatchMetricMode.DISABLED;
        }
        return BatchMetricMode.valueOf(batchMetricModeStr.toUpperCase());
    }

    private static NamespacedMetric getMetric(ThreadContext context, AbstractNamespacedMetricExt metric) {
        if (metric == null) {
            return NamespacedMetricImpl.getNullMetric();
        }
        return new NamespacedMetricImpl(context, metric);
    }

    private static IRubyObject getSetting(ThreadContext context, IRubyObject settings, String name) {
        return settings.callMethod(context, "get_value", (IRubyObject)context.runtime.newString(name));
    }

    private static Settings extractQueueSettings(IRubyObject settings) {
        ThreadContext context = settings.getRuntime().getCurrentContext();
        Path queuePath = Paths.get(QueueFactoryExt.getSetting(context, settings, "path.queue").asJavaString(), QueueFactoryExt.getSetting(context, settings, "pipeline.id").asJavaString());
        return SettingsImpl.fileSettingsBuilder(queuePath.toString()).elementClass(Event.class).capacity((Integer)QueueFactoryExt.getSetting(context, settings, "queue.page_capacity").toJava(Integer.class)).maxUnread((Integer)QueueFactoryExt.getSetting(context, settings, "queue.max_events").toJava(Integer.class)).checkpointMaxWrites((Integer)QueueFactoryExt.getSetting(context, settings, "queue.checkpoint.writes").toJava(Integer.class)).checkpointMaxAcks((Integer)QueueFactoryExt.getSetting(context, settings, "queue.checkpoint.acks").toJava(Integer.class)).checkpointRetry(QueueFactoryExt.getSetting(context, settings, "queue.checkpoint.retry").isTrue()).queueMaxBytes((Long)QueueFactoryExt.getSetting(context, settings, "queue.max_bytes").toJava(Long.class)).compressionCodecFactory(QueueFactoryExt.extractConfiguredCodec(settings)).build();
    }

    private static CompressionCodec.Factory extractConfiguredCodec(IRubyObject settings) {
        ThreadContext context = settings.getRuntime().getCurrentContext();
        String compressionSetting = QueueFactoryExt.getSetting(context, settings, "queue.compression").asJavaString();
        return CompressionCodec.fromConfigValue(compressionSetting, LOGGER);
    }

    public static enum BatchMetricMode {
        DISABLED,
        MINIMAL,
        FULL;

    }
}

