/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.logstash.Event;
import org.logstash.KeyNode;
import org.logstash.ObjectMappers;
import org.logstash.Timestamp;

public final class StringInterpolation {
    private static final String TIME_NOW = "TIME_NOW";
    private static final ThreadLocal<StringBuilder> STRING_BUILDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }

        @Override
        public StringBuilder get() {
            StringBuilder b = (StringBuilder)super.get();
            b.setLength(0);
            return b;
        }
    };

    private StringInterpolation() {
    }

    public static String evaluate(co.elastic.logstash.api.Event event, String template) throws JsonProcessingException {
        if (event instanceof Event) {
            return StringInterpolation.evaluate((Event)event, template);
        }
        throw new IllegalStateException("Unknown event concrete class: " + event.getClass().getName());
    }

    public static String evaluate(Event event, String template) throws JsonProcessingException {
        int open = template.indexOf("%{");
        int close = template.indexOf(125, open);
        if (open == -1 || close == -1) {
            return template;
        }
        StringBuilder builder = STRING_BUILDER.get();
        int pos = 0;
        int len = template.length();
        while (open > -1 && close > -1) {
            if (open > 0) {
                builder.append(template, pos, open);
            }
            if (template.regionMatches(open + 2, "+%s", 0, close - open - 2)) {
                t = event.getTimestamp();
                builder.append(t == null ? "" : Long.valueOf(t.toInstant().getEpochSecond()));
            } else if (template.charAt(open + 2) == '{' && close < len && template.charAt(close + 1) == '}') {
                String pattern;
                if ((pattern = template.substring(open + 3, ++close - 1)).equals(TIME_NOW)) {
                    builder.append(new Timestamp());
                } else {
                    Optional.ofNullable(event.getTimestamp()).map(Timestamp::toInstant).map(instant -> java.time.format.DateTimeFormatter.ofPattern(pattern).withZone(ZoneOffset.UTC).format((TemporalAccessor)instant)).ifPresent(builder::append);
                }
            } else if (template.charAt(open + 2) == '+') {
                t = event.getTimestamp();
                if (t != null) {
                    String jodaTimeFormatPattern = template.substring(open + 3, close);
                    DateTimeFormatter jodaDateTimeFormatter = DateTimeFormat.forPattern((String)jodaTimeFormatPattern).withZone(DateTimeZone.UTC);
                    DateTime jodaTimestamp = new DateTime(t.toInstant().toEpochMilli(), DateTimeZone.UTC);
                    String formattedTimestamp = jodaTimestamp.toString(jodaDateTimeFormatter);
                    builder.append(formattedTimestamp);
                }
            } else {
                String found = template.substring(open + 2, close);
                Object value = event.getField(found);
                if (value != null) {
                    if (value instanceof List) {
                        builder.append(KeyNode.join((List)value, ","));
                    } else if (value instanceof Map) {
                        builder.append(ObjectMappers.JSON_MAPPER.writeValueAsString(value));
                    } else {
                        builder.append(value.toString());
                    }
                } else {
                    builder.append("%{").append(found).append('}');
                }
            }
            pos = close + 1;
            open = template.indexOf("%{", pos);
            close = template.indexOf(125, open);
        }
        if (pos < len) {
            builder.append(template, pos, len);
        }
        return builder.toString();
    }
}

