/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.Generator;
import json.ext.OptionsReader;
import json.ext.RuntimeInfo;
import json.ext.Utils;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

public class GeneratorState
extends RubyObject {
    private boolean allowDuplicateKey = false;
    private boolean deprecateDuplicateKey = true;
    private ByteList indent = ByteList.EMPTY_BYTELIST;
    private ByteList space = ByteList.EMPTY_BYTELIST;
    private ByteList spaceBefore = ByteList.EMPTY_BYTELIST;
    private ByteList objectNl = ByteList.EMPTY_BYTELIST;
    private ByteList arrayNl = ByteList.EMPTY_BYTELIST;
    private RubyProc asJSON;
    private int maxNesting = 100;
    static final int DEFAULT_MAX_NESTING = 100;
    private boolean allowNaN = false;
    static final boolean DEFAULT_ALLOW_NAN = false;
    private boolean asciiOnly = false;
    static final boolean DEFAULT_ASCII_ONLY = false;
    private boolean scriptSafe = false;
    static final boolean DEFAULT_SCRIPT_SAFE = false;
    private boolean strict = false;
    static final boolean DEFAULT_STRICT = false;
    private int bufferInitialLength = 1024;
    static final int DEFAULT_BUFFER_INITIAL_LENGTH = 1024;
    private int depth = 0;
    static final ObjectAllocator ALLOCATOR = GeneratorState::new;

    public GeneratorState(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject from_state(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return GeneratorState.fromState(threadContext, iRubyObject2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject generate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return GeneratorState.fromState(threadContext, iRubyObject3).generate(threadContext, iRubyObject2, iRubyObject4);
    }

    static GeneratorState fromState(ThreadContext threadContext, IRubyObject iRubyObject) {
        return GeneratorState.fromState(threadContext, RuntimeInfo.forRuntime(threadContext.runtime), iRubyObject);
    }

    static GeneratorState fromState(ThreadContext threadContext, RuntimeInfo runtimeInfo, IRubyObject iRubyObject) {
        RubyClass rubyClass = (RubyClass)runtimeInfo.generatorStateClass.get();
        if (iRubyObject != null) {
            if (rubyClass.isInstance(iRubyObject)) {
                return (GeneratorState)iRubyObject;
            }
            if (threadContext.runtime.getHash().isInstance(iRubyObject)) {
                return (GeneratorState)rubyClass.newInstance(threadContext, iRubyObject, Block.NULL_BLOCK);
            }
        }
        return (GeneratorState)rubyClass.newInstance(threadContext, threadContext.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext) {
        this._configure(threadContext, null);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        this._configure(threadContext, iRubyObject);
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        if (!(iRubyObject instanceof GeneratorState)) {
            throw ruby.newTypeError(iRubyObject, this.getType());
        }
        GeneratorState generatorState = (GeneratorState)iRubyObject;
        this.indent = generatorState.indent;
        this.space = generatorState.space;
        this.spaceBefore = generatorState.spaceBefore;
        this.objectNl = generatorState.objectNl;
        this.arrayNl = generatorState.arrayNl;
        this.asJSON = generatorState.asJSON;
        this.maxNesting = generatorState.maxNesting;
        this.allowNaN = generatorState.allowNaN;
        this.asciiOnly = generatorState.asciiOnly;
        this.scriptSafe = generatorState.scriptSafe;
        this.strict = generatorState.strict;
        this.bufferInitialLength = generatorState.bufferInitialLength;
        this.depth = generatorState.depth;
        this.allowDuplicateKey = generatorState.allowDuplicateKey;
        this.deprecateDuplicateKey = generatorState.deprecateDuplicateKey;
        return this;
    }

    @JRubyMethod
    public IRubyObject generate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        IRubyObject iRubyObject3 = Generator.generateJson(threadContext, iRubyObject, this, iRubyObject2);
        RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.runtime);
        if (!(iRubyObject3 instanceof RubyString)) {
            return iRubyObject3;
        }
        RubyString rubyString = iRubyObject3.convertToString();
        if (rubyString.getEncoding() != UTF8Encoding.INSTANCE) {
            if (rubyString.isFrozen()) {
                rubyString = rubyString.strDup(threadContext.runtime);
            }
            rubyString.setEncoding((Encoding)UTF8Encoding.INSTANCE);
            rubyString.clearCodeRange();
        }
        return rubyString;
    }

    @JRubyMethod
    public IRubyObject generate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.generate(threadContext, iRubyObject, threadContext.nil);
    }

    @JRubyMethod
    public IRubyObject generate_new(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        GeneratorState generatorState = (GeneratorState)this.dup();
        generatorState.resetDepth();
        return generatorState.generate(threadContext, iRubyObject, iRubyObject2);
    }

    @JRubyMethod
    public IRubyObject generate_new(ThreadContext threadContext, IRubyObject iRubyObject) {
        GeneratorState generatorState = (GeneratorState)this.dup();
        generatorState.resetDepth();
        return generatorState.generate(threadContext, iRubyObject, threadContext.nil);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string = iRubyObject.asJavaString();
        if (this.getMetaClass().isMethodBound(string, true)) {
            return this.send(threadContext, iRubyObject, Block.NULL_BLOCK);
        }
        IRubyObject iRubyObject2 = this.getInstanceVariables().getInstanceVariable("@" + string);
        return iRubyObject2 == null ? threadContext.nil : iRubyObject2;
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject.asJavaString();
        String string2 = string + "=";
        if (this.getMetaClass().isMethodBound(string2, true)) {
            return this.send(threadContext, (IRubyObject)threadContext.runtime.newString(string2), iRubyObject2, Block.NULL_BLOCK);
        }
        this.getInstanceVariables().setInstanceVariable("@" + string, iRubyObject2);
        return threadContext.nil;
    }

    public ByteList getIndent() {
        return this.indent;
    }

    @JRubyMethod(name={"indent"})
    public RubyString indent_get(ThreadContext threadContext) {
        return threadContext.runtime.newString(this.indent);
    }

    @JRubyMethod(name={"indent="})
    public IRubyObject indent_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.indent = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getSpace() {
        return this.space;
    }

    @JRubyMethod(name={"space"})
    public RubyString space_get(ThreadContext threadContext) {
        return threadContext.runtime.newString(this.space);
    }

    @JRubyMethod(name={"space="})
    public IRubyObject space_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.space = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getSpaceBefore() {
        return this.spaceBefore;
    }

    @JRubyMethod(name={"space_before"})
    public RubyString space_before_get(ThreadContext threadContext) {
        return threadContext.runtime.newString(this.spaceBefore);
    }

    @JRubyMethod(name={"space_before="})
    public IRubyObject space_before_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.spaceBefore = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getObjectNl() {
        return this.objectNl;
    }

    @JRubyMethod(name={"object_nl"})
    public RubyString object_nl_get(ThreadContext threadContext) {
        return threadContext.runtime.newString(this.objectNl);
    }

    @JRubyMethod(name={"object_nl="})
    public IRubyObject object_nl_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.objectNl = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getArrayNl() {
        return this.arrayNl;
    }

    @JRubyMethod(name={"array_nl"})
    public RubyString array_nl_get(ThreadContext threadContext) {
        return threadContext.runtime.newString(this.arrayNl);
    }

    @JRubyMethod(name={"array_nl="})
    public IRubyObject array_nl_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.arrayNl = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public RubyProc getAsJSON() {
        return this.asJSON;
    }

    @JRubyMethod(name={"as_json"})
    public IRubyObject as_json_get(ThreadContext threadContext) {
        return this.asJSON == null ? threadContext.getRuntime().getFalse() : this.asJSON;
    }

    @JRubyMethod(name={"as_json="})
    public IRubyObject as_json_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.asJSON = iRubyObject.isNil() || iRubyObject == threadContext.getRuntime().getFalse() ? null : (RubyProc)TypeConverter.convertToType((IRubyObject)iRubyObject, (RubyClass)threadContext.getRuntime().getProc(), (String)"to_proc");
        return iRubyObject;
    }

    @JRubyMethod(name={"check_circular?"})
    public RubyBoolean check_circular_p(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (this.maxNesting != 0 ? 1 : 0) != 0);
    }

    @JRubyMethod(name={"max_nesting"})
    public RubyInteger max_nesting_get(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.maxNesting);
    }

    @JRubyMethod(name={"max_nesting="})
    public IRubyObject max_nesting_set(IRubyObject iRubyObject) {
        this.maxNesting = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        return iRubyObject;
    }

    public boolean scriptSafe() {
        return this.scriptSafe;
    }

    @JRubyMethod(name={"script_safe"}, alias={"escape_slash"})
    public RubyBoolean script_safe_get(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.scriptSafe);
    }

    @JRubyMethod(name={"script_safe="}, alias={"escape_slash="})
    public IRubyObject script_safe_set(IRubyObject iRubyObject) {
        this.scriptSafe = iRubyObject.isTrue();
        return iRubyObject.getRuntime().newBoolean(this.scriptSafe);
    }

    @JRubyMethod(name={"script_safe?"}, alias={"escape_slash?"})
    public RubyBoolean script_safe_p(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.scriptSafe);
    }

    public boolean strict() {
        return this.strict;
    }

    @JRubyMethod(name={"strict", "strict?"})
    public RubyBoolean strict_get(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.strict);
    }

    @JRubyMethod(name={"strict="})
    public IRubyObject strict_set(IRubyObject iRubyObject) {
        this.strict = iRubyObject.isTrue();
        return iRubyObject.getRuntime().newBoolean(this.strict);
    }

    public boolean allowNaN() {
        return this.allowNaN;
    }

    @JRubyMethod(name={"allow_nan?"})
    public RubyBoolean allow_nan_p(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.allowNaN);
    }

    public boolean asciiOnly() {
        return this.asciiOnly;
    }

    @JRubyMethod(name={"ascii_only?"})
    public RubyBoolean ascii_only_p(ThreadContext threadContext) {
        return RubyBoolean.newBoolean((ThreadContext)threadContext, (boolean)this.asciiOnly);
    }

    @JRubyMethod(name={"buffer_initial_length"})
    public RubyInteger buffer_initial_length_get(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.bufferInitialLength);
    }

    @JRubyMethod(name={"buffer_initial_length="})
    public IRubyObject buffer_initial_length_set(IRubyObject iRubyObject) {
        int n = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        if (n > 0) {
            this.bufferInitialLength = n;
        }
        return iRubyObject;
    }

    public int getDepth() {
        return this.depth;
    }

    @JRubyMethod(name={"depth"})
    public RubyInteger depth_get(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.depth);
    }

    @JRubyMethod(name={"depth="})
    public IRubyObject depth_set(IRubyObject iRubyObject) {
        this.depth = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        return iRubyObject;
    }

    public void resetDepth() {
        this.depth = 0;
    }

    private ByteList prepareByteList(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = iRubyObject.convertToString();
        if (rubyString.getEncoding() != UTF8Encoding.INSTANCE) {
            rubyString = (RubyString)rubyString.encode(threadContext, threadContext.runtime.getEncodingService().convertEncodingToRubyEncoding((Encoding)UTF8Encoding.INSTANCE));
        }
        return rubyString.getByteList().dup();
    }

    @JRubyMethod(name={"allow_duplicate_key?"}, visibility=Visibility.PRIVATE)
    public IRubyObject allow_duplicate_key_p(ThreadContext threadContext) {
        if (this.allowDuplicateKey) {
            return threadContext.runtime.getTrue();
        }
        if (this.deprecateDuplicateKey) {
            return threadContext.runtime.getNil();
        }
        return threadContext.runtime.getFalse();
    }

    public boolean getAllowDuplicateKey() {
        return this.allowDuplicateKey;
    }

    public boolean getDeprecateDuplicateKey() {
        return this.deprecateDuplicateKey;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject _configure(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList;
        ByteList byteList2;
        ByteList byteList3;
        OptionsReader optionsReader = new OptionsReader(threadContext, iRubyObject);
        ByteList byteList4 = optionsReader.getString("indent");
        if (byteList4 != null) {
            this.indent = byteList4;
        }
        if ((byteList3 = optionsReader.getString("space")) != null) {
            this.space = byteList3;
        }
        if ((byteList2 = optionsReader.getString("space_before")) != null) {
            this.spaceBefore = byteList2;
        }
        if ((byteList = optionsReader.getString("array_nl")) != null) {
            this.arrayNl = byteList;
        }
        this.asJSON = optionsReader.getProc("as_json");
        ByteList byteList5 = optionsReader.getString("object_nl");
        if (byteList5 != null) {
            this.objectNl = byteList5;
        }
        this.maxNesting = optionsReader.getInt("max_nesting", 100);
        this.allowNaN = optionsReader.getBool("allow_nan", false);
        this.asciiOnly = optionsReader.getBool("ascii_only", false);
        this.scriptSafe = optionsReader.getBool("script_safe", false);
        if (!this.scriptSafe) {
            this.scriptSafe = optionsReader.getBool("escape_slash", false);
        }
        this.strict = optionsReader.getBool("strict", false);
        this.bufferInitialLength = optionsReader.getInt("buffer_initial_length", 1024);
        this.depth = optionsReader.getInt("depth", 0);
        if (optionsReader.hasKey("allow_duplicate_key")) {
            this.allowDuplicateKey = optionsReader.getBool("allow_duplicate_key", false);
            this.deprecateDuplicateKey = false;
        }
        return this;
    }

    @JRubyMethod(alias={"to_hash"})
    public RubyHash to_h(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("indent"), (IRubyObject)this.indent_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("space"), (IRubyObject)this.space_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("space_before"), (IRubyObject)this.space_before_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("object_nl"), (IRubyObject)this.object_nl_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("array_nl"), (IRubyObject)this.array_nl_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("as_json"), this.as_json_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("allow_nan"), (IRubyObject)this.allow_nan_p(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("ascii_only"), (IRubyObject)this.ascii_only_p(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("max_nesting"), (IRubyObject)this.max_nesting_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("script_safe"), (IRubyObject)this.script_safe_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("strict"), (IRubyObject)this.strict_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("depth"), (IRubyObject)this.depth_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("buffer_initial_length"), (IRubyObject)this.buffer_initial_length_get(threadContext));
        if (this.allowDuplicateKey) {
            if (!this.deprecateDuplicateKey) {
                rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("allow_duplicate_key"), (IRubyObject)ruby.getTrue());
            }
        } else {
            rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("allow_duplicate_key"), (IRubyObject)ruby.getFalse());
        }
        for (String string : this.getInstanceVariableNameList()) {
            rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol(string.substring(1)), this.getInstanceVariables().getInstanceVariable(string));
        }
        return rubyHash;
    }

    public int increaseDepth(ThreadContext threadContext) {
        ++this.depth;
        this.checkMaxNesting(threadContext);
        return this.depth;
    }

    public int decreaseDepth() {
        return --this.depth;
    }

    private void checkMaxNesting(ThreadContext threadContext) {
        if (this.maxNesting != 0 && this.depth > this.maxNesting) {
            --this.depth;
            throw Utils.newException(threadContext, "NestingError", "nesting of " + this.depth + " is too deep. Did you try to serialize objects with circular references?");
        }
    }
}

