/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.logstash.beats.Batch;
import org.logstash.beats.Message;

public class V1Batch
implements Batch {
    private int batchSize;
    private List<Message> messages = new ArrayList<Message>();
    private byte protocol = (byte)49;
    private int highestSequence = -1;

    @Override
    public byte getProtocol() {
        return this.protocol;
    }

    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    void addMessage(Message message) {
        message.setBatch(this);
        this.messages.add(message);
        if (message.getSequence() > this.highestSequence) {
            this.highestSequence = message.getSequence();
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.messages.size();
    }

    @Override
    public int getHighestSequence() {
        return this.highestSequence;
    }

    @Override
    public boolean isComplete() {
        return this.size() == this.getBatchSize();
    }

    @Override
    public void release() {
    }
}

