/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class AuthzResourceUseMoreURIs
extends CustomKeycloakTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        try {
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select ID,URI from " + this.getTableName("RESOURCE_SERVER_RESOURCE") + " where URI is not null");
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String resourceId = resultSet.getString(1);
                    String resourceUri = resultSet.getString(2);
                    InsertStatement insertComponent = new InsertStatement(null, null, this.database.correctObjectName("RESOURCE_URIS", Table.class)).addColumnValue("RESOURCE_ID", (Object)resourceId).addColumnValue("VALUE", (Object)resourceUri);
                    this.statements.add(insertComponent);
                }
            }
            this.confirmationMessage.append("Moved " + this.statements.size() + " records from RESOURCE_SERVER_RESOURCE to RESOURCE_URIS table");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Update 4.2.0.Final";
    }
}

