/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.traces.LowAllocationTraceRequestMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.BiFunction;

public class SpanReusableDataMarshaler {
    private final Deque<LowAllocationTraceRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationTraceRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public SpanReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationTraceRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationTraceRequestMarshaler();
            }
            LowAllocationTraceRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(spans);
            return this.doExport.apply(exportMarshaler, spans.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.doExport.apply((Marshaler)request, spans.size());
    }
}

