/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.parser.ChangeLogParserConfiguration;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.AbstractPrecondition;
import liquibase.precondition.Precondition;
import liquibase.precondition.PreconditionFactory;
import liquibase.resource.ResourceAccessor;

public abstract class PreconditionLogic
extends AbstractPrecondition {
    private final List<Precondition> nestedPreconditions = new ArrayList<Precondition>();

    public List<Precondition> getNestedPreconditions() {
        return this.nestedPreconditions;
    }

    public void addNestedPrecondition(Precondition precondition) {
        if (precondition != null) {
            this.nestedPreconditions.add(precondition);
        }
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        for (Precondition precondition : this.getNestedPreconditions()) {
            validationErrors.addAll(precondition.validate(database));
        }
        return validationErrors;
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        super.load(parsedNode, resourceAccessor);
        for (ParsedNode child : parsedNode.getChildren()) {
            if (child.getName().equals("nestedPreconditions")) {
                for (ParsedNode child2 : child.getChildren()) {
                    this.load(child2, resourceAccessor);
                }
                continue;
            }
            this.addNestedPrecondition(this.toPrecondition(child, resourceAccessor));
        }
    }

    protected Precondition toPrecondition(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        Precondition precondition = PreconditionFactory.getInstance().create(node.getName());
        if (precondition == null) {
            if (node.getChildren() != null && node.getChildren().size() > 0 && ChangeLogParserConfiguration.CHANGELOG_PARSE_MODE.getCurrentValue().equals((Object)ChangeLogParserConfiguration.ChangelogParseMode.STRICT)) {
                throw new ParsedNodeException("Unknown precondition '" + node.getName() + "'. Check for spelling or capitalization errors and missing extensions such as liquibase-commercial.");
            }
            return null;
        }
        precondition.load(node, resourceAccessor);
        return precondition;
    }
}

