/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaJsonValueExpression;
import org.hibernate.query.criteria.JpaJsonValueNode;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.AbstractSqmJsonPathExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;

@Incubating
public class SqmJsonValueExpression<T>
extends AbstractSqmJsonPathExpression<T>
implements JpaJsonValueExpression<T> {
    private JpaJsonValueNode.ErrorBehavior errorBehavior = JpaJsonValueNode.ErrorBehavior.UNSPECIFIED;
    private SqmExpression<T> errorDefaultExpression;
    private JpaJsonValueNode.EmptyBehavior emptyBehavior = JpaJsonValueNode.EmptyBehavior.UNSPECIFIED;
    private SqmExpression<T> emptyDefaultExpression;

    public SqmJsonValueExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<T> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
    }

    private SqmJsonValueExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<T> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name, @Nullable Map<String, SqmExpression<?>> passingExpressions, JpaJsonValueNode.ErrorBehavior errorBehavior, SqmExpression<T> errorDefaultExpression, JpaJsonValueNode.EmptyBehavior emptyBehavior, SqmExpression<T> emptyDefaultExpression) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name, passingExpressions);
        this.errorBehavior = errorBehavior;
        this.errorDefaultExpression = errorDefaultExpression;
        this.emptyBehavior = emptyBehavior;
        this.emptyDefaultExpression = emptyDefaultExpression;
    }

    @Override
    public SqmJsonValueExpression<T> copy(SqmCopyContext context) {
        SqmJsonValueExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
        for (SqmTypedNode<?> argument : this.getArguments()) {
            arguments.add(argument.copy(context));
        }
        return context.registerCopy(this, new SqmJsonValueExpression(this.getFunctionDescriptor(), this.getFunctionRenderer(), (List<? extends SqmTypedNode<?>>)((List<SqmTypedNode<?>>)arguments), this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName(), this.copyPassingExpressions(context), this.errorBehavior, this.errorDefaultExpression == null ? null : this.errorDefaultExpression.copy(context), this.emptyBehavior, this.emptyDefaultExpression == null ? null : this.emptyDefaultExpression.copy(context)));
    }

    @Override
    public JpaJsonValueNode.ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public JpaJsonValueNode.EmptyBehavior getEmptyBehavior() {
        return this.emptyBehavior;
    }

    @Override
    public @Nullable JpaExpression<T> getErrorDefault() {
        return this.errorDefaultExpression;
    }

    @Override
    public @Nullable JpaExpression<T> getEmptyDefault() {
        return this.emptyDefaultExpression;
    }

    @Override
    public SqmJsonValueExpression<T> unspecifiedOnError() {
        this.errorBehavior = JpaJsonValueNode.ErrorBehavior.UNSPECIFIED;
        this.errorDefaultExpression = null;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> errorOnError() {
        this.errorBehavior = JpaJsonValueNode.ErrorBehavior.ERROR;
        this.errorDefaultExpression = null;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> nullOnError() {
        this.errorBehavior = JpaJsonValueNode.ErrorBehavior.NULL;
        this.errorDefaultExpression = null;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> defaultOnError(jakarta.persistence.criteria.Expression<?> expression) {
        this.errorBehavior = JpaJsonValueNode.ErrorBehavior.DEFAULT;
        this.errorDefaultExpression = (SqmExpression)expression;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> unspecifiedOnEmpty() {
        this.errorBehavior = JpaJsonValueNode.ErrorBehavior.UNSPECIFIED;
        this.errorDefaultExpression = null;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> errorOnEmpty() {
        this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.ERROR;
        this.emptyDefaultExpression = null;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> nullOnEmpty() {
        this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.NULL;
        this.emptyDefaultExpression = null;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> defaultOnEmpty(jakarta.persistence.criteria.Expression<?> expression) {
        this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.DEFAULT;
        this.emptyDefaultExpression = (SqmExpression)expression;
        return this;
    }

    @Override
    public SqmJsonValueExpression<T> passing(String parameterName, jakarta.persistence.criteria.Expression<?> expression) {
        this.addPassingExpression(parameterName, (SqmExpression)expression);
        return this;
    }

    @Override
    public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
        JsonPathPassingClause jsonPathPassingClause;
        @Nullable ReturnableType<?> resultType = this.resolveResultType(walker);
        List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
        ArgumentsValidator validator = this.getArgumentsValidator();
        if (validator != null) {
            validator.validateSqlTypes(arguments, this.getFunctionName());
        }
        if ((jsonPathPassingClause = this.createJsonPathPassingClause(walker)) != null) {
            arguments.add(jsonPathPassingClause);
        }
        switch (this.errorBehavior) {
            case NULL: {
                arguments.add(JsonValueErrorBehavior.NULL);
                break;
            }
            case ERROR: {
                arguments.add(JsonValueErrorBehavior.ERROR);
                break;
            }
            case DEFAULT: {
                arguments.add(JsonValueErrorBehavior.defaultOnError((Expression)this.errorDefaultExpression.accept(walker)));
            }
        }
        switch (this.emptyBehavior) {
            case NULL: {
                arguments.add(JsonValueEmptyBehavior.NULL);
                break;
            }
            case ERROR: {
                arguments.add(JsonValueEmptyBehavior.ERROR);
                break;
            }
            case DEFAULT: {
                arguments.add(JsonValueEmptyBehavior.defaultOnEmpty((Expression)this.emptyDefaultExpression.accept(walker)));
            }
        }
        return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getFunctionRenderer(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType, arguments));
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("json_value(");
        this.getArguments().get(0).appendHqlString(hql, context);
        hql.append(',');
        this.getArguments().get(1).appendHqlString(hql, context);
        this.appendPassingExpressionHqlString(hql, context);
        if (this.getArguments().size() > 2) {
            hql.append(" returning ");
            this.getArguments().get(2).appendHqlString(hql, context);
        }
        switch (this.errorBehavior) {
            case NULL: {
                hql.append(" null on error");
                break;
            }
            case ERROR: {
                hql.append(" error on error");
                break;
            }
            case DEFAULT: {
                hql.append(" default ");
                this.errorDefaultExpression.appendHqlString(hql, context);
                hql.append(" on error");
            }
        }
        switch (this.emptyBehavior) {
            case NULL: {
                hql.append(" null on empty");
                break;
            }
            case ERROR: {
                hql.append(" error on empty");
                break;
            }
            case DEFAULT: {
                hql.append(" default ");
                this.emptyDefaultExpression.appendHqlString(hql, context);
                hql.append(" on empty");
            }
        }
        hql.append(')');
    }
}

