/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.identity;

import java.util.function.Consumer;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.model.ast.TableInsert;

public class H2IdentityColumnSupport
extends IdentityColumnSupportImpl {
    public static final H2IdentityColumnSupport INSTANCE = new H2IdentityColumnSupport();

    protected H2IdentityColumnSupport() {
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public String getIdentityColumnString(int type) {
        return "generated by default as identity";
    }

    @Override
    public String getIdentitySelectString(String table, String column, int type) {
        return "call identity()";
    }

    @Override
    public String getIdentityInsertString() {
        return "default";
    }

    @Deprecated
    public void render(TableInsert tableInsert, Consumer<String> sqlAppender, Consumer<ColumnReference> returnColumnHandler, InsertValuesHandler insertValuesHandler, SessionFactoryImplementor sessionFactory) {
        insertValuesHandler.renderInsertValues();
        sqlAppender.accept(" call identity();");
    }

    @FunctionalInterface
    public static interface InsertValuesHandler {
        public void renderInsertValues();
    }
}

