/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class IntegerMathInstr
extends TwoOperandResultBaseInstr {
    private final Op op;

    public IntegerMathInstr(Op op, Variable result2, Operand operand1, Operand operand2) {
        super(Operation.INT_MATH, result2, operand1, operand2);
        this.op = op;
    }

    @Override
    public Instr clone(CloneInfo info) {
        return new IntegerMathInstr(this.op, this.getResult(), this.getOperand1(), this.getOperand2());
    }

    public static IntegerMathInstr decode(IRReaderDecoder d) {
        Variable result2 = d.decodeVariable();
        Operand arg1 = d.decodeOperand();
        Operand arg2 = d.decodeOperand();
        return new IntegerMathInstr(Op.fromOrdinal(d.decodeInt()), result2, arg1, arg2);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.op.ordinal());
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"op:", this.op.name()};
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.IntegerMathInstr(this);
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        int value1 = (Integer)this.getOperand1().retrieve(context, self2, currScope, currDynScope, temp);
        int value2 = (Integer)this.getOperand2().retrieve(context, self2, currScope, currDynScope, temp);
        switch (this.op.ordinal()) {
            case 0: {
                return value1 + value2;
            }
            case 1: {
                return value1 - value2;
            }
            case 2: {
                return value1 * value2;
            }
            case 3: {
                return value1 / value2;
            }
        }
        throw new RuntimeException("IntegerMathInstr has unknown op");
    }

    public Op getOp() {
        return this.op;
    }

    public static enum Op {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;


        public static Op fromOrdinal(int value2) {
            return value2 < 0 || value2 >= Op.values().length ? null : Op.values()[value2];
        }
    }
}

