"""Generated message classes for storageinsights version v1.

Provides insights capability on Google Cloud Storage
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'storageinsights'


class BucketErrors(_messages.Message):
  r"""Provides a summary of the bucket level error statistics.

  Fields:
    internalErrorCount: Optional. Number of buckets that encountered internal
      errors during the validation process. These buckets are automatically
      retried in subsequent validation attempts.
    nonManagementHubEntitledCount: Optional. Count of buckets that are not
      subscribed to Storage Intelligence.
    nonStorageIntelligenceEntitledBucketIds: Optional. Subset of bucket names
      that are not subscribed to Storage Intelligence.
    nonStorageIntelligenceEntitledCount: Optional. Count of buckets that are
      not subscribed to Storage Intelligence.
    permissionDeniedBucketIds: Optional. Subset of bucket names that have
      permission denied.
    permissionDeniedCount: Optional. Count of buckets with permission denied
      errors.
    validatedCount: Optional. Count of successfully validated buckets.
  """

  internalErrorCount = _messages.IntegerField(1)
  nonManagementHubEntitledCount = _messages.IntegerField(2)
  nonStorageIntelligenceEntitledBucketIds = _messages.StringField(3, repeated=True)
  nonStorageIntelligenceEntitledCount = _messages.IntegerField(4)
  permissionDeniedBucketIds = _messages.StringField(5, repeated=True)
  permissionDeniedCount = _messages.IntegerField(6)
  validatedCount = _messages.IntegerField(7)


class CSVOptions(_messages.Message):
  r"""Options to configure inventory reports in CSV format.

  Fields:
    delimiter: Delimiter characters in CSV.
    headerRequired: If set, includes a header row in the CSV report.
    recordSeparator: Record separator characters in CSV.
  """

  delimiter = _messages.StringField(1)
  headerRequired = _messages.BooleanField(2)
  recordSeparator = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudStorageBucket(_messages.Message):
  r"""Defines the bucket by its name or a regex pattern to match buckets.

  Fields:
    bucketName: Cloud Storage bucket name.
    bucketPrefixRegex: A regex pattern for bucket names matching the regex.
      Regex should follow the syntax specified in `google/re2` on GitHub.
  """

  bucketName = _messages.StringField(1)
  bucketPrefixRegex = _messages.StringField(2)


class CloudStorageBuckets(_messages.Message):
  r"""Collection of Cloud Storage buckets.

  Fields:
    cloudStorageBuckets: A CloudStorageBucket attribute.
  """

  cloudStorageBuckets = _messages.MessageField('CloudStorageBucket', 1, repeated=True)


class CloudStorageDestinationOptions(_messages.Message):
  r"""Options to store inventory reports in Cloud Storage.

  Fields:
    bucket: Optional. The destination bucket for the inventory reports.
    destinationPath: The destination path within the bucket where the
      inventory reports are stored.
  """

  bucket = _messages.StringField(1)
  destinationPath = _messages.StringField(2)


class CloudStorageFilters(_messages.Message):
  r"""Filters buckets to generate inventory reports for Cloud Storage.

  Fields:
    bucket: Optional. Bucket for which the inventory report is generated.
  """

  bucket = _messages.StringField(1)


class CloudStorageLocations(_messages.Message):
  r"""Collection of Cloud Storage locations.

  Fields:
    locations: A string attribute.
  """

  locations = _messages.StringField(1, repeated=True)


class DatasetConfig(_messages.Message):
  r"""Message describing the dataset configuration properties. For more
  information, see [Dataset configuration
  properties](https://cloud.google.com/storage/docs/insights/datasets#dataset-
  config).

  Enums:
    DatasetConfigStateValueValuesEnum: Output only. State of the
      `datasetConfig`.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    activityDataRetentionPeriodDays: Optional. When set, overrides the
      retention period for activity data. Otherwise, the
      `retention_period_days` value is used for activity data as well.
    cloudStorageObjectPath: Input only. Cloud Storage object path containing a
      list of project or folder numbers to include in the dataset; it cannot
      contain a mix of project and folders. The object must be a text file
      where each line has one of the following entries: - Project number,
      formatted as `projects/{project_number}`, for example,
      `projects/1234567890`. - Folder identifier, formatted as
      `folders/{folder_number}`, for example, `folders/9876543210`. Path must
      be in the format `gs://{bucket_name}/{object_name}`.
    createTime: Output only. The UTC time at which the dataset configuration
      was created. This is auto-populated.
    datasetConfigState: Output only. State of the `datasetConfig`.
    description: Optional. A user-provided description for the dataset
      configuration. Maximum length: 256 characters.
    excludeCloudStorageBuckets: A CloudStorageBuckets attribute.
    excludeCloudStorageLocations: A CloudStorageLocations attribute.
    identity: Identity used by this `datasetConfig`.
    includeCloudStorageBuckets: A CloudStorageBuckets attribute.
    includeCloudStorageLocations: A CloudStorageLocations attribute.
    includeNewlyCreatedBuckets: If set to `true`, the request includes all the
      newly created buckets in the dataset that meet the inclusion and
      exclusion rules.
    labels: Labels as key value pairs
    link: Details of the linked dataset.
    name: Identifier. name of resource
    organizationNumber: Optional. Organization resource ID that the source
      projects should belong to. Projects that do not belong to the provided
      organization are not considered when creating the dataset.
    organizationScope: Defines the options for providing a source organization
      for the dataset.
    retentionPeriodDays: Number of days of history that must be retained.
    skipVerificationAndIngest: Optional. If set to `false`, then all the
      permission checks must be successful before the system can start
      ingesting data. This field can only be updated before the system ingests
      data for the first time. Any attempt to modify the field after data
      ingestion starts results in an error.
    sourceFolders: Defines the options for providing source folders for the
      dataset.
    sourceProjects: Defines the options for providing source projects for the
      dataset.
    status: Output only. Status of the `datasetConfig`.
    uid: Output only. System generated unique identifier for the resource.
    updateTime: Output only. The UTC time at which the dataset configuration
      was last updated. This is auto-populated.
  """

  class DatasetConfigStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the `datasetConfig`.

    Values:
      CONFIG_STATE_UNSPECIFIED: Unspecified state.
      CONFIG_STATE_ACTIVE: Active configuration indicates that the
        configuration is actively ingesting data.
      CONFIG_STATE_VERIFICATION_IN_PROGRESS: In this state, the configuration
        is being verified for various permissions.
      CONFIG_STATE_CREATED: Configuration is created and further processing
        needs to happen.
      CONFIG_STATE_PROCESSING: Configuration is under processing
    """
    CONFIG_STATE_UNSPECIFIED = 0
    CONFIG_STATE_ACTIVE = 1
    CONFIG_STATE_VERIFICATION_IN_PROGRESS = 2
    CONFIG_STATE_CREATED = 3
    CONFIG_STATE_PROCESSING = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activityDataRetentionPeriodDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  cloudStorageObjectPath = _messages.StringField(2)
  createTime = _messages.StringField(3)
  datasetConfigState = _messages.EnumField('DatasetConfigStateValueValuesEnum', 4)
  description = _messages.StringField(5)
  excludeCloudStorageBuckets = _messages.MessageField('CloudStorageBuckets', 6)
  excludeCloudStorageLocations = _messages.MessageField('CloudStorageLocations', 7)
  identity = _messages.MessageField('Identity', 8)
  includeCloudStorageBuckets = _messages.MessageField('CloudStorageBuckets', 9)
  includeCloudStorageLocations = _messages.MessageField('CloudStorageLocations', 10)
  includeNewlyCreatedBuckets = _messages.BooleanField(11)
  labels = _messages.MessageField('LabelsValue', 12)
  link = _messages.MessageField('Link', 13)
  name = _messages.StringField(14)
  organizationNumber = _messages.IntegerField(15)
  organizationScope = _messages.BooleanField(16)
  retentionPeriodDays = _messages.IntegerField(17, variant=_messages.Variant.INT32)
  skipVerificationAndIngest = _messages.BooleanField(18)
  sourceFolders = _messages.MessageField('SourceFolders', 19)
  sourceProjects = _messages.MessageField('SourceProjects', 20)
  status = _messages.MessageField('Status', 21)
  uid = _messages.StringField(22)
  updateTime = _messages.StringField(23)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values. * A month and day, with a zero year (for example, an
  anniversary). * A year on its own, with a zero month and a zero day. * A
  year and month, with a zero day (for example, a credit card expiration
  date). Related types: * google.type.TimeOfDay * google.type.DateTime *
  google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class DateTime(_messages.Message):
  r"""Represents civil time (or occasionally physical time). This type can
  represent a civil time in one of a few possible ways: * When utc_offset is
  set and time_zone is unset: a civil time on a calendar day with a particular
  offset from UTC. * When time_zone is set and utc_offset is unset: a civil
  time on a calendar day in a particular time zone. * When neither time_zone
  nor utc_offset is set: a civil time on a calendar day in local time. The
  date is relative to the Proleptic Gregorian Calendar. If year, month, or day
  are 0, the DateTime is considered not to have a specific year, month, or day
  respectively. This type may also be used to represent a physical time if all
  the date and time fields are set and either case of the `time_offset` oneof
  is set. Consider using `Timestamp` message for physical time instead. If
  your use case also would like to store the user's timezone, that can be done
  in another field. This type is more flexible than some applications may
  want. Make sure to document and validate your application's limitations.

  Fields:
    day: Optional. Day of month. Must be from 1 to 31 and valid for the year
      and month, or 0 if specifying a datetime without a day.
    hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
      defaults to 0 (midnight). An API may choose to allow the value
      "24:00:00" for scenarios like business closing time.
    minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults
      to 0.
    month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
      datetime without a month.
    nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
      999,999,999, defaults to 0.
    seconds: Optional. Seconds of minutes of the time. Must normally be from 0
      to 59, defaults to 0. An API may allow the value 60 if it allows leap-
      seconds.
    timeZone: Time zone.
    utcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
      hours. For example, a UTC offset of -4:00 would be represented as {
      seconds: -14400 }.
    year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
      datetime without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hours = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  timeZone = _messages.MessageField('TimeZone', 7)
  utcOffset = _messages.StringField(8)
  year = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class FrequencyOptions(_messages.Message):
  r"""`FrequencyOptions` resource Frequency configuration for inventory report
  generation.

  Enums:
    FrequencyValueValuesEnum: Frequency of inventory report generation.

  Fields:
    endDate: The UTC date to stop generating inventory reports. For
      example,`{"day": 15, "month": 8, "year": 2022}`.
    frequency: Frequency of inventory report generation.
    startDate: The UTC date to start generating inventory reports. For
      example,`{"day": 15, "month": 8, "year": 2022}`.
  """

  class FrequencyValueValuesEnum(_messages.Enum):
    r"""Frequency of inventory report generation.

    Values:
      FREQUENCY_UNSPECIFIED: Unspecified.
      DAILY: Inventory report is generated daily.
      WEEKLY: Inventory report is generated weekly.
    """
    FREQUENCY_UNSPECIFIED = 0
    DAILY = 1
    WEEKLY = 2

  endDate = _messages.MessageField('Date', 1)
  frequency = _messages.EnumField('FrequencyValueValuesEnum', 2)
  startDate = _messages.MessageField('Date', 3)


class Identity(_messages.Message):
  r"""Identity lets the user provide the type of identity to use, and outputs
  the identity string that can be used for IAM policy changes.

  Enums:
    TypeValueValuesEnum: Type of identity to use for the datasetConfig.

  Fields:
    name: Output only. Name of the identity.
    type: Type of identity to use for the datasetConfig.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of identity to use for the datasetConfig.

    Values:
      IDENTITY_TYPE_UNSPECIFIED: Default is unspecified and should not be
        used.
      IDENTITY_TYPE_PER_CONFIG: Google managed service account per resource.
      IDENTITY_TYPE_PER_PROJECT: Google managed service account per project.
    """
    IDENTITY_TYPE_UNSPECIFIED = 0
    IDENTITY_TYPE_PER_CONFIG = 1
    IDENTITY_TYPE_PER_PROJECT = 2

  name = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class Link(_messages.Message):
  r"""Defines the details about the linked dataset.

  Fields:
    dataset: Output only. Dataset name for linked dataset.
    linked: Output only. State of the linked dataset.
  """

  dataset = _messages.StringField(1)
  linked = _messages.BooleanField(2)


class LinkDatasetRequest(_messages.Message):
  r"""Request message for `LinkDataset`"""


class ListDatasetConfigsResponse(_messages.Message):
  r"""Response message for `ListDatasetConfigs`

  Fields:
    datasetConfigs: The list of `DatasetConfigs`
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  datasetConfigs = _messages.MessageField('DatasetConfig', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListReportConfigsResponse(_messages.Message):
  r"""Response message for `ListReportConfigs`

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    reportConfigs: The list of `ReportConfig`
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  reportConfigs = _messages.MessageField('ReportConfig', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListReportDetailsResponse(_messages.Message):
  r"""Response message for `ListReportDetails`.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    reportDetails: The list of `ReportDetail`
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  reportDetails = _messages.MessageField('ReportDetail', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Metadata that helps discover which resources are available in a
  location.

  Fields:
    datasetConfigAvailable: If true,
      `storageinsights.googleapis.com/DatasetConfig` resource is available at
      the location.
    reportConfigAvailable: If true,
      `storageinsights.googleapis.com/ReportConfig` resource is available at
      the location.
  """

  datasetConfigAvailable = _messages.BooleanField(1)
  reportConfigAvailable = _messages.BooleanField(2)


class Metrics(_messages.Message):
  r"""Metrics associated with the generated report.

  Fields:
    processedRecordsCount: Count of Cloud Storage objects that are part of the
      inventory report.
  """

  processedRecordsCount = _messages.IntegerField(1)


class ObjectMetadataReportOptions(_messages.Message):
  r"""Options for including metadata in an inventory report.

  Fields:
    metadataFields: The metadata fields included in an inventory report.
    storageDestinationOptions: Options to store reports in Cloud Storage.
    storageFilters: Filters buckets to generate inventory reports for Cloud
      Storage.
  """

  metadataFields = _messages.StringField(1, repeated=True)
  storageDestinationOptions = _messages.MessageField('CloudStorageDestinationOptions', 2)
  storageFilters = _messages.MessageField('CloudStorageFilters', 3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. Operation create time.
    endTime: Output only. Operation end time.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have an Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class ParquetOptions(_messages.Message):
  r"""Options to configure inventory reports in Parquet format."""


class ProjectErrors(_messages.Message):
  r"""Provides a summary of the project level error statistics.

  Fields:
    destinationProjectCheckHasInternalError: Optional. Indicates whether the
      destination project check failed due to an internal error. If `true`,
      the system automatically retries the check.
    destinationProjectOrgError: Optional. Indicates if the destination project
      resides within the same organization as the source project.
    internalErrorCount: Optional. Number of projects that encountered internal
      errors during validation and are automatically retried.
    nonManagementHubEntitledErrorCount: Optional. Count of projects that are
      not subscribed to Storage Intelligence.
    nonManagementHubEntitledProjectNumbers: Optional. Subset of project
      numbers that are not subscribed to Storage Intelligence.
    nonStorageIntelligenceEntitledErrorCount: Optional. Count of projects that
      are not subscribed to Storage Intelligence.
    nonStorageIntelligenceEntitledProjectNumbers: Optional. Subset of project
      numbers that are not subscribed to Storage Intelligence.
    outsideOrgErrorCount: Optional. Count of projects which are not in the
      same organization.
    outsideOrgProjectNumbers: Optional. Subset of project numbers which are
      not in the same organization.
    validatedCount: Optional. Count of successfully validated projects.
  """

  destinationProjectCheckHasInternalError = _messages.BooleanField(1)
  destinationProjectOrgError = _messages.BooleanField(2)
  internalErrorCount = _messages.IntegerField(3)
  nonManagementHubEntitledErrorCount = _messages.IntegerField(4)
  nonManagementHubEntitledProjectNumbers = _messages.IntegerField(5, repeated=True)
  nonStorageIntelligenceEntitledErrorCount = _messages.IntegerField(6)
  nonStorageIntelligenceEntitledProjectNumbers = _messages.IntegerField(7, repeated=True)
  outsideOrgErrorCount = _messages.IntegerField(8)
  outsideOrgProjectNumbers = _messages.IntegerField(9, repeated=True)
  validatedCount = _messages.IntegerField(10)


class ReportConfig(_messages.Message):
  r"""Message describing the `ReportConfig` object. `ReportConfig` is the
  configuration used to generate inventory reports. For information about how
  to set various fields, see [Create an inventory report
  configuration](https://cloud.google.com/storage/docs/insights/using-
  inventory-reports#create-report-config).

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. The UTC time at which the inventory report
      configuration was created. This is auto-populated.
    csvOptions: Options for CSV formatted reports.
    displayName: User provided display name that can be empty and limited to
      256 characters that is editable..
    frequencyOptions: The frequency of the inventory report generation.
    labels: Labels as key value pairs
    name: Identifier. Name of resource. Format:
      `projects/{project_id}/locations/{location}/reportConfigs/{report-
      config-id}`.
    objectMetadataReportOptions: Options for including object metadata in an
      inventory report.
    parquetOptions: Options for Parquet formatted reports.
    updateTime: Output only. The UTC time at which the inventory report
      configuration was updated. This is auto-populated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  csvOptions = _messages.MessageField('CSVOptions', 2)
  displayName = _messages.StringField(3)
  frequencyOptions = _messages.MessageField('FrequencyOptions', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  objectMetadataReportOptions = _messages.MessageField('ObjectMetadataReportOptions', 7)
  parquetOptions = _messages.MessageField('ParquetOptions', 8)
  updateTime = _messages.StringField(9)


class ReportDetail(_messages.Message):
  r"""Message describing the `ReportDetail` object. `ReportDetail` represents
  the metadata of the generated inventory report for a report configuration.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    labels: Labels as key value pairs
    name: Name of resource. Format:
      `projects/{project_number}/locations/{location}/reportConfigs/{report-
      config-id}/reportDetails/{report-detail-id}`.
    reportMetrics: Metrics of the inventory report.
    reportPathPrefix: Prefix of the object name of each report's shard. This
      has the full prefix except the `extension` and `shard_id`. For example,
      if the `destination_path` is `{report-config-id}/dt={datetime}`, then
      the shard object name is `gs://my-insights/1A34-F2E456-12B456-
      1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
      and the value of `reportPathPrefix` field is `gs://my-insights/1A34-
      F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-
      20T06:35_`.
    shardsCount: Total shards generated for the inventory report.
    snapshotTime: The snapshot time. All the inventory report data is
      referenced at this point of time.
    status: Status of the inventory report.
    targetDatetime: The date and time of the inventory report generation. This
      field is auto-populated. The time part of `target_datetime` is always
      `0`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  name = _messages.StringField(2)
  reportMetrics = _messages.MessageField('Metrics', 3)
  reportPathPrefix = _messages.StringField(4)
  shardsCount = _messages.IntegerField(5)
  snapshotTime = _messages.StringField(6)
  status = _messages.MessageField('Status', 7)
  targetDatetime = _messages.MessageField('DateTime', 8)


class ReportStatsView(_messages.Message):
  r"""Message to encapsulate the various statistics related to the generated
  Report Next ID: 6

  Fields:
    bytesWritten: Actual size in bytes for the report written, as reported by
      the underlying storage system
    projectNumber: Project Number
    recordsProcessed: Actual records processed as reported by the underlying
      storage system
    reportConfigId: ID of the parent ReportConfig for the corresponding
      ReportDetail
    reportDetailId: ID of the ReportDetail for which the stats are generated
  """

  bytesWritten = _messages.IntegerField(1)
  projectNumber = _messages.IntegerField(2)
  recordsProcessed = _messages.IntegerField(3)
  reportConfigId = _messages.StringField(4)
  reportDetailId = _messages.StringField(5)


class SourceFolders(_messages.Message):
  r"""Specifies a set of folders to include in the dataset

  Fields:
    folderNumbers: Optional. The list of folder numbers to include in the
      dataset.
  """

  folderNumbers = _messages.IntegerField(1, repeated=True)


class SourceProjects(_messages.Message):
  r"""Collection of project numbers

  Fields:
    projectNumbers: A string attribute.
  """

  projectNumbers = _messages.IntegerField(1, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageinsightsProjectsLocationsDatasetConfigsCreateRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsCreateRequest object.

  Fields:
    datasetConfig: A DatasetConfig resource to be passed as the request body.
    datasetConfigId: Required. ID of the requesting object. If auto-generating
      ID is enabled on the server-side, remove this field and
      `dataset_config_id` from the method_signature of Create RPC Note: The
      value should not contain any hyphens.
    parent: Required. Value for parent.
    requestId: Optional. A unique identifier for your request. Specify the
      request ID if you need to retry the request. If you retry the request
      with the same ID within 60 minutes, the server ignores the request if it
      has already completed the original request. For example, if your initial
      request times out and you retry the request using the same request ID,
      the server recognizes the original request and does not process the new
      request. The request ID must be a valid UUID and cannot be a zero UUID
      (00000000-0000-0000-0000-000000000000).
  """

  datasetConfig = _messages.MessageField('DatasetConfig', 1)
  datasetConfigId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class StorageinsightsProjectsLocationsDatasetConfigsDeleteRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. A unique identifier for your request. Specify the
      request ID if you need to retry the request. If you retry the request
      with the same ID within 60 minutes, the server ignores the request if it
      has already completed the original request. For example, if your initial
      request times out and you retry the request using the same request ID,
      the server recognizes the original request and does not process the new
      request. The request ID must be a valid UUID and cannot be a zero UUID
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class StorageinsightsProjectsLocationsDatasetConfigsGetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class StorageinsightsProjectsLocationsDatasetConfigsLinkDatasetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsLinkDatasetRequest
  object.

  Fields:
    linkDatasetRequest: A LinkDatasetRequest resource to be passed as the
      request body.
    name: Required. Name of the resource
  """

  linkDatasetRequest = _messages.MessageField('LinkDatasetRequest', 1)
  name = _messages.StringField(2, required=True)


class StorageinsightsProjectsLocationsDatasetConfigsListRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server might return fewer items than
      requested. If unspecified, server picks an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDatasetConfigsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class StorageinsightsProjectsLocationsDatasetConfigsPatchRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsPatchRequest object.

  Fields:
    datasetConfig: A DatasetConfig resource to be passed as the request body.
    name: Identifier. name of resource
    requestId: Optional. A unique identifier for your request. Specify the
      request ID if you need to retry the request. If you retry the request
      with the same ID within 60 minutes, the server ignores the request if it
      has already completed the original request. For example, if your initial
      request times out and you retry the request using the same request ID,
      the server recognizes the original request and does not process the new
      request. The request ID must be a valid UUID and cannot be a zero UUID
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the `DatasetConfig` resource by the update. The fields
      specified in the `update_mask` are relative to the resource, not the
      full request. A field is overwritten if it is in the mask. If the user
      does not provide a mask then it returns an "Invalid Argument" error.
  """

  datasetConfig = _messages.MessageField('DatasetConfig', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageinsightsProjectsLocationsDatasetConfigsUnlinkDatasetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsDatasetConfigsUnlinkDatasetRequest
  object.

  Fields:
    name: Required. Name of the resource
    unlinkDatasetRequest: A UnlinkDatasetRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  unlinkDatasetRequest = _messages.MessageField('UnlinkDatasetRequest', 2)


class StorageinsightsProjectsLocationsGetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class StorageinsightsProjectsLocationsListRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class StorageinsightsProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class StorageinsightsProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class StorageinsightsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class StorageinsightsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class StorageinsightsProjectsLocationsReportConfigsCreateRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    reportConfig: A ReportConfig resource to be passed as the request body.
    requestId: Optional. A unique identifier for your request. Specify the
      request ID if you need to retry the request. If you retry the request
      with the same ID within 60 minutes, the server ignores the request if it
      has already completed the original request. For example, if your initial
      request times out and you retry the request using the same request ID,
      the server recognizes the original request and does not process the new
      request. The request ID must be a valid UUID and cannot be a zero UUID
      (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  reportConfig = _messages.MessageField('ReportConfig', 2)
  requestId = _messages.StringField(3)


class StorageinsightsProjectsLocationsReportConfigsDeleteRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsDeleteRequest object.

  Fields:
    force: Optional. If set, all the inventory report details associated with
      this report configuration are deleted.
    name: Required. Name of the resource
    requestId: Optional. A unique identifier for your request. Specify the
      request ID if you need to retry the request. If you retry the request
      with the same ID within 60 minutes, the server ignores the request if it
      has already completed the original request. For example, if your initial
      request times out and you retry the request using the same request ID,
      the server recognizes the original request and does not process the new
      request. The request ID must be a valid UUID and cannot be a zero UUID
      (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class StorageinsightsProjectsLocationsReportConfigsGetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class StorageinsightsProjectsLocationsReportConfigsListRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server picks the default value.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for `ListReportConfigsRequest`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class StorageinsightsProjectsLocationsReportConfigsPatchRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsPatchRequest object.

  Fields:
    name: Identifier. Name of resource. Format:
      `projects/{project_id}/locations/{location}/reportConfigs/{report-
      config-id}`.
    reportConfig: A ReportConfig resource to be passed as the request body.
    requestId: Optional. A unique identifier for your request. Specify the
      request ID if you need to retry the request. If you retry the request
      with the same ID within 60 minutes, the server ignores the request if it
      has already completed the original request. For example, if your initial
      request times out and you retry the request using the same request ID,
      the server recognizes the original request and does not process the new
      request. The request ID must be a valid UUID and cannot be a zero UUID
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. A mask specifying a list of fields to be updated in
      the `ReportConfig` resource. The fields specified in the `update_mask`
      are relative to the resource, not the full request. A field is
      overwritten if it is in the mask. The `update_mask` is required.
  """

  name = _messages.StringField(1, required=True)
  reportConfig = _messages.MessageField('ReportConfig', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class StorageinsightsProjectsLocationsReportConfigsReportDetailsGetRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsReportDetailsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class StorageinsightsProjectsLocationsReportConfigsReportDetailsListRequest(_messages.Message):
  r"""A StorageinsightsProjectsLocationsReportConfigsReportDetailsListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, the server picks the default value.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for `ListReportDetailsRequest`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TimeZone(_messages.Message):
  r"""Represents a time zone from the [IANA Time Zone
  Database](https://www.iana.org/time-zones).

  Fields:
    id: IANA Time Zone Database time zone. For example "America/New_York".
    version: Optional. IANA Time Zone Database version number. For example
      "2019a".
  """

  id = _messages.StringField(1)
  version = _messages.StringField(2)


class UnlinkDatasetRequest(_messages.Message):
  r"""Request message for `UnlinkDataset`"""


class ValidationErrorsBeforeIngestion(_messages.Message):
  r"""Summary of validation errors that occurred during the verification
  phase.

  Fields:
    bucketErrors: Optional. Provides a summary of the bucket level error
      stats.
    projectErrors: Optional. Provides a summary of the project level error
      stats.
  """

  bucketErrors = _messages.MessageField('BucketErrors', 1)
  projectErrors = _messages.MessageField('ProjectErrors', 2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
