import type { PortInfo } from "@serialport/bindings-cpp";
import type { TsType } from ".";
import type { Adapter, DiscoverableUsbAdapter, UsbAdapterFingerprint } from "./tstype";
declare function matchUsbFingerprint(portInfo: PortInfo, entries: UsbAdapterFingerprint[], isWindows: boolean, conflictProne: boolean): [path: PortInfo["path"], score: number, fingerprint: UsbAdapterFingerprint] | undefined;
export declare function matchUsbAdapter(adapter: Adapter, path: string): Promise<UsbAdapterFingerprint | false>;
export declare function findUsbAdapterBestMatch(adapter: Adapter | undefined, portInfo: PortInfo, isWindows: boolean, conflictProne: boolean): [DiscoverableUsbAdapter, NonNullable<ReturnType<typeof matchUsbFingerprint>>] | undefined;
export declare function findUsbAdapter(adapter?: Adapter, path?: string): Promise<TsType.SerialPortOptions | undefined>;
export declare function findMdnsAdapter(path: string): Promise<TsType.SerialPortOptions>;
export declare function findTcpAdapter(path: string, adapter?: Adapter): TsType.SerialPortOptions;
/**
 * Discover adapter using mDNS, TCP or USB.
 *
 * @param adapter The adapter type.
 *   - mDNS: Unused.
 *   - TCP: Required, cannot discover at this time.
 *   - USB: Optional, limits the discovery to the specified adapter type.
 * @param path The path to the adapter.
 *   - mDNS: Required, serves to initiate the discovery.
 *   - TCP: Required, cannot discover at this time.
 *   - USB: Optional, limits the discovery to the specified path.
 * @returns adapter An adapter type supported by Z2M. While result is TS-typed, this should be validated against actual values before use.
 * @returns path Path to adapter.
 */
export declare function discoverAdapter(adapter?: Adapter, path?: string): Promise<TsType.SerialPortOptions>;
/**
 * @returns List of all serial and mDNS devices found, with matching `adapter` if available
 */
export declare function findAllDevices(): Promise<{
    name: string;
    path: string;
    adapter?: Adapter;
}[]>;
export {};
//# sourceMappingURL=adapterDiscovery.d.ts.map