/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.util.Objects;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketChannel;
import org.newsclub.net.unix.AFSomeSocketChannel;
import org.newsclub.net.unix.BrokenPipeSocketException;
import org.newsclub.net.unix.InvalidArgumentSocketException;
import org.newsclub.net.unix.NotBoundSocketException;
import org.newsclub.net.unix.NotConnectedSocketException;
import org.newsclub.net.unix.SocketClosedByInterruptException;
import org.newsclub.net.unix.SocketClosedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class InterruptibleChannelUtil {
    InterruptibleChannelUtil() {
    }

    static void endInterruptable(AFSomeSocketChannel channel, EndMethod end, boolean complete, Exception exception) throws AsynchronousCloseException {
        if (!complete && exception instanceof ClosedChannelException) {
            complete = true;
        }
        try {
            end.end(complete);
        }
        catch (AsynchronousCloseException e) {
            throw InterruptibleChannelUtil.closeAndThrow(channel, e);
        }
    }

    private static <T extends Exception> T closeAndThrow(AFSomeSocketChannel channel, T exc) {
        Objects.requireNonNull(exc);
        if (channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e2) {
                exc.addSuppressed(e2);
            }
        }
        return exc;
    }

    static IOException ioExceptionOrThrowRuntimeException(Exception exception) {
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new IllegalStateException(exception);
    }

    static Exception handleException(AFSomeSocketChannel channel, IOException e) {
        if (e instanceof NotConnectedSocketException) {
            return (NotYetConnectedException)new NotYetConnectedException().initCause(e);
        }
        if (e instanceof NotBoundSocketException) {
            return (NotYetBoundException)new NotYetBoundException().initCause(e);
        }
        if (e instanceof InvalidArgumentSocketException) {
            if (channel instanceof AFServerSocketChannel) {
                AFServerSocketChannel sc = (AFServerSocketChannel)channel;
                if (!((AFServerSocket)sc.socket()).isBound()) {
                    return (NotYetBoundException)new NotYetBoundException().initCause(e);
                }
            } else if (channel instanceof AFSocketChannel && !((AFSocket)((AFSocketChannel)channel).socket()).isConnected()) {
                return (NotYetConnectedException)new NotYetConnectedException().initCause(e);
            }
        }
        if (e instanceof SocketClosedException || e instanceof ClosedChannelException || e instanceof BrokenPipeSocketException) {
            Thread t = Thread.currentThread();
            if ((e instanceof SocketClosedByInterruptException || e instanceof ClosedByInterruptException) && !t.isInterrupted()) {
                t.interrupt();
            }
            if (!(e instanceof ClosedChannelException)) {
                e = t.isInterrupted() ? (ClosedByInterruptException)new ClosedByInterruptException().initCause(e) : (e instanceof BrokenPipeSocketException ? (AsynchronousCloseException)new AsynchronousCloseException().initCause(e) : (ClosedChannelException)new ClosedChannelException().initCause(e));
            }
            return InterruptibleChannelUtil.closeAndThrow(channel, e);
        }
        return e;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    static interface EndMethod {
        public void end(boolean var1) throws AsynchronousCloseException;
    }
}

