/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license;

import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseTrackingArgs;
import liquibase.license.User;
import liquibase.util.NetUtil;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;

public class LicenseTrack {
    private String licenseKey = null;
    private String jdbcUrl;
    private String schema;
    private String catalog;
    private String databaseName;
    private boolean reference;
    private boolean target;
    private List<User> users;

    public LicenseTrack(String jdbcUrl, String schema, String catalog, String databaseName, boolean reference, boolean target) {
        ConfiguredValue<String> configuredValue;
        LicenseService licenseService;
        LicenseServiceFactory licenseServiceFactory = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        if (licenseServiceFactory != null && (licenseService = licenseServiceFactory.getLicenseService()) != null && (configuredValue = licenseService.getLicenseKey()) != null && configuredValue.found()) {
            this.licenseKey = configuredValue.getValue();
        }
        this.jdbcUrl = jdbcUrl;
        this.schema = schema;
        this.catalog = catalog;
        this.databaseName = databaseName;
        this.reference = reference;
        this.target = target;
        ConfiguredValue<String> userCurrentConfiguredValue = LicenseTrackingArgs.TRACKING_ID.getCurrentConfiguredValue();
        this.users = userCurrentConfiguredValue.found() ? Collections.singletonList(new User(userCurrentConfiguredValue.getValue())) : Collections.singletonList(new User(StringUtils.joinWith((String)"@", (Object[])new Object[]{SystemProperties.getUserName(), NetUtil.getLocalHostName()})));
    }

    @Generated
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Generated
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public boolean isReference() {
        return this.reference;
    }

    @Generated
    public boolean isTarget() {
        return this.target;
    }

    @Generated
    public List<User> getUsers() {
        return this.users;
    }

    @Generated
    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    @Generated
    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @Generated
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Generated
    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setReference(boolean reference) {
        this.reference = reference;
    }

    @Generated
    public void setTarget(boolean target) {
        this.target = target;
    }

    @Generated
    public void setUsers(List<User> users) {
        this.users = users;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicenseTrack)) {
            return false;
        }
        LicenseTrack other = (LicenseTrack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReference() != other.isReference()) {
            return false;
        }
        if (this.isTarget() != other.isTarget()) {
            return false;
        }
        String this$licenseKey = this.getLicenseKey();
        String other$licenseKey = other.getLicenseKey();
        if (this$licenseKey == null ? other$licenseKey != null : !this$licenseKey.equals(other$licenseKey)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        List<User> this$users = this.getUsers();
        List<User> other$users = other.getUsers();
        return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LicenseTrack;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReference() ? 79 : 97);
        result = result * 59 + (this.isTarget() ? 79 : 97);
        String $licenseKey = this.getLicenseKey();
        result = result * 59 + ($licenseKey == null ? 43 : $licenseKey.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        List<User> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LicenseTrack(licenseKey=" + this.getLicenseKey() + ", jdbcUrl=" + this.getJdbcUrl() + ", schema=" + this.getSchema() + ", catalog=" + this.getCatalog() + ", databaseName=" + this.getDatabaseName() + ", reference=" + this.isReference() + ", target=" + this.isTarget() + ", users=" + String.valueOf(this.getUsers()) + ")";
    }
}

