/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;

public class SingleNodeConnectionIdGenerator
implements ConnectionIdGenerator {
    private final int connectionIdLength;

    public SingleNodeConnectionIdGenerator(int connectionIdLength) {
        if (connectionIdLength < 0) {
            throw new IllegalArgumentException("cid length must not be less than 0 bytes!");
        }
        this.connectionIdLength = connectionIdLength;
    }

    @Override
    public boolean useConnectionId() {
        return this.connectionIdLength > 0;
    }

    @Override
    public ConnectionId createConnectionId() {
        if (this.useConnectionId()) {
            byte[] cidBytes = new byte[this.connectionIdLength];
            RandomManager.currentRandom().nextBytes(cidBytes);
            return new ConnectionId(cidBytes);
        }
        return null;
    }

    @Override
    public ConnectionId read(DatagramReader reader) {
        if (this.useConnectionId()) {
            return new ConnectionId(reader.readBytes(this.connectionIdLength));
        }
        return null;
    }
}

