/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstanceCreateInfo;

public class XrVulkanInstanceCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SYSTEMID;
    public static final int CREATEFLAGS;
    public static final int PFNGETINSTANCEPROCADDR;
    public static final int VULKANCREATEINFO;
    public static final int VULKANALLOCATOR;

    public XrVulkanInstanceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrVulkanInstanceCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVulkanInstanceCreateInfoKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrVulkanInstanceCreateInfoKHR.nnext(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrVulkanInstanceCreateInfoKHR.nsystemId(this.address());
    }

    @NativeType(value="XrVulkanInstanceCreateFlagsKHR")
    public long createFlags() {
        return XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address());
    }

    @NativeType(value="PFN_vkGetInstanceProcAddr")
    public long pfnGetInstanceProcAddr() {
        return XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
    }

    @NativeType(value="VkInstanceCreateInfo const *")
    public VkInstanceCreateInfo vulkanCreateInfo() {
        return XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks vulkanAllocator() {
        return XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address());
    }

    public XrVulkanInstanceCreateInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrVulkanInstanceCreateInfoKHR.ntype(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR type$Default() {
        return this.type(1000090000);
    }

    public XrVulkanInstanceCreateInfoKHR next(@NativeType(value="void const *") long value) {
        XrVulkanInstanceCreateInfoKHR.nnext(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR systemId(@NativeType(value="XrSystemId") long value) {
        XrVulkanInstanceCreateInfoKHR.nsystemId(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR createFlags(@NativeType(value="XrVulkanInstanceCreateFlagsKHR") long value) {
        XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
        XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR vulkanCreateInfo(@NativeType(value="VkInstanceCreateInfo const *") VkInstanceCreateInfo value) {
        XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR vulkanAllocator(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address(), value);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR set(int type, long next, long systemId, long createFlags, long pfnGetInstanceProcAddr, VkInstanceCreateInfo vulkanCreateInfo, @Nullable VkAllocationCallbacks vulkanAllocator) {
        this.type(type);
        this.next(next);
        this.systemId(systemId);
        this.createFlags(createFlags);
        this.pfnGetInstanceProcAddr(pfnGetInstanceProcAddr);
        this.vulkanCreateInfo(vulkanCreateInfo);
        this.vulkanAllocator(vulkanAllocator);
        return this;
    }

    public XrVulkanInstanceCreateInfoKHR set(XrVulkanInstanceCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrVulkanInstanceCreateInfoKHR malloc() {
        return (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrVulkanInstanceCreateInfoKHR calloc() {
        return (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrVulkanInstanceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrVulkanInstanceCreateInfoKHR create(long address) {
        return (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static XrVulkanInstanceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrVulkanInstanceCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVulkanInstanceCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrVulkanInstanceCreateInfoKHR malloc(MemoryStack stack) {
        return (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVulkanInstanceCreateInfoKHR calloc(MemoryStack stack) {
        return (XrVulkanInstanceCreateInfoKHR)XrVulkanInstanceCreateInfoKHR.wrap(XrVulkanInstanceCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrVulkanInstanceCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nsystemId(long struct) {
        return UNSAFE.getLong(null, struct + (long)SYSTEMID);
    }

    public static long ncreateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)CREATEFLAGS);
    }

    public static long npfnGetInstanceProcAddr(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PFNGETINSTANCEPROCADDR));
    }

    public static VkInstanceCreateInfo nvulkanCreateInfo(long struct) {
        return VkInstanceCreateInfo.create((long)MemoryUtil.memGetAddress((long)(struct + (long)VULKANCREATEINFO)));
    }

    @Nullable
    public static VkAllocationCallbacks nvulkanAllocator(long struct) {
        return VkAllocationCallbacks.createSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)VULKANALLOCATOR)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsystemId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SYSTEMID, value);
    }

    public static void ncreateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CREATEFLAGS, value);
    }

    public static void npfnGetInstanceProcAddr(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNGETINSTANCEPROCADDR), (long)Checks.check((long)value));
    }

    public static void nvulkanCreateInfo(long struct, VkInstanceCreateInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VULKANCREATEINFO), (long)value.address());
    }

    public static void nvulkanAllocator(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VULKANALLOCATOR), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PFNGETINSTANCEPROCADDR)));
        long vulkanCreateInfo = MemoryUtil.memGetAddress((long)(struct + (long)VULKANCREATEINFO));
        Checks.check((long)vulkanCreateInfo);
        VkInstanceCreateInfo.validate((long)vulkanCreateInfo);
    }

    static {
        Struct.Layout layout = XrVulkanInstanceCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{XrVulkanInstanceCreateInfoKHR.__member((int)4), XrVulkanInstanceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanInstanceCreateInfoKHR.__member((int)8), XrVulkanInstanceCreateInfoKHR.__member((int)8), XrVulkanInstanceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanInstanceCreateInfoKHR.__member((int)POINTER_SIZE), XrVulkanInstanceCreateInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SYSTEMID = layout.offsetof(2);
        CREATEFLAGS = layout.offsetof(3);
        PFNGETINSTANCEPROCADDR = layout.offsetof(4);
        VULKANCREATEINFO = layout.offsetof(5);
        VULKANALLOCATOR = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrVulkanInstanceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final XrVulkanInstanceCreateInfoKHR ELEMENT_FACTORY = XrVulkanInstanceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrVulkanInstanceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVulkanInstanceCreateInfoKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrVulkanInstanceCreateInfoKHR.nnext(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrVulkanInstanceCreateInfoKHR.nsystemId(this.address());
        }

        @NativeType(value="XrVulkanInstanceCreateFlagsKHR")
        public long createFlags() {
            return XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address());
        }

        @NativeType(value="PFN_vkGetInstanceProcAddr")
        public long pfnGetInstanceProcAddr() {
            return XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address());
        }

        @NativeType(value="VkInstanceCreateInfo const *")
        public VkInstanceCreateInfo vulkanCreateInfo() {
            return XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkAllocationCallbacks const *")
        public VkAllocationCallbacks vulkanAllocator() {
            return XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVulkanInstanceCreateInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000090000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrVulkanInstanceCreateInfoKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer systemId(@NativeType(value="XrSystemId") long value) {
            XrVulkanInstanceCreateInfoKHR.nsystemId(this.address(), value);
            return this;
        }

        public Buffer createFlags(@NativeType(value="XrVulkanInstanceCreateFlagsKHR") long value) {
            XrVulkanInstanceCreateInfoKHR.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer pfnGetInstanceProcAddr(@NativeType(value="PFN_vkGetInstanceProcAddr") long value) {
            XrVulkanInstanceCreateInfoKHR.npfnGetInstanceProcAddr(this.address(), value);
            return this;
        }

        public Buffer vulkanCreateInfo(@NativeType(value="VkInstanceCreateInfo const *") VkInstanceCreateInfo value) {
            XrVulkanInstanceCreateInfoKHR.nvulkanCreateInfo(this.address(), value);
            return this;
        }

        public Buffer vulkanAllocator(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
            XrVulkanInstanceCreateInfoKHR.nvulkanAllocator(this.address(), value);
            return this;
        }
    }
}

