/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.io.Serializable;

public abstract class NamedNumber<T extends Number, U extends NamedNumber<T, ?>>
implements Comparable<U>,
Serializable {
    private static final long serialVersionUID = 3858426889927624965L;
    private final T value;
    private final String name;

    protected NamedNumber(T value2, String name) {
        if (value2 == null) {
            throw new IllegalArgumentException("value is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null.");
        }
        this.value = value2;
        this.name = name;
    }

    public T value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public String valueAsString() {
        return this.value.toString();
    }

    @Override
    public abstract int compareTo(U var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(70);
        return sb.append(this.valueAsString()).append(" (").append(this.name).append(")").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedNumber other = (NamedNumber)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.value.equals(other.value);
    }
}

