/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.JvbLastN;
import org.jitsi.videobridge.load_management.JvbLoadReducer;
import org.jitsi.videobridge.load_management.LastNReducer$getMaxForwardedEps$;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0011\u001a\u0004\b \u0010\u001d\u00a8\u0006,"}, d2={"Lorg/jitsi/videobridge/load_management/LastNReducer;", "Lorg/jitsi/videobridge/load_management/JvbLoadReducer;", "conferencesSupplier", "Ljava/util/function/Supplier;", "", "Lorg/jitsi/videobridge/Conference;", "jvbLastN", "Lorg/jitsi/videobridge/JvbLastN;", "<init>", "(Ljava/util/function/Supplier;Lorg/jitsi/videobridge/JvbLastN;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "reductionScale", "", "getReductionScale", "()D", "reductionScale$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "recoverScale", "getRecoverScale", "recoverScale$delegate", "impactTime", "Ljava/time/Duration;", "getImpactTime", "()Ljava/time/Duration;", "impactTime$delegate", "minLastN", "", "getMinLastN", "()I", "minLastN$delegate", "maxEnforcedLastN", "getMaxEnforcedLastN", "maxEnforcedLastN$delegate", "getMaxForwardedEps", "()Ljava/lang/Integer;", "reduceLoad", "", "recover", "", "getStats", "Lorg/jitsi/utils/OrderedJsonObject;", "toString", "", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nLastNReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LastNReducer.kt\norg/jitsi/videobridge/load_management/LastNReducer\n+ 2 SupplierBuilder.kt\norg/jitsi/metaconfig/SupplierBuilderKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n+ 4 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,133:1\n127#2:134\n127#2:136\n127#2:138\n127#2:140\n127#2:142\n59#3:135\n59#3:137\n59#3:139\n59#3:141\n59#3:143\n57#4,4:144\n63#4,4:155\n1360#5:148\n1446#5,5:149\n473#6:154\n*S KotlinDebug\n*F\n+ 1 LastNReducer.kt\norg/jitsi/videobridge/load_management/LastNReducer\n*L\n45#1:134\n49#1:136\n53#1:138\n57#1:140\n61#1:142\n44#1:135\n48#1:137\n52#1:139\n56#1:141\n60#1:143\n65#1:144,4\n99#1:155,4\n70#1:148\n70#1:149,5\n72#1:154\n*E\n"})
public final class LastNReducer
implements JvbLoadReducer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Supplier<Collection<Conference>> conferencesSupplier;
    @NotNull
    private final JvbLastN jvbLastN;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfigDelegate reductionScale$delegate;
    @NotNull
    private final ConfigDelegate recoverScale$delegate;
    @NotNull
    private final ConfigDelegate impactTime$delegate;
    @NotNull
    private final ConfigDelegate minLastN$delegate;
    @NotNull
    private final ConfigDelegate maxEnforcedLastN$delegate;

    /*
     * WARNING - void declaration
     */
    public LastNReducer(@NotNull Supplier<Collection<Conference>> conferencesSupplier, @NotNull JvbLastN jvbLastN) {
        void $this$from$iv;
        Intrinsics.checkNotNullParameter(conferencesSupplier, "conferencesSupplier");
        Intrinsics.checkNotNullParameter(jvbLastN, "jvbLastN");
        this.conferencesSupplier = conferencesSupplier;
        this.jvbLastN = jvbLastN;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        String string = "videobridge.load-management.load-reducers.last-n.reduction-scale";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Double.TYPE), DeprecationKt.noDeprecation());
        boolean $i$f$config = false;
        this.reductionScale$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.recover-scale";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Double.TYPE), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.recoverScale$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.impact-time";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Duration.class), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.impactTime$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.minimum-last-n-value";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.minLastN$delegate = new ConfigDelegate(supplier$iv);
        supplier$iv = "videobridge.load-management.load-reducers.last-n.maximum-enforced-last-n-value";
        configSource$iv = JitsiConfig.Companion.getNewConfig();
        $i$f$from = false;
        supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Integer.TYPE), DeprecationKt.noDeprecation());
        $i$f$config = false;
        this.maxEnforcedLastN$delegate = new ConfigDelegate(supplier$iv);
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info(this.toString());
        }
    }

    private final double getReductionScale() {
        return ((Number)this.reductionScale$delegate.getValue(this, $$delegatedProperties[0])).doubleValue();
    }

    private final double getRecoverScale() {
        return ((Number)this.recoverScale$delegate.getValue(this, $$delegatedProperties[1])).doubleValue();
    }

    private final Duration getImpactTime() {
        return (Duration)this.impactTime$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final int getMinLastN() {
        return ((Number)this.minLastN$delegate.getValue(this, $$delegatedProperties[3])).intValue();
    }

    private final int getMaxEnforcedLastN() {
        return ((Number)this.maxEnforcedLastN$delegate.getValue(this, $$delegatedProperties[4])).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getMaxForwardedEps() {
        void $this$flatMapTo$iv$iv;
        Collection<Conference> collection = this.conferencesSupplier.get();
        Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Conference it = (Conference)element$iv$iv;
            boolean bl = false;
            List<AbstractEndpoint> list = it.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "getEndpoints(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((List)destination$iv$iv);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, getMaxForwardedEps$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.maxOrNull(SequencesKt.map(sequence, LastNReducer::getMaxForwardedEps$lambda$2));
    }

    @Override
    public void reduceLoad() {
        Integer n = this.getMaxForwardedEps();
        if (n == null) {
            LastNReducer $this$reduceLoad_u24lambda_u243 = this;
            boolean bl = false;
            $this$reduceLoad_u24lambda_u243.logger.info("No endpoints with video being forwarded, can't reduce load by reducing last n");
            return;
        }
        int maxForwardedEps = n;
        int newLastN = Integer.max(this.getMinLastN(), (int)((double)maxForwardedEps * this.getReductionScale()));
        this.logger.info("Largest number of forwarded videos was " + maxForwardedEps + ", A last-n value of " + newLastN + " is being enforced to reduce bridge load");
        this.jvbLastN.setJvbLastN(newLastN);
    }

    @Override
    public boolean recover() {
        int currLastN = this.jvbLastN.getJvbLastN();
        if (currLastN == -1) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("No recovery necessary, no JVB last-n is set");
            }
            return false;
        }
        int newLastN = Math.max(currLastN + 1, (int)((double)currLastN * this.getRecoverScale()));
        if (newLastN >= this.getMaxEnforcedLastN()) {
            this.logger.info("JVB last-n was " + currLastN + ", increasing to " + newLastN + " which is beyond the max enforced valueof " + this.getMaxEnforcedLastN() + ", removing limit completely");
            this.jvbLastN.setJvbLastN(-1);
        } else {
            this.logger.info("JVB last-n was " + currLastN + ", increasing to " + newLastN + " as part of load recovery");
            this.jvbLastN.setJvbLastN(newLastN);
        }
        return true;
    }

    @Override
    @NotNull
    public Duration impactTime() {
        return this.getImpactTime();
    }

    @Override
    @NotNull
    public OrderedJsonObject getStats() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getStats_u24lambda_u245 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getStats_u24lambda_u245.put("jvbLastN", (Object)this.jvbLastN.getJvbLastN());
        return orderedJsonObject;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u246.append("LastNReducer with");
        $this$toString_u24lambda_u246.append(" reductionScale: " + this.getReductionScale());
        $this$toString_u24lambda_u246.append(" recoverScale: " + this.getRecoverScale());
        $this$toString_u24lambda_u246.append(" impactTime: " + this.getImpactTime());
        $this$toString_u24lambda_u246.append(" minLastN: " + this.getMinLastN());
        $this$toString_u24lambda_u246.append(" maxEnforcedLastN: " + this.getMaxEnforcedLastN());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final int getMaxForwardedEps$lambda$2(Endpoint it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.numForwardedSources();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "reductionScale", "getReductionScale()D", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "recoverScale", "getRecoverScale()D", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "impactTime", "getImpactTime()Ljava/time/Duration;", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "minLastN", "getMinLastN()I", 0)), Reflection.property1(new PropertyReference1Impl(LastNReducer.class, "maxEnforcedLastN", "getMaxEnforcedLastN()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

