/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.War;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.CopySpecWalker;
import org.jetbrains.plugins.gradle.tooling.builder.WarModelBuilderImplKt;
import org.jetbrains.plugins.gradle.tooling.internal.web.WarModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.web.WebConfigurationImpl;
import org.jetbrains.plugins.gradle.tooling.internal.web.WebResourceImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J,\u0010\u001c\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u001a0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0015H\u0002J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/WarModelBuilderImpl;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "reportErrorMessage", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "collectWebAppDirAndName", "Lkotlin/Pair;", "Ljava/io/File;", "task", "Lorg/gradle/api/tasks/bundling/War;", "collectWebResources", "", "Lorg/jetbrains/plugins/gradle/model/web/WebConfiguration$WebResource;", "webXml", "addWebResource", "", "warDirectory", "relativePath", "file", "collectClasspath", "", "collectManifestContent", "intellij.gradle.toolingExtension.impl"})
public final class WarModelBuilderImpl
extends AbstractModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)WarModelBuilderImplKt.access$getWAR_MODEL_NAME$p(), (Object)modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ((WarPlugin)project.getPlugins().findPlugin(WarPlugin.class) == null) {
            return null;
        }
        List warModels = new ArrayList();
        for (War task : project.getTasks().withType(War.class)) {
            File archiveFile;
            String archiveName;
            Intrinsics.checkNotNullExpressionValue((Object)GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)task), (String)"getTaskArchiveFile(...)");
            Intrinsics.checkNotNullExpressionValue((Object)GradleTaskUtil.getTaskArchiveFileName((AbstractArchiveTask)task), (String)"getTaskArchiveFileName(...)");
            Intrinsics.checkNotNull((Object)task);
            Pair<File, String> pair = this.collectWebAppDirAndName(project, task);
            File webAppDir = (File)pair.component1();
            String webAppDirName = (String)pair.component2();
            File webXml = task.getWebXml();
            List<WebConfiguration.WebResource> webResources = this.collectWebResources(context, project, task, webXml);
            Set<File> classpath = this.collectClasspath(context, project, task);
            String manifestContent = this.collectManifestContent(task);
            WarModelImpl warModel = new WarModelImpl(archiveName, webAppDirName, webAppDir);
            warModel.setArchivePath(archiveFile);
            warModel.setWebXml(webXml);
            warModel.setWebResources(webResources);
            warModel.setClasspath(classpath);
            warModel.setManifestContent(manifestContent);
            warModels.add(warModel);
        }
        return new WebConfigurationImpl(warModels);
    }

    private final void reportErrorMessage(ModelBuilderContext context, Project project, Exception exception) {
        String string = WarModelBuilderImplKt.access$getWAR_MODEL_NAME$p();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getWAR_MODEL_NAME$p(...)");
        this.reportErrorMessage(string, project, context, exception);
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.warConfigurationModel.group").withKind(Message.Kind.WARNING).withTitle("JEE project import failure").withText("Web Facets/Artifacts may not be configured properly").withException(exception).reportMessage(project);
    }

    private final Pair<File, String> collectWebAppDirAndName(Project project, War task) {
        Object object;
        File file;
        Object webAppDirName;
        if (WarModelBuilderImplKt.access$is82OrBetter$p()) {
            File webAppDir = (File)task.getWebAppDirectory().getAsFile().get();
            String webAppDirName2 = webAppDir.getName();
            return TuplesKt.to((Object)webAppDir, (Object)webAppDirName2);
        }
        Object object2 = project.findProperty("webAppDirName");
        if (object2 == null || (object2 = object2.toString()) == null) {
            object2 = webAppDirName = "src/main/webapp";
        }
        if ((file = (object = project.findProperty("webAppDir")) instanceof File ? (File)object : null) == null) {
            file = new File(project.getProjectDir(), (String)webAppDirName);
        }
        File webAppDir = file;
        return TuplesKt.to((Object)webAppDir, (Object)webAppDirName);
    }

    private final List<WebConfiguration.WebResource> collectWebResources(ModelBuilderContext context, Project project, War task, File webXml) {
        try {
            ArrayList<WebConfiguration.WebResource> webResources = new ArrayList<WebConfiguration.WebResource>();
            CopySpecWalker.walk((CopySpec)task.getRootSpec(), new CopySpecWalker.Visitor(task, this, webResources, webXml){
                final /* synthetic */ War $task;
                final /* synthetic */ WarModelBuilderImpl this$0;
                final /* synthetic */ ArrayList<WebConfiguration.WebResource> $webResources;
                final /* synthetic */ File $webXml;
                {
                    this.$task = $task;
                    this.this$0 = $receiver;
                    this.$webResources = $webResources;
                    this.$webXml = $webXml;
                }

                public void visitSourcePath(String relativePath, String path) {
                    File file;
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    File it = file = new File(path);
                    boolean bl = false;
                    File file2 = it.isAbsolute() ? file : null;
                    if (file2 == null) {
                        file2 = new File(this.$task.getProject().getProjectDir(), path);
                    }
                    File file3 = file2;
                    WarModelBuilderImpl.access$addWebResource(this.this$0, this.$webResources, relativePath, "", file3);
                }

                public void visitDir(String relativePath, FileVisitDetails dirDetails) {
                    Intrinsics.checkNotNullParameter((Object)dirDetails, (String)"dirDetails");
                    List list = this.$webResources;
                    String string = dirDetails.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    File file = dirDetails.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                    WarModelBuilderImpl.access$addWebResource(this.this$0, list, relativePath, string, file);
                }

                public void visitFile(String relativePath, FileVisitDetails fileDetails) {
                    Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
                    File file = fileDetails.getFile();
                    if (this.$webXml == null || !Intrinsics.areEqual((Object)file.getCanonicalPath(), (Object)this.$webXml.getCanonicalPath())) {
                        List list = this.$webResources;
                        String string = fileDetails.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        Intrinsics.checkNotNull((Object)file);
                        WarModelBuilderImpl.access$addWebResource(this.this$0, list, relativePath, string, file);
                    }
                }
            });
            return webResources;
        }
        catch (Exception e) {
            this.reportErrorMessage(context, project, e);
            return CollectionsKt.emptyList();
        }
    }

    private final void addWebResource(List<WebConfiguration.WebResource> $this$addWebResource, String warDirectory, String relativePath, File file) {
        String string = warDirectory;
        if (string == null) {
            string = "";
        }
        $this$addWebResource.add(new WebResourceImpl(string, relativePath, file));
    }

    private final Set<File> collectClasspath(ModelBuilderContext context, Project project, War task) {
        try {
            FileCollection fileCollection = task.getClasspath();
            if (fileCollection == null) {
                return SetsKt.emptySet();
            }
            FileCollection classpath = fileCollection;
            Set set = classpath.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
            return CollectionsKt.toSet((Iterable)set);
        }
        catch (Exception e) {
            this.reportErrorMessage(context, project, e);
            return SetsKt.emptySet();
        }
    }

    private final String collectManifestContent(War task) {
        Manifest manifest = task.getManifest();
        if (!(manifest instanceof ManifestInternal)) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ((ManifestInternal)manifest).writeTo((OutputStream)outputStream);
        String contentCharset = ((ManifestInternal)manifest).getContentCharset();
        return outputStream.toString(contentCharset);
    }

    public static final /* synthetic */ void access$addWebResource(WarModelBuilderImpl $this, List $receiver, String warDirectory, String relativePath, File file) {
        $this.addWebResource($receiver, warDirectory, relativePath, file);
    }
}

