/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetDependencyModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.GradleDependencyResolver;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;

@ApiStatus.Internal
public final class GradleSourceSetDependencyResolver {
    private static final String COMPILE_SCOPE = "COMPILE";
    private static final String RUNTIME_SCOPE = "RUNTIME";
    private static final String PROVIDED_SCOPE = "PROVIDED";
    @NotNull
    private final ModelBuilderContext myContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSourceSetArtifactIndex mySourceSetArtifactIndex;

    public GradleSourceSetDependencyResolver(@NotNull ModelBuilderContext context, @NotNull Project project) {
        if (context == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myProject = project;
        this.mySourceSetArtifactIndex = GradleSourceSetArtifactIndex.getInstance(context);
    }

    @NotNull
    public Collection<ExternalDependency> resolveDependencies(@NotNull SourceSet sourceSet) {
        if (sourceSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(2);
        }
        Collection<? extends ExternalDependency> compileDependencies = this.resolveSourceSetCompileDependencies(sourceSet);
        Collection<? extends ExternalDependency> runtimeDependencies = this.resolveSourceSetRuntimeDependencies(sourceSet);
        Collection<? extends ExternalDependency> dependencies = GradleSourceSetDependencyResolver.mergeResolvedDependencies(compileDependencies, runtimeDependencies);
        Collection<? extends ExternalDependency> providedDependencies = this.resolveSourceSetProvidedDependencies(sourceSet, dependencies);
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        result.addAll(dependencies);
        result.addAll(providedDependencies);
        int order = 0;
        for (ExternalDependency dependency : result) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(++order);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<? extends ExternalDependency> resolveSourceSetCompileDependencies(final @NotNull SourceSet sourceSet) {
        if (sourceSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(4);
        }
        FileCollection compileClasspath = this.getCompileClasspath(sourceSet);
        return this.resolveDependenciesWithDefault(compileClasspath, COMPILE_SCOPE, new Supplier<Collection<? extends ExternalDependency>>(){

            public Collection<? extends ExternalDependency> get() {
                String configurationName = sourceSet.getCompileClasspathConfigurationName();
                Configuration configuration = GradleSourceSetDependencyResolver.this.myProject.getConfigurations().getByName(configurationName);
                return GradleSourceSetDependencyResolver.this.getDependencies((FileCollection)configuration, GradleSourceSetDependencyResolver.COMPILE_SCOPE);
            }
        });
    }

    @NotNull
    private Collection<? extends ExternalDependency> resolveSourceSetRuntimeDependencies(final @NotNull SourceSet sourceSet) {
        if (sourceSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(5);
        }
        FileCollection runtimeClasspath = sourceSet.getRuntimeClasspath();
        return this.resolveDependenciesWithDefault(runtimeClasspath, RUNTIME_SCOPE, new Supplier<Collection<? extends ExternalDependency>>(){

            public Collection<? extends ExternalDependency> get() {
                String configurationName = sourceSet.getRuntimeClasspathConfigurationName();
                Configuration configuration = GradleSourceSetDependencyResolver.this.myProject.getConfigurations().getByName(configurationName);
                return GradleSourceSetDependencyResolver.this.getDependencies((FileCollection)configuration, GradleSourceSetDependencyResolver.RUNTIME_SCOPE);
            }
        });
    }

    @NotNull
    private FileCollection getCompileClasspath(SourceSet sourceSet) {
        String compileTaskName = sourceSet.getCompileJavaTaskName();
        Task compileTask = (Task)this.myProject.getTasks().findByName(compileTaskName);
        if (compileTask instanceof AbstractCompile) {
            FileCollection fileCollection;
            try {
                fileCollection = ((AbstractCompile)compileTask).getClasspath();
            }
            catch (Exception e) {
                this.myContext.getMessageReporter().createMessage().withGroup("gradle.dependencyCompileClasspathModel.group").withTitle("Compile classpath resolution error").withText(String.format("Error obtaining compile classpath for java compilation task for [%s] in project [%s]", sourceSet.getName(), this.myProject.getPath())).withException(e).withKind(Message.Kind.WARNING).reportMessage(this.myProject);
            }
            if (fileCollection == null) {
                GradleSourceSetDependencyResolver.$$$reportNull$$$0(6);
            }
            return fileCollection;
        }
        FileCollection fileCollection = sourceSet.getCompileClasspath();
        if (fileCollection == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(7);
        }
        return fileCollection;
    }

    @NotNull
    private Collection<ExternalDependency> resolveDependencies(@NotNull Configuration configuration, @NotNull String scope) {
        if (configuration == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(9);
        }
        GradleDependencyResolver dependencyResolver = new GradleDependencyResolver(this.myContext, this.myProject);
        Collection<ExternalDependency> dependencies = dependencyResolver.resolveDependencies(configuration);
        for (ExternalDependency dependency : dependencies) {
            ((AbstractExternalDependency)dependency).setScope(scope);
        }
        Set runtimeDependencies = RUNTIME_SCOPE.equals(scope) ? this.resolveSourceSetOutputDirsRuntimeFileDependencies(dependencies) : Collections.emptySet();
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        result.addAll(runtimeDependencies);
        result.addAll(dependencies);
        ArrayList<ExternalDependency> arrayList = result;
        if (arrayList == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<ExternalDependency> resolveSourceOutputFileDependencies(@NotNull SourceSetOutput sourceSetOutput, @NotNull String scope) {
        FileCollectionDependency runtimeDependency;
        if (sourceSetOutput == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(12);
        }
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>(2);
        ArrayList<File> files = new ArrayList<File>(sourceSetOutput.getClassesDirs().getFiles());
        files.add(sourceSetOutput.getResourcesDir());
        DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(files);
        fileCollectionDependency.setScope(scope);
        result.add(fileCollectionDependency);
        if (RUNTIME_SCOPE.equals(scope) && (runtimeDependency = GradleSourceSetDependencyResolver.resolveSourceSetOutputDirsRuntimeFileDependency(sourceSetOutput)) != null) {
            result.add((ExternalDependency)runtimeDependency);
        }
        ArrayList<ExternalDependency> arrayList = result;
        if (arrayList == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private Collection<FileCollectionDependency> resolveSourceSetOutputDirsRuntimeFileDependencies(@NotNull Collection<ExternalDependency> dependencies) {
        if (dependencies == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(14);
        }
        LinkedHashSet<FileCollectionDependency> result = new LinkedHashSet<FileCollectionDependency>();
        for (ExternalDependency dependency : dependencies) {
            if (!(dependency instanceof ExternalProjectDependency)) continue;
            ExternalProjectDependency projectDependency = (ExternalProjectDependency)dependency;
            for (File artifactFile : projectDependency.getProjectDependencyArtifacts()) {
                FileCollectionDependency runtimeDependency;
                SourceSet sourceSet = this.mySourceSetArtifactIndex.findByArtifact(artifactFile.getPath());
                if (sourceSet == null || (runtimeDependency = GradleSourceSetDependencyResolver.resolveSourceSetOutputDirsRuntimeFileDependency(sourceSet.getOutput())) == null) continue;
                result.add(runtimeDependency);
            }
        }
        LinkedHashSet<FileCollectionDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    @Nullable
    private static FileCollectionDependency resolveSourceSetOutputDirsRuntimeFileDependency(@NotNull SourceSetOutput sourceSetOutput) {
        ArrayList<File> runtimeOutputDirs;
        if (sourceSetOutput == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(16);
        }
        if (!(runtimeOutputDirs = new ArrayList<File>(sourceSetOutput.getDirs().getFiles())).isEmpty()) {
            DefaultFileCollectionDependency dependency = new DefaultFileCollectionDependency(runtimeOutputDirs);
            dependency.setScope(RUNTIME_SCOPE);
            dependency.setExcludedFromIndexing(true);
            return dependency;
        }
        return null;
    }

    @NotNull
    private static Collection<? extends ExternalDependency> mergeResolvedDependencies(@NotNull Collection<? extends ExternalDependency> compileDependencies, @NotNull Collection<? extends ExternalDependency> runtimeDependencies) {
        if (compileDependencies == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(17);
        }
        if (runtimeDependencies == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(18);
        }
        HashMultimap runtimeDependencyFileIndex = HashMultimap.create();
        for (ExternalDependency externalDependency : runtimeDependencies) {
            Collection<File> collection = GradleSourceSetDependencyResolver.getFiles(externalDependency);
            runtimeDependencyFileIndex.put(collection, (Object)externalDependency);
        }
        LinkedHashSet<? extends ExternalDependency> runtimeOnlyDependencies = new LinkedHashSet<ExternalDependency>(runtimeDependencies);
        for (ExternalDependency externalDependency : compileDependencies) {
            Collection<File> resolvedFiles = GradleSourceSetDependencyResolver.getFiles(externalDependency);
            Collection compileAndRuntimeDependencies = runtimeDependencyFileIndex.get(resolvedFiles);
            if (compileAndRuntimeDependencies.isEmpty()) {
                ((AbstractExternalDependency)externalDependency).setScope(PROVIDED_SCOPE);
                continue;
            }
            runtimeOnlyDependencies.removeAll(compileAndRuntimeDependencies);
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        linkedHashSet.addAll(compileDependencies);
        linkedHashSet.addAll(runtimeOnlyDependencies);
        LinkedHashSet<Object> linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(19);
        }
        return linkedHashSet2;
    }

    @NotNull
    private Collection<? extends ExternalDependency> resolveSourceSetProvidedDependencies(@NotNull SourceSet sourceSet, @NotNull Collection<? extends ExternalDependency> resolvedDependencies) {
        if (sourceSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(20);
        }
        if (resolvedDependencies == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(21);
        }
        LinkedHashSet<Configuration> providedConfigurations = new LinkedHashSet<Configuration>();
        if (sourceSet.getName().equals("main") && this.myProject.getPlugins().findPlugin(WarPlugin.class) != null) {
            Configuration providedRuntime;
            Configuration providedCompile = (Configuration)this.myProject.getConfigurations().findByName("providedCompile");
            if (providedCompile != null) {
                providedConfigurations.add(providedCompile);
            }
            if ((providedRuntime = (Configuration)this.myProject.getConfigurations().findByName("providedRuntime")) != null) {
                providedConfigurations.add(providedRuntime);
            }
        }
        if (providedConfigurations.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                GradleSourceSetDependencyResolver.$$$reportNull$$$0(22);
            }
            return list;
        }
        ArrayListMultimap dependencyFileIndex = ArrayListMultimap.create();
        for (ExternalDependency externalDependency : resolvedDependencies) {
            dependencyFileIndex.put(GradleSourceSetDependencyResolver.getFiles(externalDependency), (Object)externalDependency);
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        for (Configuration configuration : providedConfigurations) {
            Collection<ExternalDependency> providedDependencies = this.resolveDependencies(configuration, PROVIDED_SCOPE);
            Iterator<ExternalDependency> iterator = providedDependencies.iterator();
            while (iterator.hasNext()) {
                ExternalDependency providedDependency = iterator.next();
                Collection<File> files = GradleSourceSetDependencyResolver.getFiles(providedDependency);
                Collection dependencies = dependencyFileIndex.get(files);
                if (dependencies.isEmpty()) continue;
                for (ExternalDependency dependency : dependencies) {
                    ((AbstractExternalDependency)dependency).setScope(PROVIDED_SCOPE);
                }
                iterator.remove();
            }
            result.addAll(providedDependencies);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(23);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<? extends ExternalDependency> getDependencies(final @NotNull FileCollection fileCollection, @NotNull String scope) {
        if (fileCollection == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(25);
        }
        return this.resolveDependenciesWithDefault(fileCollection, scope, new Supplier<Collection<? extends ExternalDependency>>(){

            public Collection<? extends ExternalDependency> get() {
                return Collections.singleton(new DefaultFileCollectionDependency(fileCollection.getFiles()));
            }
        });
    }

    @NotNull
    private Collection<? extends ExternalDependency> resolveDependenciesWithDefault(@NotNull FileCollection fileCollection, @NotNull String scope, @NotNull Supplier<Collection<? extends ExternalDependency>> defaultValueProvider) {
        if (fileCollection == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(27);
        }
        if (defaultValueProvider == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(28);
        }
        if (fileCollection instanceof ConfigurableFileCollection) {
            return this.getDependencies(((ConfigurableFileCollection)fileCollection).getFrom(), scope);
        }
        if (fileCollection instanceof UnionFileCollection) {
            return this.getDependencies(((UnionFileCollection)fileCollection).getSources(), scope);
        }
        if (fileCollection instanceof Configuration) {
            return this.resolveDependencies((Configuration)fileCollection, scope);
        }
        if (fileCollection instanceof SourceSetOutput) {
            return GradleSourceSetDependencyResolver.resolveSourceOutputFileDependencies((SourceSetOutput)fileCollection, scope);
        }
        Collection collection = (Collection)defaultValueProvider.get();
        if (collection == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @NotNull
    private Collection<? extends ExternalDependency> getDependencies(@NotNull Iterable<?> fileCollections, @NotNull String scope) {
        if (fileCollections == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(31);
        }
        LinkedHashSet<? extends ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        for (Object fileCollection : fileCollections) {
            if (!(fileCollection instanceof FileCollection)) continue;
            result.addAll(this.getDependencies((FileCollection)fileCollection, scope));
        }
        LinkedHashSet<? extends ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(32);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<File> getFiles(@NotNull ExternalDependency dependency) {
        if (dependency == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(33);
        }
        if (dependency instanceof ExternalLibraryDependency) {
            Set<File> set = Collections.singleton(((ExternalLibraryDependency)dependency).getFile());
            if (set == null) {
                GradleSourceSetDependencyResolver.$$$reportNull$$$0(34);
            }
            return set;
        }
        if (dependency instanceof FileCollectionDependency) {
            Collection collection = ((FileCollectionDependency)dependency).getFiles();
            if (collection == null) {
                GradleSourceSetDependencyResolver.$$$reportNull$$$0(35);
            }
            return collection;
        }
        if (dependency instanceof ExternalMultiLibraryDependency) {
            Collection collection = ((ExternalMultiLibraryDependency)dependency).getFiles();
            if (collection == null) {
                GradleSourceSetDependencyResolver.$$$reportNull$$$0(36);
            }
            return collection;
        }
        if (dependency instanceof ExternalProjectDependency) {
            Collection collection = ((ExternalProjectDependency)dependency).getProjectDependencyArtifacts();
            if (collection == null) {
                GradleSourceSetDependencyResolver.$$$reportNull$$$0(37);
            }
            return collection;
        }
        Set<File> set = Collections.emptySet();
        if (set == null) {
            GradleSourceSetDependencyResolver.$$$reportNull$$$0(38);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetDependencyModel/GradleSourceSetDependencyResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 12: 
            case 25: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetOutput";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileDependencies";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeDependencies";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedDependencies";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCollection";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueProvider";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCollections";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetDependencyModel/GradleSourceSetDependencyResolver";
                break;
            }
            case 3: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileClasspath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSourceOutputFileDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSourceSetOutputDirsRuntimeFileDependencies";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeResolvedDependencies";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSourceSetProvidedDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependenciesWithDefault";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependencies";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceSetCompileDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceSetRuntimeDependencies";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceOutputFileDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceSetOutputDirsRuntimeFileDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceSetOutputDirsRuntimeFileDependency";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeResolvedDependencies";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveSourceSetProvidedDependencies";
                break;
            }
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependenciesWithDefault";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 23: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

