/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.timing;

import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public abstract class Condition {
    protected static final String EMPTY_TEXT = "";
    private final Description description;

    public Condition(@Nonnull String description) {
        this((Description)new TextDescription(description, new Object[0]));
    }

    public Condition(@Nullable Description description) {
        this.description = description;
    }

    public abstract boolean test();

    @Nonnull
    public final String toString() {
        String descriptionText = this.description != null ? this.description.value() : this.defaultDescription();
        String addendum = this.descriptionAddendum();
        return Strings.concat((Object[])new Object[]{descriptionText, addendum});
    }

    private String defaultDescription() {
        return String.format("condition of type [%s]", this.getClass().getName());
    }

    @Nonnull
    protected String descriptionAddendum() {
        return EMPTY_TEXT;
    }

    protected void done() {
    }
}

