/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service;

import com.intellij.codeInsight.daemon.impl.InjectedLanguageHighlightingRangeReducer;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingManager;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookPerFileHighlightingMetaDataController;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.util.UtilKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/KotlinNotebookInjectedRangeReducer;", "Lcom/intellij/codeInsight/daemon/impl/InjectedLanguageHighlightingRangeReducer;", "<init>", "()V", "reduceRange", "", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ensureScriptConfigurations", "", "", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "manager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\ngeneral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 general.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/KotlinNotebookInjectedRangeReducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,177:1\n1#2:178\n1869#3:179\n295#3,2:180\n1870#3:182\n13#4:183\n*S KotlinDebug\n*F\n+ 1 general.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/KotlinNotebookInjectedRangeReducer\n*L\n162#1:179\n163#1:180,2\n162#1:182\n172#1:183\n*E\n"})
public final class KotlinNotebookInjectedRangeReducer
implements InjectedLanguageHighlightingRangeReducer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public List<TextRange> reduceRange(@NotNull PsiFile file, @NotNull Editor editor) {
        TextRange $i$a$-synchronized-KotlinNotebookInjectedRangeReducer$reduceRange$2;
        NotebookHighlightingManager highlightingManager;
        NotebookHighlightingManager notebookHighlightingManager;
        JupyterPsiCell jupyterPsiCell;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(file instanceof JupyterFile)) return null;
        JupyterFile jupyterFile = (JupyterFile)file;
        if (jupyterFile == null) {
            return null;
        }
        JupyterFile jupyterFile2 = jupyterFile;
        Document document = FileDocumentManager.getInstance().getDocument(jupyterFile2.getVirtualFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (!NotebookCellLines.Companion.hasSupport(editor)) {
            return null;
        }
        VirtualFile virtualFile = jupyterFile2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        BackedNotebookVirtualFile backedNotebook = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
        try {
            jupyterPsiCell = com.intellij.kotlin.jupyter.core.util.UtilKt.getNotebookCells(file);
        }
        catch (IllegalStateException ex) {
            LOG.debug("Can't get Notebook cells list: " + ex);
            jupyterPsiCell = null;
        }
        JupyterPsiCell cells = jupyterPsiCell;
        Project project = ((JupyterFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        int caretOffSet = editor.getCaretModel().getOffset();
        NotebookCellLines.Interval cellUnderEditor = NotebookVisualizationUiUtilKt.getCell((Editor)editor, (int)document2.getLineNumber(caretOffSet));
        ProgressManager.checkCanceled();
        JupyterPsiCell jupyterPsiCell2 = cells;
        if (jupyterPsiCell2 != null) {
            Collection collection = (Collection)jupyterPsiCell2;
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"getInstance(...)");
            this.ensureScriptConfigurations(collection, injectedLanguageManager);
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = backedNotebook;
        if (backedNotebookVirtualFile != null) {
            BackedNotebookVirtualFile it = backedNotebookVirtualFile;
            boolean bl = false;
            notebookHighlightingManager = NotebookHighlightingService.Companion.getForFile(project2, it);
        } else {
            notebookHighlightingManager = null;
        }
        NotebookHighlightingManager notebookHighlightingManager2 = highlightingManager = notebookHighlightingManager;
        NotebookPerFileHighlightingMetaDataController dataController = notebookHighlightingManager2 != null ? notebookHighlightingManager2.getDataController() : null;
        Document document3 = document2;
        synchronized (document3) {
            Collection<TextRange> afterRenaming;
            JupyterPsiCell cellOfChange;
            JupyterPsiCell jupyterPsiCell3;
            Integer cellIndx;
            boolean bl = false;
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController = dataController;
            Integer n = cellIndx = notebookPerFileHighlightingMetaDataController != null ? notebookPerFileHighlightingMetaDataController.getNotebookChangedCellIndex() : null;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                JupyterPsiCell jupyterPsiCell3 = cells;
                jupyterPsiCell3 = jupyterPsiCell3 != null ? (JupyterPsiCell)kotlin.collections.CollectionsKt.getOrNull(jupyterPsiCell3, (int)it) : null;
            } else {
                jupyterPsiCell3 = null;
            }
            JupyterPsiCell jupyterPsiCell5 = cellOfChange = jupyterPsiCell3;
            TextRange cellChangeRange = jupyterPsiCell5 != null ? jupyterPsiCell5.getTextRange() : null;
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController2 = dataController;
            TextRange completeHLRange = notebookPerFileHighlightingMetaDataController2 != null ? notebookPerFileHighlightingMetaDataController2.getCompleteHighlightingRange() : null;
            Ref.ObjectRef severalUpdates = new Ref.ObjectRef();
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController3 = dataController;
            severalUpdates.element = notebookPerFileHighlightingMetaDataController3 != null ? notebookPerFileHighlightingMetaDataController3.getNotebookDocumentTargetRanges() : null;
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController4 = dataController;
            Set highlightingQueue = notebookPerFileHighlightingMetaDataController4 != null ? notebookPerFileHighlightingMetaDataController4.getNotebookRangesQueuedForHL() : null;
            BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebook;
            if (backedNotebookVirtualFile2 != null) {
                BackedNotebookVirtualFile it = backedNotebookVirtualFile2;
                boolean bl3 = false;
                Set set = highlightingQueue;
                if (set != null) {
                    set.addAll(dataController.getLastExecutedCellsBatch());
                }
            }
            if (cellChangeRange != null && (completeHLRange == null || completeHLRange.getStartOffset() == cellChangeRange.getStartOffset())) {
                boolean nothingMatches;
                int correctUnderEditorInd = cellUnderEditor.getOrdinal();
                boolean bl4 = nothingMatches = completeHLRange == null && correctUnderEditorInd - cellIndx > 0 && severalUpdates.element == null;
                if (nothingMatches) {
                    Set set;
                    JupyterPsiCell jupyterPsiCell6 = cells;
                    TextRange toPut = jupyterPsiCell6 != null && (jupyterPsiCell6 = jupyterPsiCell6.get(correctUnderEditorInd)) != null ? jupyterPsiCell6.getTextRange() : null;
                    AtomicBoolean structureChangeIndicator = dataController.getNotebookDocumentStructureNontrivialChanged();
                    dataController.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookInjectedRangeReducer.reduceRange$lambda$10$lambda$3(toPut, correctUnderEditorInd, arg_0)));
                    if (!structureChangeIndicator.get()) {
                        Set set2 = highlightingQueue;
                        if (set2 != null) {
                            set2.clear();
                        }
                    }
                    Set set3 = highlightingQueue;
                    if (set3 != null) {
                        CollectionsKt.addIfNotNull((Collection)set3, (Object)correctUnderEditorInd);
                    }
                    if ((set = highlightingQueue) == null) {
                        set = SetsKt.setOf((Object)correctUnderEditorInd);
                    }
                    highlightingManager.passCreated(set, (List<? extends PsiLanguageInjectionHost>)cells, correctUnderEditorInd);
                    return kotlin.collections.CollectionsKt.listOfNotNull((Object)toPut);
                }
                dataController.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookInjectedRangeReducer.reduceRange$lambda$10$lambda$4(cellChangeRange, severalUpdates, highlightingQueue, cellIndx, arg_0)));
            }
            if (cellIndx != null && dataController.getCompleteHighlightingRange() != null) {
                Object object;
                if (cellUnderEditor.getOrdinal() != cellIndx.intValue()) {
                    JupyterPsiCell jupyterPsiCell7;
                    Set set = highlightingQueue;
                    if (set != null) {
                        set.add((Integer)cellIndx);
                    }
                    object = (jupyterPsiCell7 = cells) != null && (jupyterPsiCell7 = (JupyterPsiCell)jupyterPsiCell7.get(cellUnderEditor.getOrdinal())) != null ? jupyterPsiCell7.getTextRange() : null;
                } else {
                    object = cellChangeRange;
                }
                TextRange newCompleteRange = object;
                dataController.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookInjectedRangeReducer.reduceRange$lambda$10$lambda$5(newCompleteRange, arg_0)));
            }
            if (cellIndx == null) {
                Set set = (Set)severalUpdates.element;
                boolean bl5 = set != null ? set.size() == 1 : false;
                if (bl5) {
                    if (((Number)kotlin.collections.CollectionsKt.first((Iterable)((Iterable)severalUpdates.element))).intValue() != 0) {
                        severalUpdates.element = kotlin.collections.CollectionsKt.toMutableSet((Iterable)kotlin.collections.CollectionsKt.union((Iterable)SetsKt.setOfNotNull((Object)cellUnderEditor.getOrdinal()), (Iterable)((Iterable)severalUpdates.element)));
                        NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController5 = dataController;
                        if (notebookPerFileHighlightingMetaDataController5 != null) {
                            notebookPerFileHighlightingMetaDataController5.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookInjectedRangeReducer.reduceRange$lambda$10$lambda$6((List)cells, cellUnderEditor, severalUpdates, arg_0)));
                        }
                    } else {
                        boolean bl6;
                        Set set4 = highlightingQueue;
                        if (set4 != null) {
                            if (set4.size() == 0) {
                                return null;
                            }
                            bl6 = false;
                        } else {
                            bl6 = false;
                        }
                        if (bl6) {
                            return null;
                        }
                    }
                }
            }
            if (highlightingQueue != null && cells != null) {
                CollectionsKt.addIfNotNull((Collection)highlightingQueue, (Object)cellIndx);
                if (severalUpdates.element == null) {
                    highlightingManager.passCreated(highlightingQueue, (List<? extends PsiLanguageInjectionHost>)cells, cellUnderEditor.getOrdinal());
                    return UtilKt.getCellRangesInDocumentOrNull((List<? extends JupyterPsiCell>)cells, highlightingQueue);
                }
                highlightingQueue.addAll((Collection)severalUpdates.element);
            }
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController6 = dataController;
            Collection<TextRange> collection = afterRenaming = notebookPerFileHighlightingMetaDataController6 != null ? notebookPerFileHighlightingMetaDataController6.getRenamingRanges() : null;
            boolean bl7 = collection != null ? !collection.isEmpty() : false;
            if (bl7) {
                return kotlin.collections.CollectionsKt.toList((Iterable)afterRenaming);
            }
            Set set = (Set)severalUpdates.element;
            boolean bl8 = set != null ? !((Collection)set).isEmpty() : false;
            if (bl8 && cells != null) {
                Set set5;
                Set it = set5 = kotlin.collections.CollectionsKt.toMutableSet((Iterable)((Iterable)severalUpdates.element));
                boolean bl9 = false;
                CollectionsKt.addIfNotNull((Collection)it, (Object)cellIndx);
                if (highlightingQueue != null) {
                    it.addAll(highlightingQueue);
                }
                Set set6 = highlightingQueue;
                if (set6 != null) {
                    set6.addAll(it);
                }
                Set mergedUpdates = set5;
                NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController7 = dataController;
                if (notebookPerFileHighlightingMetaDataController7 != null) {
                    notebookPerFileHighlightingMetaDataController7.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookInjectedRangeReducer.reduceRange$lambda$10$lambda$8(mergedUpdates, arg_0)));
                }
                if (cellIndx == null) {
                    NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController8 = dataController;
                    if ((notebookPerFileHighlightingMetaDataController8 != null ? notebookPerFileHighlightingMetaDataController8.getCompleteHighlightingRange() : null) == null && cellUnderEditor.getOrdinal() != 0) {
                        Set set7 = highlightingQueue;
                        if (set7 != null) {
                            set7.add(cellUnderEditor.getOrdinal());
                        }
                        NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController9 = dataController;
                        if (notebookPerFileHighlightingMetaDataController9 != null) {
                            notebookPerFileHighlightingMetaDataController9.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> KotlinNotebookInjectedRangeReducer.reduceRange$lambda$10$lambda$9((List)cells, cellUnderEditor, arg_0)));
                        }
                    }
                }
                Set set8 = highlightingQueue;
                if (set8 != null) {
                    set8.add(cellUnderEditor.getOrdinal());
                }
                NotebookHighlightingManager notebookHighlightingManager3 = highlightingManager;
                if (notebookHighlightingManager3 == null) return UtilKt.getCellRangesInDocumentOrNull((List<? extends JupyterPsiCell>)cells, highlightingQueue);
                Set set9 = highlightingQueue;
                if (set9 == null) {
                    set9 = SetsKt.setOf((Object)cellUnderEditor.getOrdinal());
                }
                notebookHighlightingManager3.passCreated(set9, (List<? extends PsiLanguageInjectionHost>)cells, cellUnderEditor.getOrdinal());
                return UtilKt.getCellRangesInDocumentOrNull((List<? extends JupyterPsiCell>)cells, highlightingQueue);
            }
            NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController10 = dataController;
            if (notebookPerFileHighlightingMetaDataController10 == null) return null;
            TextRange textRange = notebookPerFileHighlightingMetaDataController10.getCompleteHighlightingRange();
            $i$a$-synchronized-KotlinNotebookInjectedRangeReducer$reduceRange$2 = textRange;
        }
        TextRange textRange = $i$a$-synchronized-KotlinNotebookInjectedRangeReducer$reduceRange$2;
        if (textRange == null) return null;
        TextRange it = textRange;
        boolean bl = false;
        List list = kotlin.collections.CollectionsKt.listOf((Object)it);
        return list;
    }

    private final void ensureScriptConfigurations(Collection<? extends PsiLanguageInjectionHost> $this$ensureScriptConfigurations, InjectedLanguageManager manager) {
        block3: {
            Collection<? extends PsiLanguageInjectionHost> collection = $this$ensureScriptConfigurations;
            if (collection == null) break block3;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object v2;
                List list;
                block2: {
                    PsiLanguageInjectionHost it = (PsiLanguageInjectionHost)element$iv;
                    boolean bl = false;
                    list = manager.getInjectedPsiFiles((PsiElement)it);
                    if (list == null) continue;
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Pair f = (Pair)element$iv2;
                        boolean bl2 = false;
                        if (!(f.first instanceof KtFile)) continue;
                        v2 = element$iv2;
                        break block2;
                    }
                    v2 = null;
                }
                if ((list = (Pair)v2) == null || (list = (PsiElement)((Pair)list).first) == null) continue;
                List ktFile = list;
                boolean bl = false;
                if (!(ktFile instanceof KtFile)) continue;
                Project project = ((KtFile)ktFile).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                JupyterCompilerService jupyterCompilerService = JupyterCompilerService.Companion.getInstance(project);
                Project project2 = ((KtFile)ktFile).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                jupyterCompilerService.ensureScriptConfiguration(project2, (KtFile)ktFile);
            }
        }
    }

    private static final Unit reduceRange$lambda$10$lambda$3(TextRange $toPut, int $correctUnderEditorInd, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setCompleteHighlightingRange($toPut);
        $this$update.setNotebookChangedCellIndex($correctUnderEditorInd);
        return Unit.INSTANCE;
    }

    private static final Unit reduceRange$lambda$10$lambda$4(TextRange $cellChangeRange, Ref.ObjectRef $severalUpdates, Set $highlightingQueue, Integer $cellIndx, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setCompleteHighlightingRange($cellChangeRange);
        Set set = (Set)$severalUpdates.element;
        boolean bl = set != null ? set.size() == 1 : false;
        if (bl) {
            Set set2 = $highlightingQueue;
            if (set2 != null) {
                set2.add($cellIndx);
            }
            $this$update.setNotebookDocumentTargetRanges($highlightingQueue);
        }
        return Unit.INSTANCE;
    }

    private static final Unit reduceRange$lambda$10$lambda$5(TextRange $newCompleteRange, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setCompleteHighlightingRange($newCompleteRange);
        return Unit.INSTANCE;
    }

    private static final Unit reduceRange$lambda$10$lambda$6(List $cells, NotebookCellLines.Interval $cellUnderEditor, Ref.ObjectRef $severalUpdates, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        List list = $cells;
        $this$update.setCompleteHighlightingRange(list != null && (list = (JupyterPsiCell)list.get($cellUnderEditor.getOrdinal())) != null ? list.getTextRange() : null);
        $this$update.setNotebookDocumentTargetRanges((Collection)$severalUpdates.element);
        return Unit.INSTANCE;
    }

    private static final Unit reduceRange$lambda$10$lambda$8(Set $mergedUpdates, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.setNotebookDocumentTargetRanges($mergedUpdates);
        return Unit.INSTANCE;
    }

    private static final Unit reduceRange$lambda$10$lambda$9(List $cells, NotebookCellLines.Interval $cellUnderEditor, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        JupyterPsiCell jupyterPsiCell = (JupyterPsiCell)$cells.get($cellUnderEditor.getOrdinal());
        $this$update.setCompleteHighlightingRange((TextRange)(jupyterPsiCell != null ? jupyterPsiCell.getTextRange() : null));
        return Unit.INSTANCE;
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/KotlinNotebookInjectedRangeReducer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

