/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.trust;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.trust.JupyterTrustManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "getCellLines", "()Lcom/intellij/notebooks/visualization/NotebookCellLines;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "dispose", "", "isTrusted", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "updateIsTrusted", "isCellHasUnsafeOutput", "jupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1617#2,9:130\n1869#2:139\n1870#2:141\n1626#2:142\n1761#2,2:143\n1761#2,3:145\n1763#2:148\n1#3:140\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager\n*L\n101#1:130,9\n101#1:139\n101#1:141\n101#1:142\n102#1:143,2\n104#1:145,3\n102#1:148\n101#1:140\n*E\n"})
public final class JupyterNotebookTrustManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<JupyterNotebookTrustManager> NOTEBOOK_TRUST_MANAGER_KEY = new Key(JupyterNotebookTrustManager.class.getName());
    @NotNull
    private static final Key<Boolean> POINTER_IS_TRUSTED = new Key("POINTER_IS_TRUSTED");

    public JupyterNotebookTrustManager(@NotNull Editor editor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.editor = editor;
        this.project = project;
        Project project2 = this.editor.getProject();
        if (project2 != null && (project2 = project2.getMessageBus()) != null && (project2 = project2.connect((Disposable)this)) != null) {
            Topic topic = FileDocumentManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            project2.subscribe(topic, (Object)new FileDocumentManagerListener(){

                public void beforeAnyDocumentSaving(Document document, boolean explicit) {
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    if (!Intrinsics.areEqual((Object)document, (Object)this.getEditor().getDocument())) {
                        return;
                    }
                    this.updateIsTrusted();
                }

                public void fileContentLoaded(VirtualFile file, Document document) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    if (!Intrinsics.areEqual((Object)document, (Object)this.getEditor().getDocument())) {
                        return;
                    }
                    this.updateIsTrusted();
                }
            });
        }
        this.updateIsTrusted();
        this.getNotebook().getListeners().getCellExecutionListeners().addListener((EventListener)new CellExecutionListener(){

            @Override
            public void executionStarted(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, ZonedDateTime startTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
                if (Intrinsics.areEqual((Object)cellPointer.getUserData(POINTER_IS_TRUSTED), (Object)true)) {
                    return;
                }
                cellPointer.putUserData(POINTER_IS_TRUSTED, (Object)true);
                this.updateIsTrusted();
            }

            @Override
            public void executionStopped(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, JupyterExecutionStatus jupyterStatus, ZonedDateTime endTime) {
                Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
                Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
                NotebookCellLines.Interval interval = cellPointer.get();
                if (interval == null) {
                    return;
                }
                int index = interval.getOrdinal();
                JupyterMetadataAware<JsonNode> jupyterMetadataAware = notebook.getNotebookOrNull();
                if (jupyterMetadataAware == null || (jupyterMetadataAware = jupyterMetadataAware.getCellOrNull(index)) == null) {
                    return;
                }
                JupyterMetadataAware<JsonNode> jupyterCell = jupyterMetadataAware;
                boolean runWithUnsafe = this.isCellHasUnsafeOutput((JupyterCell)jupyterCell);
                if (runWithUnsafe) {
                    this.updateIsTrusted();
                }
            }
        }, (Disposable)this);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NotebookCellLines getCellLines() {
        return NotebookCellLines.Companion.get(this.editor);
    }

    @NotNull
    public final JupyterNotebook getNotebook() {
        return JupyterEditorExtensionsKt.getNotebookFile(this.editor).getNotebook();
    }

    public void dispose() {
    }

    public final boolean isTrusted(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        return Intrinsics.areEqual((Object)cellPointer.getUserData(POINTER_IS_TRUSTED), (Object)true);
    }

    private final void updateIsTrusted() {
        if (JupyterTrustManager.INSTANCE.isTrusted(this.editor)) {
            return;
        }
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(this.editor);
        if (notebookIntervalPointerFactory == null) {
            return;
        }
        NotebookIntervalPointerFactory intervalPointerFactory = notebookIntervalPointerFactory;
        int cellsCount = this.getNotebook().cellsCount();
        for (int i = 0; i < cellsCount; ++i) {
            JupyterCell jupyterCell;
            boolean hasUnsafeOutputs;
            NotebookIntervalPointer pointer;
            if (intervalPointerFactory.getForOrdinalIfExists(i) == null || Intrinsics.areEqual((Object)pointer.getUserData(POINTER_IS_TRUSTED), (Object)true) || !(hasUnsafeOutputs = this.isCellHasUnsafeOutput(jupyterCell = this.getNotebook().getCell(i)))) continue;
            return;
        }
        JupyterTrustManager.INSTANCE.trust(this.editor);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCellHasUnsafeOutput(JupyterCell jupyterCell) {
        boolean bl;
        block9: {
            void $this$mapNotNullTo$iv$iv;
            JupyterOutputs outputs = jupyterCell.getOutputs();
            if (outputs == null) {
                return false;
            }
            Iterable $this$mapNotNull$iv = outputs.getOutputs();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JupyterDisplayDataOutput it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                JupyterOutput it = (JupyterOutput)element$iv$iv;
                boolean bl3 = false;
                if ((it instanceof JupyterDisplayDataOutput ? (JupyterDisplayDataOutput)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List displayOutputs = (List)destination$iv$iv;
            Iterable $this$any$iv = displayOutputs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl5;
                    block8: {
                        JupyterDisplayDataOutput dataOutput = (JupyterDisplayDataOutput)element$iv;
                        boolean bl6 = false;
                        DisplayDataContainer data = dataOutput.getData();
                        Iterable $this$any$iv2 = MimeType.Companion.getUNSAFE_OUTPUTS();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                MimeType it = (MimeType)((Object)element$iv2);
                                boolean bl7 = false;
                                if (!data.has(it.getMimeType())) continue;
                                bl5 = true;
                                break block8;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean hasUnsafeOutputs = bl;
        return hasUnsafeOutputs;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager$Companion;", "", "<init>", "()V", "NOTEBOOK_TRUST_MANAGER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager;", "POINTER_IS_TRUSTED", "", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isTrusted", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            JupyterNotebookTrustManager notebookTrustManager = new JupyterNotebookTrustManager(editor, project2);
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), (Disposable)notebookTrustManager);
            ((EditorImpl)editor).putUserData(NOTEBOOK_TRUST_MANAGER_KEY, (Object)notebookTrustManager);
        }

        public final boolean isTrusted(@NotNull Editor editor, @NotNull NotebookIntervalPointer cellPointer) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            if (JupyterTrustManager.INSTANCE.isTrusted(editor)) {
                return true;
            }
            JupyterNotebookTrustManager jupyterNotebookTrustManager = (JupyterNotebookTrustManager)editor.getUserData(NOTEBOOK_TRUST_MANAGER_KEY);
            if (jupyterNotebookTrustManager == null) {
                return false;
            }
            JupyterNotebookTrustManager notebookTrustManager = jupyterNotebookTrustManager;
            return notebookTrustManager.isTrusted(cellPointer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

