/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.DynamicBundle;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.configurable.VcsContentAnnotationConfigurable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.UnscrambleSupport;
import com.intellij.unscramble.UnscrambleUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class UnscrambleDialog
extends DialogWrapper {
    @NonNls
    private static final String PROPERTY_LOG_FILE_HISTORY_URLS = "UNSCRAMBLE_LOG_FILE_URL";
    @NonNls
    private static final String PROPERTY_LOG_FILE_LAST_URL = "UNSCRAMBLE_LOG_FILE_LAST_URL";
    @NonNls
    private static final String PROPERTY_UNSCRAMBLER_NAME_USED = "UNSCRAMBLER_NAME_USED";
    private final Project myProject;
    private JPanel myEditorPanel;
    private JPanel myLogFileChooserPanel;
    private JComboBox<UnscrambleSupport> myUnscrambleChooser;
    private JPanel myPanel;
    private TextFieldWithHistory myLogFile;
    private JCheckBox myUseUnscrambler;
    private JPanel myUnscramblePanel;
    private JCheckBox myOnTheFly;
    private JPanel myBottomPanel;
    private JPanel mySettingsPanel;
    protected AnalyzeStacktraceUtil.StacktraceEditorPanel myStacktraceEditorPanel;
    private VcsContentAnnotationConfigurable myConfigurable;

    public UnscrambleDialog(@NotNull Project project) {
        if (project == null) {
            UnscrambleDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.populateRegisteredUnscramblerList();
        this.myUnscrambleChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnscrambleSupport unscrambleSupport = UnscrambleDialog.this.getSelectedUnscrambler();
                GuiUtils.enableChildren((Component)UnscrambleDialog.this.myLogFileChooserPanel, (unscrambleSupport != null ? 1 : 0) != 0, (JComponent[])new JComponent[0]);
                UnscrambleDialog.this.updateUnscramblerSettings();
            }
        });
        this.myUseUnscrambler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnscrambleDialog.this.useUnscramblerChanged();
            }
        });
        this.myOnTheFly.setSelected(Registry.get((String)"analyze.exceptions.on.the.fly").asBoolean());
        this.myOnTheFly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Registry.get((String)"analyze.exceptions.on.the.fly").setValue(UnscrambleDialog.this.myOnTheFly.isSelected());
            }
        });
        this.createLogFileChooser();
        this.createEditor();
        this.reset();
        this.setTitle(IdeBundle.message((String)"unscramble.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    private void useUnscramblerChanged() {
        boolean selected = this.myUseUnscrambler.isSelected();
        GuiUtils.enableChildren((Component)this.myUnscramblePanel, (boolean)selected, (JComponent[])new JComponent[]{this.myUseUnscrambler});
        if (selected) {
            this.updateUnscramblerSettings();
        }
    }

    private void updateUnscramblerSettings() {
        UnscrambleSupport unscrambleSupport = (UnscrambleSupport)this.myUnscrambleChooser.getSelectedItem();
        JComponent settingsComponent = unscrambleSupport == null ? null : unscrambleSupport.createSettingsComponent();
        this.mySettingsPanel.removeAll();
        if (settingsComponent != null) {
            this.mySettingsPanel.add((Component)settingsComponent, "Center");
        }
        this.myUnscramblePanel.validate();
    }

    private void reset() {
        List<String> savedUrls = UnscrambleDialog.getSavedLogFileUrls();
        this.myLogFile.setHistorySize(10);
        this.myLogFile.setHistory(savedUrls);
        String lastUrl = this.getPropertyValue(PROPERTY_LOG_FILE_LAST_URL);
        if (lastUrl == null && !savedUrls.isEmpty()) {
            lastUrl = savedUrls.get(savedUrls.size() - 1);
        }
        if (lastUrl != null) {
            this.myLogFile.setText(lastUrl);
            this.myLogFile.setSelectedItem((Object)lastUrl);
        }
        UnscrambleSupport selectedUnscrambler = this.getSavedUnscrambler();
        int count = this.myUnscrambleChooser.getItemCount();
        int index = 0;
        if (selectedUnscrambler != null) {
            for (int i = 0; i < count; ++i) {
                UnscrambleSupport unscrambleSupport = this.myUnscrambleChooser.getItemAt(i);
                if (unscrambleSupport == null || !Comparing.strEqual((String)unscrambleSupport.getPresentableName(), (String)selectedUnscrambler.getPresentableName())) continue;
                index = i;
                break;
            }
        }
        if (count > 0) {
            this.myUseUnscrambler.setEnabled(true);
            this.myUnscrambleChooser.setSelectedIndex(index);
            this.myUseUnscrambler.setSelected(selectedUnscrambler != null);
        } else {
            this.myUseUnscrambler.setEnabled(false);
        }
        this.useUnscramblerChanged();
        this.updateUnscramblerSettings();
        this.myStacktraceEditorPanel.pasteTextFromClipboard();
    }

    private void createUIComponents() {
        this.myBottomPanel = new JPanel(new BorderLayout());
        if (ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            this.myConfigurable = new VcsContentAnnotationConfigurable(this.myProject);
            this.myBottomPanel.add((Component)this.myConfigurable.createComponent(), "Center");
            this.myConfigurable.reset();
        }
    }

    @Nullable
    private UnscrambleSupport getSavedUnscrambler() {
        String savedUnscramblerName = this.getPropertyValue(PROPERTY_UNSCRAMBLER_NAME_USED);
        UnscrambleSupport selectedUnscrambler = null;
        for (UnscrambleSupport unscrambleSupport : UnscrambleSupport.EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual((String)unscrambleSupport.getPresentableName(), (String)savedUnscramblerName)) continue;
            selectedUnscrambler = unscrambleSupport;
        }
        return selectedUnscrambler;
    }

    @NotNull
    public static List<String> getSavedLogFileUrls() {
        ArrayList<String> res = new ArrayList<String>();
        String savedUrl = PropertiesComponent.getInstance().getValue(PROPERTY_LOG_FILE_HISTORY_URLS);
        if (savedUrl != null) {
            ContainerUtil.addAll(res, (Object[])savedUrl.split(":::"));
        }
        ArrayList<String> arrayList = res;
        if (arrayList == null) {
            UnscrambleDialog.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private UnscrambleSupport getSelectedUnscrambler() {
        if (!this.myUseUnscrambler.isSelected()) {
            return null;
        }
        return (UnscrambleSupport)this.myUnscrambleChooser.getSelectedItem();
    }

    private void createEditor() {
        this.myStacktraceEditorPanel = AnalyzeStacktraceUtil.createEditorPanel((Project)this.myProject, (Disposable)this.myDisposable);
        this.myEditorPanel.setLayout(new BorderLayout());
        this.myEditorPanel.add((Component)this.myStacktraceEditorPanel, "Center");
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = (Action[])ArrayUtil.prepend((Object)this.createNormalizeTextAction(), (Object[])super.createActions());
        if (actionArray == null) {
            UnscrambleDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected String getHelpId() {
        return "find.analyzeStackTrace";
    }

    public JComponent getPreferredFocusedComponent() {
        JRootPane pane = this.getRootPane();
        return pane != null ? pane.getDefaultButton() : super.getPreferredFocusedComponent();
    }

    private void createLogFileChooser() {
        this.myLogFile = new TextFieldWithHistory();
        JPanel panel = GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.myLogFile, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)UnscrambleDialog.this.myProject, null, files -> UnscrambleDialog.this.myLogFile.setText(FileUtil.toSystemDependentName((String)((VirtualFile)files.get(files.size() - 1)).getPath())));
            }
        });
        this.myLogFileChooserPanel.setLayout(new BorderLayout());
        this.myLogFileChooserPanel.add((Component)panel, "Center");
    }

    private void populateRegisteredUnscramblerList() {
        for (UnscrambleSupport unscrambleSupport : UnscrambleSupport.EP_NAME.getExtensionList()) {
            this.myUnscrambleChooser.addItem(unscrambleSupport);
        }
        this.myUnscrambleChooser.setRenderer((ListCellRenderer<UnscrambleSupport>)SimpleListCellRenderer.create((String)JavaBundle.message((String)"unscramble.no.unscrambler.item", (Object[])new Object[0]), UnscrambleSupport::getPresentableName));
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public void dispose() {
        if (this.isOK()) {
            List list = this.myLogFile.getHistory();
            PropertiesComponent.getInstance().setValue(PROPERTY_LOG_FILE_HISTORY_URLS, list.isEmpty() ? null : StringUtil.join((Collection)list, (String)":::"), null);
            UnscrambleSupport selectedUnscrambler = this.getSelectedUnscrambler();
            this.saveProperty(PROPERTY_UNSCRAMBLER_NAME_USED, selectedUnscrambler == null ? null : selectedUnscrambler.getPresentableName());
            this.saveProperty(PROPERTY_LOG_FILE_LAST_URL, StringUtil.nullize((String)this.myLogFile.getText()));
        }
        super.dispose();
    }

    private void saveProperty(@NotNull String name, @Nullable String value) {
        if (name == null) {
            UnscrambleDialog.$$$reportNull$$$0(3);
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(name, value);
        PropertiesComponent.getInstance().setValue(name, value);
    }

    @Nullable
    @NlsSafe
    private String getPropertyValue(@NotNull String name) {
        String projectValue;
        if (name == null) {
            UnscrambleDialog.$$$reportNull$$$0(4);
        }
        if ((projectValue = PropertiesComponent.getInstance((Project)this.myProject).getValue(name)) != null) {
            return projectValue;
        }
        return PropertiesComponent.getInstance().getValue(name);
    }

    public void setText(String trace) {
        this.myStacktraceEditorPanel.setText(trace);
    }

    public Action createNormalizeTextAction() {
        return new NormalizeTextAction();
    }

    protected void doOKAction() {
        if (this.myConfigurable != null && this.myConfigurable.isModified()) {
            this.myConfigurable.apply();
        }
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> {
            if (this.performUnscramble()) {
                this.myLogFile.addCurrentTextToHistory();
                this.close(0);
            }
        });
    }

    private boolean performUnscramble() {
        UnscrambleSupport selectedUnscrambler = this.getSelectedUnscrambler();
        JComponent settings = this.mySettingsPanel.getComponentCount() == 0 ? null : (JComponent)this.mySettingsPanel.getComponent(0);
        return UnscrambleDialog.showUnscrambledText(selectedUnscrambler, this.myLogFile.getText(), settings, this.myProject, this.myStacktraceEditorPanel.getText()) != null;
    }

    @VisibleForTesting
    @Nullable
    public static <T extends JComponent> RunContentDescriptor showUnscrambledText(@Nullable UnscrambleSupport<T> unscrambleSupport, String logName, @Nullable T settings, Project project, String textToUnscramble) {
        String unscrambledTrace;
        String string = unscrambledTrace = unscrambleSupport == null ? textToUnscramble : unscrambleSupport.unscramble(project, textToUnscramble, logName, settings);
        if (unscrambledTrace == null) {
            return null;
        }
        List threadStates = ThreadDumpParser.parse((String)unscrambledTrace);
        return UnscrambleUtils.addConsole(project, threadStates, unscrambledTrace);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.unscramble.UnscrambleDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEditorPanel = jPanel4 = new JPanel();
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaBundle", UnscrambleDialog.class).getString("unscramble.stacktrace.caption"));
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUnscramblePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaBundle", UnscrambleDialog.class).getString("unscramble.unscrambler.combobox"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myUnscrambleChooser = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaBundle", UnscrambleDialog.class).getString("unscramble.log.path.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLogFileChooserPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myUseUnscrambler = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JavaBundle", UnscrambleDialog.class).getString("unscramble.use.unscrambler.checkbox"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myOnTheFly = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaBundle", UnscrambleDialog.class).getString("unscramble.detect.analyze.threaddump.from.clipboard.item"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = this.myBottomPanel;
        jPanel5.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/unscramble/UnscrambleDialog";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/unscramble/UnscrambleDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavedLogFileUrls";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private final class NormalizeTextAction
    extends AbstractAction {
        NormalizeTextAction() {
            this.putValue("Name", JavaBundle.message((String)"unscramble.normalize.button", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.FALSE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = UnscrambleDialog.this.myStacktraceEditorPanel.getText();
            UnscrambleDialog.this.myStacktraceEditorPanel.setText(ThreadDumpParser.normalizeText((String)text));
        }
    }
}

