/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.util;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.lang.parser.GrBlockElementType;
import org.jetbrains.plugins.groovy.lang.parser.GrBlockLambdaBodyElementType;
import org.jetbrains.plugins.groovy.lang.parser.GrClosureElementType;

public abstract class ParserUtils {
    public static void getToken(PsiBuilder builder, IElementType elem, @NlsContexts.ParsingError String errorMsg) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
        } else if (errorMsg != null) {
            builder.error(errorMsg);
        }
    }

    public static boolean getToken(PsiBuilder builder, IElementType elem) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType element1, IElementType element2) {
        if (element1 != builder.getTokenType()) {
            return false;
        }
        PsiBuilder.Marker rb = builder.mark();
        builder.advanceLexer();
        boolean res = !builder.eof() && element2 == builder.getTokenType();
        rb.rollbackTo();
        return res;
    }

    public static GrBlockElementType getSwitchAwareBlockElementType(String debugName) {
        return new GrBlockElementType(debugName, true);
    }

    public static GrBlockLambdaBodyElementType getSwitchAwareLambdaBlockElementType(String debugName) {
        return new GrBlockLambdaBodyElementType(debugName, true);
    }

    public static GrClosureElementType getSwitchAwareClosureBlockElementType(String debugName) {
        return new GrClosureElementType(debugName, true);
    }
}

