/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGlobalMemberLookupElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferencesWithSameQualifier;
import org.jetbrains.plugins.groovy.lang.completion.GrDummyIdentifierProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyClassNameInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionContributor;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionData;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovySmartCompletionContributor;
import org.jetbrains.plugins.groovy.lang.completion.QualifiedMethodInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.StaticImportInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.api.GroovyCompletionConsumer;
import org.jetbrains.plugins.groovy.lang.completion.api.GroovyCompletionCustomizer;
import org.jetbrains.plugins.groovy.lang.completion.impl.FastGroovyCompletionConsumer;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.typing.TypeUtils;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineMethodConflictSolver;

public class GrMainCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final ElementPattern<PsiElement> AFTER_AT = PlatformPatterns.psiElement().afterLeaf(new String[]{"@"});
    public static final ElementPattern<PsiElement> IN_CATCH_TYPE = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("(")).withParent(GrCatchClause.class));

    private static void addUnfinishedMethodTypeParameters(@NotNull PsiElement position, @NotNull GroovyCompletionConsumer result2) {
        GrTypeParameterList candidate;
        if (position == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((candidate = GrMainCompletionProvider.findTypeParameterListCandidate(position)) != null) {
            for (GrTypeParameter p : candidate.getTypeParameters()) {
                result2.consume((LookupElement)new JavaPsiClassReferenceElement((PsiClass)p));
            }
        }
    }

    private static void suggestVariableNames(PsiElement context, GroovyCompletionConsumer result2) {
        GrVariable variable;
        PsiElement parent = context.getParent();
        if (GroovyCompletionUtil.isWildcardCompletion(context)) {
            return;
        }
        if (parent instanceof GrVariable && context.equals((variable = (GrVariable)parent).getNameIdentifierGroovy())) {
            GrExpression initializer;
            PsiType type = variable.getTypeGroovy();
            if (type != null) {
                String newName;
                String string;
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
                VariableKind kind = variable instanceof GrParameter ? VariableKind.PARAMETER : (variable instanceof GrField ? VariableKind.FIELD : VariableKind.LOCAL_VARIABLE);
                SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(kind, null, null, type);
                String[] names = suggestedNameInfo.names;
                if (names.length > 0 && !(string = names[0]).equals(newName = InlineMethodConflictSolver.suggestNewName(string, null, parent, new String[0]))) {
                    result2.consume((LookupElement)LookupElementBuilder.create((String)newName));
                    return;
                }
                for (String name2 : names) {
                    result2.consume((LookupElement)LookupElementBuilder.create((String)name2));
                }
            }
            if ((initializer = variable.getInitializerGroovy()) != null) {
                for (String string : GroovyNameSuggestionUtil.suggestVariableNames(initializer, new DefaultGroovyVariableNameValidator(variable), variable.hasModifierProperty("static"))) {
                    result2.consume((LookupElement)LookupElementBuilder.create((String)string));
                }
            }
        }
    }

    @Nullable
    private static GrReferenceElement<?> findGroovyReference(@NotNull PsiElement position) {
        PsiElement parent;
        if (position == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((parent = position.getParent()) instanceof GrReferenceElement) {
            return (GrReferenceElement)parent;
        }
        if (GrMainCompletionProvider.couldContainReference(position)) {
            return GroovyPsiElementFactory.getInstance(position.getProject()).createCodeReference("Foo", position);
        }
        return null;
    }

    private static boolean couldContainReference(PsiElement position) {
        return IN_CATCH_TYPE.accepts((Object)position) || AFTER_AT.accepts((Object)position) || GroovyCompletionUtil.isFirstElementAfterPossibleModifiersInVariableDeclaration(position, true) || GroovyCompletionUtil.isTupleVarNameWithoutTypeDeclared(position);
    }

    @Nullable
    private static GrTypeParameterList findTypeParameterListCandidate(@NotNull PsiElement position) {
        PsiElement candidate;
        PsiElement pparent;
        PsiElement parent;
        if (position == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(3);
        }
        if ((parent = position.getParent()) instanceof GrVariable && (pparent = parent.getParent()) instanceof GrVariableDeclaration && (candidate = PsiUtil.skipWhitespacesAndComments(parent.getPrevSibling(), false)) instanceof GrTypeParameterList) {
            return (GrTypeParameterList)candidate;
        }
        return null;
    }

    public static boolean isClassNamePossible(PsiElement position) {
        PsiElement parent = position.getParent();
        if (parent instanceof GrReferenceElement) {
            return ((GrReferenceElement)parent).getQualifier() == null;
        }
        return GrMainCompletionProvider.couldContainReference(position);
    }

    private static void addAllClasses(CompletionParameters parameters, GroovyCompletionConsumer result2, JavaCompletionSession session) {
        GrMainCompletionProvider.addAllClasses(parameters, (Consumer<? super LookupElement>)((Consumer)result2::consume), session, result2.getCompletionResultSet().getPrefixMatcher());
    }

    public static void addAllClasses(CompletionParameters parameters, Consumer<? super LookupElement> consumer, JavaCompletionSession inheritors, PrefixMatcher matcher) {
        PsiElement position = parameters.getPosition();
        boolean afterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position);
        AllClassesGetter.processJavaClasses((CompletionParameters)parameters, (PrefixMatcher)matcher, (parameters.getInvocationCount() <= 1 ? 1 : 0) != 0, psiClass -> {
            for (JavaPsiClassReferenceElement element : JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)psiClass, (boolean)afterNew, (InsertHandler)new GroovyClassNameInsertHandler(), psiClass1 -> !inheritors.alreadyProcessed(psiClass1))) {
                consumer.consume((Object)element);
            }
        });
    }

    @NotNull
    static Runnable completeReference(CompletionParameters parameters, GrReferenceElement<?> reference, JavaCompletionSession inheritorsHolder, PrefixMatcher matcher, @Nullable CompletionResultSet resultSet, final Consumer<? super LookupElement> _consumer) {
        final HashSet<LookupElement> addedElements = new HashSet<LookupElement>();
        Consumer<LookupElement> consumer = new Consumer<LookupElement>(){
            final Set<LookupElement> added;
            {
                this.added = addedElements;
            }

            public void consume(LookupElement element) {
                if (this.added.add(element)) {
                    _consumer.consume((Object)element);
                }
            }
        };
        HashMap staticMembers = new HashMap();
        PsiElement qualifier = reference.getQualifier();
        PsiType qualifierType = GroovyCompletionUtil.getQualifierType(qualifier);
        if (reference instanceof GrReferenceExpression && (qualifier instanceof GrExpression || qualifier == null)) {
            for (String string : CompleteReferencesWithSameQualifier.getVariantsWithSameQualifier((GrReferenceExpression)reference, matcher, (GrExpression)qualifier)) {
                consumer.consume((Object)LookupElementBuilder.create((String)string).withItemTextUnderlined(true));
            }
            if (parameters.getInvocationCount() < 2 && qualifier != null && qualifierType == null && !GroovyCompletionUtil.canResolveToPackage(qualifier)) {
                if (resultSet != null && parameters.getInvocationCount() == 1) {
                    resultSet.addLookupAdvertisement(GroovyBundle.message("invoke.completion.second.time.to.show.skipped.methods", new Object[0]));
                }
                Runnable runnable = EmptyRunnable.INSTANCE;
                if (runnable == null) {
                    GrMainCompletionProvider.$$$reportNull$$$0(4);
                }
                return runnable;
            }
        }
        ArrayList zeroPriority = new ArrayList();
        PsiClass qualifierClass = com.intellij.psi.util.PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierType);
        boolean honorExcludes = qualifierClass == null || !JavaCompletionUtil.isInExcludedPackage((PsiMember)qualifierClass, (boolean)false);
        Consumer elementConsumer = arg_0 -> GrMainCompletionProvider.lambda$completeReference$2(inheritorsHolder, honorExcludes, qualifierType, parameters, reference, staticMembers, zeroPriority, (Consumer)consumer, arg_0);
        GroovyCompletionUtil.processVariants(reference, matcher, parameters, (Consumer<LookupElement>)elementConsumer);
        for (LookupElement element : zeroPriority) {
            consumer.consume((Object)element);
        }
        zeroPriority.clear();
        if (qualifierType != null) {
            GrMainCompletionProvider.processImplicitSpread(qualifierType, consumer, matcher, addedElements);
        }
        if (qualifier == null) {
            Runnable runnable = () -> GrMainCompletionProvider.lambda$completeReference$4(reference, matcher, parameters, elementConsumer, zeroPriority, (Consumer)consumer, staticMembers);
            if (runnable == null) {
                GrMainCompletionProvider.$$$reportNull$$$0(5);
            }
            return runnable;
        }
        Runnable runnable = EmptyRunnable.INSTANCE;
        if (runnable == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    private static void processImplicitSpread(@NotNull PsiType type, @NotNull Consumer<LookupElement> consumer, @NotNull PrefixMatcher matcher, @NotNull @NotNull HashSet<@NotNull LookupElement> addedElements) {
        Pair<PsiType, Integer> componentPair;
        if (type == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(8);
        }
        if (matcher == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(9);
        }
        if (addedElements == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(10);
        }
        if ((componentPair = PsiUtil.getComponentForSpreadWithDot(type)) == null) {
            return;
        }
        PsiType deepComponentType = (PsiType)componentPair.first;
        int depth = (Integer)componentPair.second;
        if (!(deepComponentType instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)deepComponentType).resolveGenerics();
        PsiClass resolvedClass = resolveResult.getElement();
        if (resolvedClass == null) {
            return;
        }
        Set existingIdentifiers = addedElements.stream().map(element -> element.getLookupString()).collect(Collectors.toSet());
        for (PsiMethod method : resolvedClass.getAllMethods()) {
            LookupElementBuilder lookupElement;
            if (!GroovyPropertyUtils.isSimplePropertyGetter(method) || (lookupElement = CompleteReferenceExpression.createPropertyLookupElement(method, resolveResult.getSubstitutor(), matcher)) == null || existingIdentifiers.contains(lookupElement.getLookupString())) continue;
            PsiType methodReturnType = resolveResult.getSubstitutor().substitute(method.getReturnType());
            String returnTypeRepresentation = methodReturnType == null ? "?" : TypeUtils.box(methodReturnType, (PsiElement)method).getPresentableText();
            consumer.consume((Object)lookupElement.withTypeText(StringUtil.repeat((String)"ArrayList<", (int)depth) + returnTypeRepresentation + StringUtil.repeat((String)">", (int)depth)));
        }
    }

    private static boolean isLightElementDeclaredDuringCompletion(Object object) {
        if (!(object instanceof LightElement) || !(object instanceof PsiNamedElement)) {
            return false;
        }
        String name = ((PsiNamedElement)object).getName();
        if (name == null) {
            return false;
        }
        return name.contains("IntellijIdeaRulezzz".trim()) || name.contains(GrDummyIdentifierProvider.DUMMY_IDENTIFIER_DECAPITALIZED.trim());
    }

    private static Runnable addStaticMembers(CompletionParameters parameters, PrefixMatcher matcher, Map<PsiModifierListOwner, LookupElement> staticMembers, Consumer<? super LookupElement> consumer) {
        StaticMemberProcessor processor = GrMainCompletionProvider.completeStaticMembers(parameters);
        processor.processMembersOfRegisteredClasses(arg_0 -> ((PrefixMatcher)matcher).prefixMatches(arg_0), (member, psiClass) -> {
            if (member instanceof GrAccessorMethod) {
                member = ((GrAccessorMethod)member).getProperty();
            }
            if (staticMembers.containsKey(member = (PsiMember)CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                return;
            }
            String name = member.getName();
            if (name == null || !matcher.prefixMatches(name)) {
                staticMembers.remove(member);
                return;
            }
            JavaGlobalMemberLookupElement element = GrMainCompletionProvider.createGlobalMemberElement(member, psiClass, true);
            staticMembers.put((PsiModifierListOwner)member, (LookupElement)element);
            consumer.consume((Object)element);
        });
        if (parameters.getInvocationCount() >= 2 && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            return () -> processor.processStaticMethodsGlobally(matcher, element -> {
                PsiMember member = (PsiMember)element.getObject();
                if (member instanceof GrAccessorMethod) {
                    member = ((GrAccessorMethod)member).getProperty();
                }
                if (staticMembers.containsKey(member = (PsiMember)CompletionUtil.getOriginalOrSelf((PsiElement)member))) {
                    return;
                }
                staticMembers.put((PsiModifierListOwner)member, (LookupElement)element);
                consumer.consume(element);
            });
        }
        return EmptyRunnable.INSTANCE;
    }

    private static boolean checkForIterator(PsiMethod method) {
        if (!"next".equals(method.getName())) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiClass iterator2 = JavaPsiFacade.getInstance((Project)method.getProject()).findClass("java.util.Iterator", method.getResolveScope());
        return InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)iterator2, (boolean)true);
    }

    private static int assignPriority(LookupElement lookupElement, PsiType qualifierType) {
        Object object = lookupElement.getObject();
        PsiSubstitutor substitutor = null;
        GroovyResolveResult resolveResult = null;
        if (object instanceof GroovyResolveResult) {
            resolveResult = (GroovyResolveResult)object;
            substitutor = resolveResult.getSubstitutor();
            object = ((GroovyResolveResult)object).getElement();
        }
        if (object instanceof GrGdkMethod && GroovyCompletionUtil.skipDefGroovyMethod((GrGdkMethod)object, substitutor, qualifierType)) {
            return -1;
        }
        if (object instanceof PsiMethod && PsiUtil.OPERATOR_METHOD_NAMES.contains(((PsiMethod)object).getName()) && !GrMainCompletionProvider.checkForIterator((PsiMethod)object)) {
            return -3;
        }
        if (object instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)object)) {
            return -1;
        }
        if (resolveResult != null && !resolveResult.isAccessible()) {
            return -2;
        }
        return 0;
    }

    static StaticMemberProcessor completeStaticMembers(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        final PsiElement originalPosition = parameters.getOriginalPosition();
        StaticMemberProcessor processor = new StaticMemberProcessor(position){

            @NotNull
            protected LookupElement createLookupElement(@NotNull PsiMember member, @NotNull PsiClass containingClass, boolean shouldImport) {
                if (member == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (containingClass == null) {
                    2.$$$reportNull$$$0(1);
                }
                JavaGlobalMemberLookupElement javaGlobalMemberLookupElement = GrMainCompletionProvider.createGlobalMemberElement(member, containingClass, shouldImport |= originalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)originalPosition, (boolean)false));
                if (javaGlobalMemberLookupElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return javaGlobalMemberLookupElement;
            }

            protected LookupElement createLookupElement(@NotNull List<? extends PsiMethod> overloads, @NotNull PsiClass containingClass, boolean shouldImport) {
                if (overloads == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (containingClass == null) {
                    2.$$$reportNull$$$0(4);
                }
                return new JavaGlobalMemberLookupElement(overloads, containingClass, QualifiedMethodInsertHandler.INSTANCE, StaticImportInsertHandler.INSTANCE, shouldImport |= originalPosition != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)originalPosition, (boolean)false));
            }

            protected boolean isAccessible(@NotNull PsiMember member) {
                boolean result2;
                if (member == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (!(result2 = super.isAccessible(member)) && member instanceof GrField) {
                    GrAccessorMethod[] getters = ((GrField)member).getGetters();
                    return getters.length > 0 && super.isAccessible((PsiMember)getters[0]);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "containingClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "overloads";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createLookupElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createLookupElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isAccessible";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        PsiFile file = position.getContainingFile();
        if (file instanceof GroovyFile) {
            for (GrImportStatement statement : ((GroovyFile)file).getImportStatements()) {
                PsiElement target;
                GrCodeReferenceElement importReference;
                if (!statement.isStatic() || (importReference = statement.getImportReference()) == null) continue;
                if (!statement.isOnDemand()) {
                    importReference = (GrCodeReferenceElement)importReference.getQualifier();
                }
                if (importReference == null || !((target = importReference.resolve()) instanceof PsiClass)) continue;
                processor.importMembersOf((PsiClass)target);
            }
        }
        return processor;
    }

    static JavaGlobalMemberLookupElement createGlobalMemberElement(PsiMember member, PsiClass containingClass, boolean shouldImport) {
        return new JavaGlobalMemberLookupElement(member, containingClass, QualifiedMethodInsertHandler.INSTANCE, StaticImportInsertHandler.INSTANCE, shouldImport);
    }

    public static void register(CompletionContributor contributor) {
        contributor.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(PsiElement.class), (CompletionProvider)new GrMainCompletionProvider());
    }

    protected final void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            GrMainCompletionProvider.$$$reportNull$$$0(13);
        }
        try (GroovyCompletionConsumer consumer = GrMainCompletionProvider.getCompletionConsumer(result2, parameters);){
            GrMainCompletionProvider.doAddCompletions(parameters, consumer);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void doAddCompletions(CompletionParameters parameters, GroovyCompletionConsumer consumer) {
        GroovyCompletionData.addGroovyDocKeywords(parameters, consumer);
        PsiElement position = parameters.getPosition();
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PsiComment.class))).accepts((Object)position)) {
            return;
        }
        GroovyCompletionData.addGroovyKeywords(parameters, consumer);
        GrMainCompletionProvider.addUnfinishedMethodTypeParameters(position, consumer);
        GrMainCompletionProvider.suggestVariableNames(position, consumer);
        GrReferenceElement<?> reference = GrMainCompletionProvider.findGroovyReference(position);
        if (reference == null) {
            if (parameters.getInvocationCount() >= 2) {
                consumer.interrupt();
                GrMainCompletionProvider.addAllClasses(parameters, consumer.transform(crs -> crs.withPrefixMatcher(CompletionUtil.findJavaIdentifierPrefix((CompletionParameters)parameters))), new JavaCompletionSession(consumer.getCompletionResultSet()));
            }
            return;
        }
        if (reference.getParent() instanceof GrImportStatement && reference.getQualifier() != null) {
            consumer.consume((LookupElement)LookupElementBuilder.create((String)"*"));
        }
        JavaCompletionSession inheritors = new JavaCompletionSession(consumer.getCompletionResultSet());
        if (GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            GroovySmartCompletionContributor.generateInheritorVariants(parameters, consumer.getCompletionResultSet().getPrefixMatcher(), (Consumer<? super LookupElement>)((Consumer)arg_0 -> ((JavaCompletionSession)inheritors).addClassItem(arg_0)));
        }
        Runnable addSlowVariants = GrMainCompletionProvider.completeReference(parameters, reference, inheritors, consumer.getCompletionResultSet().getPrefixMatcher(), consumer.getCompletionResultSet(), (Consumer<? super LookupElement>)((Consumer)lookupElement -> consumer.consume((LookupElement)lookupElement)));
        if (reference.getQualifier() == null) {
            if (!GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
                GroovySmartCompletionContributor.addExpectedClassMembers(parameters, consumer);
            }
            if (GrMainCompletionProvider.isClassNamePossible(position) && JavaCompletionContributor.mayStartClassName((CompletionResultSet)consumer.getCompletionResultSet())) {
                if (parameters.getInvocationCount() >= 2) {
                    GrMainCompletionProvider.addAllClasses(parameters, consumer, inheritors);
                } else {
                    JavaCompletionContributor.advertiseSecondCompletion((Project)position.getProject(), (CompletionResultSet)consumer.getCompletionResultSet());
                }
            }
        }
        consumer.fastElementsProcessed(parameters);
        if (GroovyCompletionUtil.isSlowCompletionEnabled()) {
            addSlowVariants.run();
        }
    }

    private static GroovyCompletionConsumer getCompletionConsumer(CompletionResultSet resultSet, CompletionParameters completionParameters) {
        PsiElement position = completionParameters.getPosition();
        for (GroovyCompletionCustomizer customizer : GroovyCompletionContributor.EP_NAME.getExtensionList()) {
            GroovyCompletionConsumer consumer = customizer.generateCompletionConsumer(position, resultSet);
            if (consumer == null) continue;
            return consumer;
        }
        return new FastGroovyCompletionConsumer(resultSet);
    }

    private static /* synthetic */ void lambda$completeReference$4(GrReferenceElement reference, PrefixMatcher matcher, CompletionParameters parameters, Consumer elementConsumer, List zeroPriority, Consumer consumer, Map staticMembers) {
        PsiFile file = reference.getContainingFile();
        if (!(file instanceof GroovyFileBaseImpl) || !(reference instanceof GrReferenceExpressionImpl)) {
            return;
        }
        CompleteReferenceExpression.processSpecificPlace(matcher, (GrReferenceExpressionImpl)reference, parameters, (Consumer<PsiScopeProcessor>)((Consumer)processor -> ((GroovyFileBaseImpl)file).processComplexImports((PsiScopeProcessor)processor, ResolveUtilKt.initialState(true), reference)), (Consumer<LookupElement>)elementConsumer);
        for (LookupElement element : zeroPriority) {
            consumer.consume((Object)element);
        }
        GrMainCompletionProvider.addStaticMembers(parameters, matcher, staticMembers, (Consumer<? super LookupElement>)consumer).run();
    }

    private static /* synthetic */ void lambda$completeReference$2(JavaCompletionSession inheritorsHolder, boolean honorExcludes, PsiType qualifierType, CompletionParameters parameters, GrReferenceElement reference, Map staticMembers, List zeroPriority, Consumer consumer, LookupElement lookupElement) {
        PrioritizedLookupElement prioritized;
        Object object = lookupElement.getObject();
        if (object instanceof GroovyResolveResult) {
            object = ((GroovyResolveResult)object).getElement();
        }
        if (GrMainCompletionProvider.isLightElementDeclaredDuringCompletion(object)) {
            return;
        }
        if (!(lookupElement instanceof LookupElementBuilder) && inheritorsHolder.alreadyProcessed(lookupElement)) {
            return;
        }
        if (honorExcludes && object instanceof PsiMember && JavaCompletionUtil.isInExcludedPackage((PsiMember)((PsiMember)object), (boolean)true)) {
            return;
        }
        if (!(object instanceof PsiClass)) {
            int priority = GrMainCompletionProvider.assignPriority(lookupElement, qualifierType);
            lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority);
            if (object != null) {
                lookupElement = JavaCompletionUtil.highlightIfNeeded((PsiType)qualifierType, (VirtualFile)parameters.getOriginalFile().getVirtualFile(), (LookupElement)lookupElement, (Object)object, (PsiElement)reference);
            }
        }
        if ((object instanceof PsiMethod || object instanceof PsiField) && ((PsiModifierListOwner)object).hasModifierProperty("static") && lookupElement.getLookupString().equals(((PsiMember)object).getName())) {
            staticMembers.put((PsiModifierListOwner)CompletionUtil.getOriginalOrSelf((PsiElement)((PsiModifierListOwner)object)), lookupElement);
        }
        if ((prioritized = (PrioritizedLookupElement)lookupElement.as(PrioritizedLookupElement.CLASS_CONDITION_KEY)) == null || prioritized.getPriority() == 0.0) {
            zeroPriority.add(lookupElement);
        } else {
            consumer.consume((Object)lookupElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GrMainCompletionProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "completeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUnfinishedMethodTypeParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findGroovyReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTypeParameterListCandidate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitSpread";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

