/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.dictionary.rule;

import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.utils.CollectionsKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0010\u001a\u00020\bH\u0016R7\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004`\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lai/grazie/spell/dictionary/rule/ReplacingRuleDictionary;", "Lai/grazie/spell/dictionary/RuleDictionary;", "rules", "", "Lai/grazie/spell/dictionary/rule/ReplacingRuleDictionary$Descriptor;", "<init>", "(Ljava/util/Collection;)V", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getRules", "()Ljava/util/HashMap;", "rules$delegate", "Lkotlin/Lazy;", "check", "Lai/grazie/spell/dictionary/RuleDictionary$Result;", "word", "suggest", "", "Descriptor", "gec-spell-engine-local"})
public final class ReplacingRuleDictionary
implements RuleDictionary {
    @NotNull
    private final Lazy rules$delegate;

    public ReplacingRuleDictionary(@NotNull Collection<Descriptor> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.rules$delegate = LazyKt.lazy(() -> ReplacingRuleDictionary.rules_delegate$lambda$0(rules));
    }

    private final HashMap<String, Descriptor> getRules() {
        Lazy lazy = this.rules$delegate;
        return (HashMap)lazy.getValue();
    }

    @Override
    @NotNull
    public RuleDictionary.Result check(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.getRules().containsKey(word)) {
            return RuleDictionary.Result.INCORRECT;
        }
        return RuleDictionary.Result.UNKNOWN;
    }

    @Override
    @NotNull
    public Set<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Descriptor descriptor = this.getRules().get(word);
        if (descriptor == null) {
            return CollectionsKt.emptyLinkedSet();
        }
        Descriptor rule = descriptor;
        return CollectionsKt.toLinkedSet(rule.getCorrect());
    }

    private static final HashMap rules_delegate$lambda$0(Collection $rules) {
        HashMap prepared = new HashMap();
        for (Descriptor rule : $rules) {
            for (String incorrect : rule.getIncorrect()) {
                ((Map)prepared).put(incorrect, rule);
            }
        }
        return prepared;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lai/grazie/spell/dictionary/rule/ReplacingRuleDictionary$Descriptor;", "", "incorrect", "", "", "correct", "<init>", "([Ljava/lang/String;[Ljava/lang/String;)V", "getIncorrect", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getCorrect", "toString", "gec-spell-engine-local"})
    public static final class Descriptor {
        @NotNull
        private final String[] incorrect;
        @NotNull
        private final String[] correct;

        public Descriptor(@NotNull String[] incorrect, @NotNull String[] correct2) {
            Intrinsics.checkNotNullParameter((Object)incorrect, (String)"incorrect");
            Intrinsics.checkNotNullParameter((Object)correct2, (String)"correct");
            this.incorrect = incorrect;
            this.correct = correct2;
        }

        @NotNull
        public final String[] getIncorrect() {
            return this.incorrect;
        }

        @NotNull
        public final String[] getCorrect() {
            return this.correct;
        }

        @NotNull
        public String toString() {
            return ArraysKt.joinToString$default((Object[])this.incorrect, null, null, null, (int)0, null, null, (int)63, null) + " -> " + ArraysKt.joinToString$default((Object[])this.correct, null, null, null, (int)0, null, null, (int)63, null);
        }
    }
}

