/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0012J\u0010\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0012J\u0010\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0012H\u0016J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0012J\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0012J\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0012R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgImageElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGraphicsElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransformable;", "x", "", "y", "width", "height", "(DDDD)V", "()V", "bBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getBBox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "elementName", "", "getElementName", "()Ljava/lang/String;", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "href", "pointToAbsoluteCoordinates", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "point", "pointToTransformedCoordinates", "preserveAspectRatio", "transform", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "Companion", "datamodel"})
public class SvgImageElement
extends SvgGraphicsElement
implements SvgTransformable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X = SvgAttributeSpec.Companion.createSpec("x");
    @NotNull
    private static final SvgAttributeSpec<Double> Y = SvgAttributeSpec.Companion.createSpec("y");
    @NotNull
    private static final SvgAttributeSpec<Double> WIDTH = SvgAttributeSpec.Companion.createSpec("width");
    @NotNull
    private static final SvgAttributeSpec<Double> HEIGHT = SvgAttributeSpec.Companion.createSpec("height");
    @NotNull
    private static final SvgAttributeSpec<String> HREF = SvgAttributeSpec.Companion.createSpecNS("href", "xlink", "http://www.w3.org/1999/xlink");
    @NotNull
    private static final SvgAttributeSpec<String> PRESERVE_ASPECT_RATIO = SvgAttributeSpec.Companion.createSpec("preserveAspectRatio");

    public SvgImageElement() {
        this.elementName = "image";
        this.setAttribute(PRESERVE_ASPECT_RATIO, "none");
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    public SvgImageElement(double x2, double y2, double width2, double height) {
        this();
        this.setAttribute(X, x2);
        this.setAttribute(Y, y2);
        this.setAttribute(WIDTH, width2);
        this.setAttribute(HEIGHT, height);
    }

    @NotNull
    public final Property<Double> x() {
        return this.getAttribute(X);
    }

    @NotNull
    public final Property<Double> y() {
        return this.getAttribute(Y);
    }

    @NotNull
    public final Property<Double> width() {
        return this.getAttribute(WIDTH);
    }

    @NotNull
    public final Property<Double> height() {
        return this.getAttribute(HEIGHT);
    }

    @NotNull
    public Property<String> href() {
        return this.getAttribute(HREF);
    }

    @NotNull
    public final Property<String> preserveAspectRatio() {
        return this.getAttribute(PRESERVE_ASPECT_RATIO);
    }

    @Override
    @NotNull
    public Property<SvgTransform> transform() {
        return this.getAttribute(SvgTransformable.Companion.getTRANSFORM());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgImageElement$Companion;", "", "()V", "HEIGHT", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "", "getHEIGHT", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "HREF", "", "getHREF", "PRESERVE_ASPECT_RATIO", "getPRESERVE_ASPECT_RATIO", "WIDTH", "getWIDTH", "X", "getX", "Y", "getY", "datamodel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<Double> getX() {
            return X;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY() {
            return Y;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getWIDTH() {
            return WIDTH;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getHEIGHT() {
            return HEIGHT;
        }

        @NotNull
        public final SvgAttributeSpec<String> getHREF() {
            return HREF;
        }

        @NotNull
        public final SvgAttributeSpec<String> getPRESERVE_ASPECT_RATIO() {
            return PRESERVE_ASPECT_RATIO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

