/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020'H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020%H\u0016J\b\u00102\u001a\u00020%H\u0016J\b\u00103\u001a\u00020%H\u0016J\b\u00104\u001a\u00020%H\u0016J\b\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020%H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020-H\u0016J\b\u0010:\u001a\u00020'H\u0016J\b\u0010;\u001a\u00020/H\u0016J\b\u0010<\u001a\u00020'H\u0016J\b\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u000208H\u0016J\b\u0010@\u001a\u00020*H\u0016J\b\u0010A\u001a\u00020-H\u0016J\b\u0010B\u001a\u00020-H\u0016J\b\u0010C\u001a\u00020/H\u0016J\b\u0010D\u001a\u00020'H\u0016J\b\u0010E\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010\u00a8\u0006F"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultAxisTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "axis", "", "options", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/lang/String;Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "getAxis", "()Ljava/lang/String;", "lineKey", "", "getLineKey$plot_builder", "()Ljava/util/List;", "ontopKey", "getOntopKey$plot_builder", "suffix", "textKey", "getTextKey$plot_builder", "tickKey", "getTickKey$plot_builder", "tickLengthKey", "getTickLengthKey$plot_builder", "titleKey", "getTitleKey$plot_builder", "tooltipFillKey", "getTooltipFillKey$plot_builder", "tooltipKey", "getTooltipKey$plot_builder", "tooltipTextColorKey", "getTooltipTextColorKey$plot_builder", "tooltipTextKey", "getTooltipTextKey$plot_builder", "isOntop", "", "labelAngle", "", "labelHJust", "labelStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "labelVJust", "lineColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "lineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "lineWidth", "rotateLabels", "showLabels", "showLine", "showTickMarks", "showTitle", "showTooltip", "tickLabelMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "tickMarkColor", "tickMarkLength", "tickMarkLineType", "tickMarkWidth", "titleJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "titleMargins", "titleStyle", "tooltipColor", "tooltipFill", "tooltipLineType", "tooltipStrokeWidth", "tooltipTextStyle", "plot-builder"})
public final class DefaultAxisTheme
extends ThemeValuesAccess
implements AxisTheme {
    @NotNull
    private final String axis;
    @NotNull
    private final String suffix;
    @NotNull
    private final List<String> ontopKey;
    @NotNull
    private final List<String> lineKey;
    @NotNull
    private final List<String> textKey;
    @NotNull
    private final List<String> titleKey;
    @NotNull
    private final List<String> tickKey;
    @NotNull
    private final List<String> tickLengthKey;
    @NotNull
    private final List<String> tooltipKey;
    @NotNull
    private final List<String> tooltipFillKey;
    @NotNull
    private final List<String> tooltipTextKey;
    @NotNull
    private final List<String> tooltipTextColorKey;

    public DefaultAxisTheme(@NotNull String axis, @NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        this.axis = axis;
        this.suffix = '_' + this.getAxis();
        Object[] objectArray = new String[]{"axis_ontop" + this.suffix, "axis_ontop"};
        this.ontopKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"axis_line" + this.suffix, "axis_line", "axis" + this.suffix, "axis", "line"};
        this.lineKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"axis_text" + this.suffix, "axis_text", "text", "axis" + this.suffix, "axis"};
        this.textKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"axis_title" + this.suffix, "axis_title", "title", "text", "axis" + this.suffix, "axis"};
        this.titleKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"axis_ticks" + this.suffix, "axis_ticks", "axis" + this.suffix, "axis", "line"};
        this.tickKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"axis_ticks_length" + this.suffix, "axis_ticks_length"};
        this.tickLengthKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"axis_tooltip" + this.suffix, "axis_tooltip", "rect"};
        this.tooltipKey = CollectionsKt.listOf((Object[])objectArray);
        this.tooltipFillKey = CollectionsKt.plus((Collection)this.tooltipKey, (Iterable)this.lineKey);
        objectArray = new String[]{"axis_tooltip_text" + this.suffix, "axis_tooltip_text", "tooltip_text", "text"};
        this.tooltipTextKey = CollectionsKt.listOf((Object[])objectArray);
        this.tooltipTextColorKey = CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)this.tooltipTextKey, (Object)"text"), (Iterable)this.tooltipKey);
    }

    @Override
    @NotNull
    public String getAxis() {
        return this.axis;
    }

    @NotNull
    public final List<String> getOntopKey$plot_builder() {
        return this.ontopKey;
    }

    @NotNull
    public final List<String> getLineKey$plot_builder() {
        return this.lineKey;
    }

    @NotNull
    public final List<String> getTextKey$plot_builder() {
        return this.textKey;
    }

    @NotNull
    public final List<String> getTitleKey$plot_builder() {
        return this.titleKey;
    }

    @NotNull
    public final List<String> getTickKey$plot_builder() {
        return this.tickKey;
    }

    @NotNull
    public final List<String> getTickLengthKey$plot_builder() {
        return this.tickLengthKey;
    }

    @NotNull
    public final List<String> getTooltipKey$plot_builder() {
        return this.tooltipKey;
    }

    @NotNull
    public final List<String> getTooltipFillKey$plot_builder() {
        return this.tooltipFillKey;
    }

    @NotNull
    public final List<String> getTooltipTextKey$plot_builder() {
        return this.tooltipTextKey;
    }

    @NotNull
    public final List<String> getTooltipTextColorKey$plot_builder() {
        return this.tooltipTextColorKey;
    }

    @Override
    public boolean isOntop() {
        return this.getBoolean(this.ontopKey);
    }

    @Override
    public boolean showLine() {
        return !this.isElemBlank(this.lineKey);
    }

    @Override
    public boolean showTickMarks() {
        return !this.isElemBlank(this.tickKey);
    }

    @Override
    public boolean showLabels() {
        return !this.isElemBlank(this.textKey);
    }

    @Override
    public boolean showTitle() {
        return !this.isElemBlank(this.titleKey);
    }

    @Override
    public boolean showTooltip() {
        return !this.isElemBlank(this.tooltipKey);
    }

    @Override
    @NotNull
    public ThemeTextStyle titleStyle() {
        return this.getTextStyle(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public TextJustification titleJustification() {
        return this.getTextJustification(this.getElemValue(this.titleKey));
    }

    @Override
    @NotNull
    public Thickness titleMargins() {
        return this.getMargins(this.getElemValue(this.titleKey));
    }

    @Override
    public double lineWidth() {
        return this.getNumber(this.getElemValue(this.lineKey), "size");
    }

    @Override
    @NotNull
    public Color lineColor() {
        return this.getColor(this.getElemValue(this.lineKey), "color");
    }

    @Override
    @NotNull
    public LineType lineType() {
        return this.getLineType(this.getElemValue(this.lineKey));
    }

    @Override
    public double tickMarkWidth() {
        return this.getNumber(this.getElemValue(this.tickKey), "size");
    }

    @Override
    public double tickMarkLength() {
        return this.getNumber(this.tickLengthKey);
    }

    @Override
    @NotNull
    public Color tickMarkColor() {
        return this.getColor(this.getElemValue(this.tickKey), "color");
    }

    @Override
    @NotNull
    public LineType tickMarkLineType() {
        return this.getLineType(this.getElemValue(this.tickKey));
    }

    @Override
    @NotNull
    public Thickness tickLabelMargins() {
        return this.getMargins(this.getElemValue(this.textKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle labelStyle() {
        return this.getTextStyle(this.getElemValue(this.textKey));
    }

    @Override
    public boolean rotateLabels() {
        return !Double.isNaN(this.labelAngle()) || !Double.isNaN(this.labelHJust()) || !Double.isNaN(this.labelVJust());
    }

    @Override
    public double labelAngle() {
        return this.getNumber(this.getElemValue(this.textKey), "angle");
    }

    @Override
    public double labelHJust() {
        return this.getNumber(this.getElemValue(this.textKey), "hjust");
    }

    @Override
    public double labelVJust() {
        return this.getNumber(this.getElemValue(this.textKey), "vjust");
    }

    @Override
    @NotNull
    public Color tooltipFill() {
        return this.getColor(this.getElemValue(this.tooltipFillKey), "fill");
    }

    @Override
    @NotNull
    public Color tooltipColor() {
        return this.getColor(this.getElemValue(this.tooltipKey), "color");
    }

    @Override
    public double tooltipStrokeWidth() {
        return this.getNumber(this.getElemValue(this.tooltipKey), "size");
    }

    @Override
    @NotNull
    public LineType tooltipLineType() {
        return this.getLineType(this.getElemValue(this.tooltipKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle tooltipTextStyle() {
        Color tooltipTextColor = this.getColor(this.getElemValue(this.tooltipTextColorKey), "color");
        ThemeTextStyle textStyle = this.getTextStyle(this.getElemValue(this.tooltipTextKey));
        return ThemeTextStyle.copy$default(textStyle, null, null, 0.0, tooltipTextColor, false, 23, null);
    }

    @Override
    public double tickLabelDistance(boolean isHorizontalOrientation) {
        return AxisTheme.DefaultImpls.tickLabelDistance(this, isHorizontalOrientation);
    }
}

