/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.spark.sql.connect.client.arrow.ArrowVectorReader;
import org.apache.spark.sql.connect.client.arrow.BigIntVectorReader;
import org.apache.spark.sql.connect.client.arrow.BitVectorReader;
import org.apache.spark.sql.connect.client.arrow.DateDayVectorReader;
import org.apache.spark.sql.connect.client.arrow.DecimalVectorReader;
import org.apache.spark.sql.connect.client.arrow.DurationVectorReader;
import org.apache.spark.sql.connect.client.arrow.Float4VectorReader;
import org.apache.spark.sql.connect.client.arrow.Float8VectorReader;
import org.apache.spark.sql.connect.client.arrow.IntVectorReader;
import org.apache.spark.sql.connect.client.arrow.IntervalYearVectorReader;
import org.apache.spark.sql.connect.client.arrow.LargeVarBinaryVectorReader;
import org.apache.spark.sql.connect.client.arrow.LargeVarCharVectorReader;
import org.apache.spark.sql.connect.client.arrow.NullVectorReader$;
import org.apache.spark.sql.connect.client.arrow.SmallIntVectorReader;
import org.apache.spark.sql.connect.client.arrow.TimeStampMicroTZVectorReader;
import org.apache.spark.sql.connect.client.arrow.TimeStampMicroVectorReader;
import org.apache.spark.sql.connect.client.arrow.TinyIntVectorReader;
import org.apache.spark.sql.connect.client.arrow.VarBinaryVectorReader;
import org.apache.spark.sql.connect.client.arrow.VarCharVectorReader;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.UpCastRule$;
import org.apache.spark.sql.util.ArrowUtils$;

public final class ArrowVectorReader$ {
    public static final ArrowVectorReader$ MODULE$ = new ArrowVectorReader$();

    public ArrowVectorReader apply(DataType targetDataType, FieldVector vector, String timeZoneId) {
        DataType vectorDataType = ArrowUtils$.MODULE$.fromArrowType(vector.getField().getType());
        if (!UpCastRule$.MODULE$.canUpCast(vectorDataType, targetDataType)) {
            throw new RuntimeException("Reading '" + targetDataType + "' values from a " + vector.getClass() + " instance is not supported.");
        }
        FieldVector fieldVector = vector;
        if (fieldVector instanceof BitVector) {
            BitVector bitVector = (BitVector)fieldVector;
            return new BitVectorReader(bitVector);
        }
        if (fieldVector instanceof TinyIntVector) {
            TinyIntVector tinyIntVector = (TinyIntVector)fieldVector;
            return new TinyIntVectorReader(tinyIntVector);
        }
        if (fieldVector instanceof SmallIntVector) {
            SmallIntVector smallIntVector = (SmallIntVector)fieldVector;
            return new SmallIntVectorReader(smallIntVector);
        }
        if (fieldVector instanceof IntVector) {
            IntVector intVector = (IntVector)fieldVector;
            return new IntVectorReader(intVector);
        }
        if (fieldVector instanceof BigIntVector) {
            BigIntVector bigIntVector = (BigIntVector)fieldVector;
            return new BigIntVectorReader(bigIntVector);
        }
        if (fieldVector instanceof Float4Vector) {
            Float4Vector float4Vector = (Float4Vector)fieldVector;
            return new Float4VectorReader(float4Vector);
        }
        if (fieldVector instanceof Float8Vector) {
            Float8Vector float8Vector = (Float8Vector)fieldVector;
            return new Float8VectorReader(float8Vector);
        }
        if (fieldVector instanceof DecimalVector) {
            DecimalVector decimalVector = (DecimalVector)fieldVector;
            return new DecimalVectorReader(decimalVector);
        }
        if (fieldVector instanceof VarCharVector) {
            VarCharVector varCharVector = (VarCharVector)fieldVector;
            return new VarCharVectorReader(varCharVector);
        }
        if (fieldVector instanceof LargeVarCharVector) {
            LargeVarCharVector largeVarCharVector = (LargeVarCharVector)fieldVector;
            return new LargeVarCharVectorReader(largeVarCharVector);
        }
        if (fieldVector instanceof VarBinaryVector) {
            VarBinaryVector varBinaryVector = (VarBinaryVector)fieldVector;
            return new VarBinaryVectorReader(varBinaryVector);
        }
        if (fieldVector instanceof LargeVarBinaryVector) {
            LargeVarBinaryVector largeVarBinaryVector = (LargeVarBinaryVector)fieldVector;
            return new LargeVarBinaryVectorReader(largeVarBinaryVector);
        }
        if (fieldVector instanceof DurationVector) {
            DurationVector durationVector = (DurationVector)fieldVector;
            return new DurationVectorReader(durationVector);
        }
        if (fieldVector instanceof IntervalYearVector) {
            IntervalYearVector intervalYearVector = (IntervalYearVector)fieldVector;
            return new IntervalYearVectorReader(intervalYearVector);
        }
        if (fieldVector instanceof DateDayVector) {
            DateDayVector dateDayVector = (DateDayVector)fieldVector;
            return new DateDayVectorReader(dateDayVector, timeZoneId);
        }
        if (fieldVector instanceof TimeStampMicroTZVector) {
            TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)fieldVector;
            return new TimeStampMicroTZVectorReader(timeStampMicroTZVector);
        }
        if (fieldVector instanceof TimeStampMicroVector) {
            TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)fieldVector;
            return new TimeStampMicroVectorReader(timeStampMicroVector, timeZoneId);
        }
        if (fieldVector instanceof NullVector) {
            return NullVectorReader$.MODULE$;
        }
        throw new RuntimeException("Unsupported Vector Type: " + vector.getClass());
    }

    private ArrowVectorReader$() {
    }
}

