/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConversionRequestFluent<A extends ConversionRequestFluent<A>>
extends BaseFluent<A> {
    private String desiredAPIVersion;
    private List<Object> objects = new ArrayList<Object>();
    private String uid;
    private Map<String, Object> additionalProperties;

    public ConversionRequestFluent() {
    }

    public ConversionRequestFluent(ConversionRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConversionRequest instance) {
        ConversionRequest conversionRequest = instance = instance != null ? instance : new ConversionRequest();
        if (instance != null) {
            this.withDesiredAPIVersion(instance.getDesiredAPIVersion());
            this.withObjects(instance.getObjects());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDesiredAPIVersion() {
        return this.desiredAPIVersion;
    }

    public A withDesiredAPIVersion(String desiredAPIVersion) {
        this.desiredAPIVersion = desiredAPIVersion;
        return (A)((Object)this);
    }

    public boolean hasDesiredAPIVersion() {
        return this.desiredAPIVersion != null;
    }

    public A addToObjects(int index, Object item) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>();
        }
        this.objects.add(index, item);
        return (A)((Object)this);
    }

    public A setToObjects(int index, Object item) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>();
        }
        this.objects.set(index, item);
        return (A)((Object)this);
    }

    public A addToObjects(Object ... items) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>();
        }
        for (Object item : items) {
            this.objects.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToObjects(Collection<Object> items) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>();
        }
        for (Object item : items) {
            this.objects.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromObjects(Object ... items) {
        if (this.objects == null) {
            return (A)((Object)this);
        }
        for (Object item : items) {
            this.objects.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromObjects(Collection<Object> items) {
        if (this.objects == null) {
            return (A)((Object)this);
        }
        for (Object item : items) {
            this.objects.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public Object getObject(int index) {
        return this.objects.get(index);
    }

    public Object getFirstObject() {
        return this.objects.get(0);
    }

    public Object getLastObject() {
        return this.objects.get(this.objects.size() - 1);
    }

    public Object getMatchingObject(Predicate<Object> predicate) {
        for (Object item : this.objects) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingObject(Predicate<Object> predicate) {
        for (Object item : this.objects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withObjects(List<Object> objects) {
        if (objects != null) {
            this.objects = new ArrayList<Object>();
            for (Object item : objects) {
                this.addToObjects(item);
            }
        } else {
            this.objects = null;
        }
        return (A)((Object)this);
    }

    public A withObjects(Object ... objects) {
        if (this.objects != null) {
            this.objects.clear();
            this._visitables.remove((Object)"objects");
        }
        if (objects != null) {
            for (Object item : objects) {
                this.addToObjects(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasObjects() {
        return this.objects != null && !this.objects.isEmpty();
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConversionRequestFluent that = (ConversionRequestFluent)((Object)o);
        if (!Objects.equals(this.desiredAPIVersion, that.desiredAPIVersion)) {
            return false;
        }
        if (!Objects.equals(this.objects, that.objects)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.desiredAPIVersion, this.objects, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.desiredAPIVersion != null) {
            sb.append("desiredAPIVersion:");
            sb.append(this.desiredAPIVersion + ",");
        }
        if (this.objects != null && !this.objects.isEmpty()) {
            sb.append("objects:");
            sb.append(this.objects + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

