/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample$;
import org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params$;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scopt.OptionParser;
import scopt.Read$;

public final class PowerIterationClusteringExample$ {
    public static final PowerIterationClusteringExample$ MODULE$ = new PowerIterationClusteringExample$();

    public void main(String[] args) {
        PowerIterationClusteringExample.Params defaultParams = new PowerIterationClusteringExample.Params(PowerIterationClusteringExample$Params$.MODULE$.apply$default$1(), PowerIterationClusteringExample$Params$.MODULE$.apply$default$2(), PowerIterationClusteringExample$Params$.MODULE$.apply$default$3());
        OptionParser<PowerIterationClusteringExample.Params> parser = new OptionParser<PowerIterationClusteringExample.Params>(defaultParams){

            public static final /* synthetic */ PowerIterationClusteringExample.Params $anonfun$new$1(int x, PowerIterationClusteringExample.Params c) {
                return c.copy(x, c.copy$default$2(), c.copy$default$3());
            }

            public static final /* synthetic */ PowerIterationClusteringExample.Params $anonfun$new$2(int x, PowerIterationClusteringExample.Params c) {
                int x$1 = x;
                int x$2 = c.copy$default$1();
                int x$3 = c.copy$default$3();
                return c.copy(x$2, x$1, x$3);
            }

            public static final /* synthetic */ PowerIterationClusteringExample.Params $anonfun$new$3(int x, PowerIterationClusteringExample.Params c) {
                int x$4 = x;
                int x$5 = c.copy$default$1();
                int x$6 = c.copy$default$2();
                return c.copy(x$5, x$6, x$4);
            }
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PowerIterationClusteringExample: an example PIC app using concentric circles."}));
                this.opt('k', "k", Read$.MODULE$.intRead()).text("number of circles (clusters), default: " + defaultParams$1.k()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt('n', "n", Read$.MODULE$.intRead()).text("number of points in smallest circle, default: " + defaultParams$1.numPoints()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxIterations", Read$.MODULE$.intRead()).text("number of iterations, default: " + defaultParams$1.maxIterations()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.PowerIterationClusteringExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            PowerIterationClusteringExample.Params params = (PowerIterationClusteringExample.Params)some.value();
            this.run(params);
            return;
        }
        throw scala.sys.package$.MODULE$.exit(1);
    }

    public void run(PowerIterationClusteringExample.Params params) {
        SparkConf conf = new SparkConf().setMaster("local").setAppName("PowerIterationClustering with " + params);
        SparkContext sc = new SparkContext(conf);
        Configurator.setRootLevel((Level)Level.WARN);
        RDD<Tuple3<Object, Object, Object>> circlesRdd = this.generateCirclesRdd(sc, params.k(), params.numPoints());
        PowerIterationClusteringModel model = new PowerIterationClustering().setK(params.k()).setMaxIterations(params.maxIterations()).setInitializationMode("degree").run(circlesRdd);
        Map clusters = (Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.cluster())).transform((Function2 & Serializable)(x$2, v) -> PowerIterationClusteringExample$.$anonfun$run$2(BoxesRunTime.unboxToInt((Object)x$2), v));
        List assignments = (List)clusters.toList().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PowerIterationClusteringExample$.$anonfun$run$4(x0$1)), (Ordering)Ordering.Int$.MODULE$);
        String assignmentsStr = assignments.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int k = tuple2._1$mcI$sp();
                long[] v = (long[])tuple2._2();
                return k + " -> " + Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(v), (Ordering)Ordering.Long$.MODULE$)).mkString("[", ",", "]");
            }
            throw new MatchError((Object)tuple2);
        }).mkString(", ");
        String sizesStr = ((IterableOnceOps)assignments.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)PowerIterationClusteringExample$.$anonfun$run$6(x$4))).sorted((Ordering)Ordering.Int$.MODULE$)).mkString("(", ",", ")");
        Predef$.MODULE$.println((Object)("Cluster assignments: " + assignmentsStr + "\ncluster sizes: " + sizesStr));
        sc.stop();
    }

    public scala.collection.immutable.Seq<Tuple2<Object, Object>> generateCircle(double radius, int n) {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().tabulate(n, (Function1 & Serializable)i -> PowerIterationClusteringExample$.$anonfun$generateCircle$1(n, radius, BoxesRunTime.unboxToInt((Object)i)));
    }

    public RDD<Tuple3<Object, Object, Object>> generateCirclesRdd(SparkContext sc, int nCircles, int nPoints) {
        IndexedSeq points = (IndexedSeq)((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), nCircles).flatMap((Function1 & Serializable)i -> PowerIterationClusteringExample$.MODULE$.generateCircle(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)i) * nPoints))).zipWithIndex();
        RDD rdd = sc.parallelize((scala.collection.immutable.Seq)points, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD distancesRdd = rdd.cartesian(rdd, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Tuple2 tuple24 = (Tuple2)tuple22._1();
                    int i0 = tuple22._2$mcI$sp();
                    if (tuple24 != null) {
                        double x0 = tuple24._1$mcD$sp();
                        double y0 = tuple24._2$mcD$sp();
                        if (tuple23 != null) {
                            Tuple2 tuple25 = (Tuple2)tuple23._1();
                            int i1 = tuple23._2$mcI$sp();
                            if (tuple25 != null) {
                                double x1 = tuple25._1$mcD$sp();
                                double y1 = tuple25._2$mcD$sp();
                                if (i0 < i1) {
                                    return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)i0), (Object)BoxesRunTime.boxToLong((long)i1), (Object)BoxesRunTime.boxToDouble((double)MODULE$.gaussianSimilarity((Tuple2<Object, Object>)new Tuple2.mcDD.sp(x0, y0), (Tuple2<Object, Object>)new Tuple2.mcDD.sp(x1, y1)))));
                                }
                                return None$.MODULE$;
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return distancesRdd;
    }

    public double gaussianSimilarity(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
        double ssquares = (p1._1$mcD$sp() - p2._1$mcD$sp()) * (p1._1$mcD$sp() - p2._1$mcD$sp()) + (p1._2$mcD$sp() - p2._2$mcD$sp()) * (p1._2$mcD$sp() - p2._2$mcD$sp());
        return scala.math.package$.MODULE$.exp(-ssquares / 2.0);
    }

    public static final /* synthetic */ long[] $anonfun$run$2(int x$2, PowerIterationClustering.Assignment[] v) {
        return (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])v), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.id()), (ClassTag)ClassTag$.MODULE$.Long());
    }

    public static final /* synthetic */ int $anonfun$run$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long[] v = (long[])tuple2._2();
            return v.length;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$run$6(Tuple2 x$4) {
        return ((long[])x$4._2()).length;
    }

    public static final /* synthetic */ Tuple2 $anonfun$generateCircle$1(int n$1, double radius$1, int i) {
        double theta = Math.PI * 2 * (double)i / (double)n$1;
        return new Tuple2.mcDD.sp(radius$1 * scala.math.package$.MODULE$.cos(theta), radius$1 * scala.math.package$.MODULE$.sin(theta));
    }

    private PowerIterationClusteringExample$() {
    }
}

