/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.NettyUtils;
import org.sparkproject.guava.base.Throwables;

public class ChunkFetchRequestHandler
extends SimpleChannelInboundHandler<ChunkFetchRequest> {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(ChunkFetchRequestHandler.class);
    private final TransportClient client;
    private final StreamManager streamManager;
    private final long maxChunksBeingTransferred;
    private final boolean syncModeEnabled;

    public ChunkFetchRequestHandler(TransportClient client, StreamManager streamManager, Long maxChunksBeingTransferred, boolean syncModeEnabled) {
        this.client = client;
        this.streamManager = streamManager;
        this.maxChunksBeingTransferred = maxChunksBeingTransferred;
        this.syncModeEnabled = syncModeEnabled;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("Exception in connection from {}", cause, new MDC[]{MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(ctx.channel()))});
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ChunkFetchRequest msg) throws Exception {
        Channel channel = ctx.channel();
        this.processFetchRequest(channel, msg);
    }

    public void processFetchRequest(Channel channel, ChunkFetchRequest msg) throws Exception {
        ManagedBuffer buf;
        long chunksBeingTransferred;
        if (logger.isTraceEnabled()) {
            logger.trace("Received req from {} to fetch block {}", (Object)NettyUtils.getRemoteAddress(channel), (Object)msg.streamChunkId);
        }
        if (this.maxChunksBeingTransferred < Long.MAX_VALUE && (chunksBeingTransferred = this.streamManager.chunksBeingTransferred()) >= this.maxChunksBeingTransferred) {
            logger.warn("The number of chunks being transferred {} is above {}, close the connection.", new MDC[]{MDC.of((LogKey)LogKeys.NUM_CHUNKS$.MODULE$, (Object)chunksBeingTransferred), MDC.of((LogKey)LogKeys.MAX_NUM_CHUNKS$.MODULE$, (Object)this.maxChunksBeingTransferred)});
            channel.close();
            return;
        }
        try {
            this.streamManager.checkAuthorization(this.client, msg.streamChunkId.streamId());
            buf = this.streamManager.getChunk(msg.streamChunkId.streamId(), msg.streamChunkId.chunkIndex());
            if (buf == null) {
                throw new IllegalStateException("Chunk was not found");
            }
        }
        catch (Exception e) {
            logger.error("Error opening block {} for request from {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.STREAM_CHUNK_ID$.MODULE$, (Object)msg.streamChunkId), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(channel))});
            this.respond(channel, new ChunkFetchFailure(msg.streamChunkId, Throwables.getStackTraceAsString(e)));
            return;
        }
        this.streamManager.chunkBeingSent(msg.streamChunkId.streamId());
        this.respond(channel, new ChunkFetchSuccess(msg.streamChunkId, buf)).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.streamManager.chunkSent(msg.streamChunkId.streamId())));
    }

    private ChannelFuture respond(Channel channel, Encodable result) throws InterruptedException {
        SocketAddress remoteAddress = channel.remoteAddress();
        ChannelFuture channelFuture = this.syncModeEnabled ? channel.writeAndFlush((Object)result).await() : channel.writeAndFlush((Object)result);
        return channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                logger.trace("Sent result {} to client {}", (Object)result, (Object)remoteAddress);
            } else {
                logger.error("Error sending result {} to {}; closing connection", future.cause(), new MDC[]{MDC.of((LogKey)LogKeys.RESULT$.MODULE$, (Object)result), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)remoteAddress)});
                channel.close();
            }
        }));
    }
}

