/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDiagnostics is an enum
type OpcuaNodeIdServicesVariableDiagnostics int32

type IOpcuaNodeIdServicesVariableDiagnostics interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDiagnostics_DiagnosticsLevel_EnumStrings OpcuaNodeIdServicesVariableDiagnostics = 19724
)

var OpcuaNodeIdServicesVariableDiagnosticsValues []OpcuaNodeIdServicesVariableDiagnostics

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDiagnosticsValues = []OpcuaNodeIdServicesVariableDiagnostics{
		OpcuaNodeIdServicesVariableDiagnostics_DiagnosticsLevel_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableDiagnosticsByValue(value int32) (enum OpcuaNodeIdServicesVariableDiagnostics, ok bool) {
	switch value {
	case 19724:
		return OpcuaNodeIdServicesVariableDiagnostics_DiagnosticsLevel_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiagnosticsByName(value string) (enum OpcuaNodeIdServicesVariableDiagnostics, ok bool) {
	switch value {
	case "DiagnosticsLevel_EnumStrings":
		return OpcuaNodeIdServicesVariableDiagnostics_DiagnosticsLevel_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDiagnosticsKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDiagnosticsValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDiagnostics(structType any) OpcuaNodeIdServicesVariableDiagnostics {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDiagnostics {
		if sOpcuaNodeIdServicesVariableDiagnostics, ok := typ.(OpcuaNodeIdServicesVariableDiagnostics); ok {
			return sOpcuaNodeIdServicesVariableDiagnostics
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDiagnostics) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDiagnostics) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDiagnosticsParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDiagnostics, error) {
	return OpcuaNodeIdServicesVariableDiagnosticsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDiagnosticsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDiagnostics, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDiagnostics", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDiagnostics")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDiagnosticsByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDiagnostics")
		return OpcuaNodeIdServicesVariableDiagnostics(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDiagnostics) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDiagnostics) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDiagnostics", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableDiagnostics) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDiagnostics) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDiagnostics_DiagnosticsLevel_EnumStrings:
		return "DiagnosticsLevel_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDiagnostics) String() string {
	return e.PLC4XEnumName()
}
