/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvaluatedMixinReferenceCall {
    private final MixinReference reference;
    private final List<Expression> positionalParameters = new ArrayList<Expression>();
    private final Map<String, Expression> namedParameters = new HashMap<String, Expression>();

    public EvaluatedMixinReferenceCall(MixinReference reference, ExpressionEvaluator evaluator) {
        this.reference = reference;
        for (Expression expression : reference.getPositionalParameters()) {
            Expression value = evaluator.evaluate(expression);
            this.addPositional(expression, value);
        }
        for (Map.Entry entry : reference.getNamedParameters().entrySet()) {
            this.namedParameters.put((String)entry.getKey(), evaluator.evaluate((Expression)entry.getValue()));
        }
    }

    private void addPositional(Expression original, Expression evaluated) {
        if (this.isEllipsisVariable(original)) {
            this.positionalParameters.addAll(this.expandList(evaluated));
        } else {
            this.positionalParameters.add(evaluated);
        }
    }

    private List<Expression> expandList(Expression value) {
        if (value.getType() != ASTCssNodeType.LIST_EXPRESSION) {
            return Arrays.asList(value);
        }
        ListExpression list = (ListExpression)value;
        return list.getExpressions();
    }

    private boolean isEllipsisVariable(Expression expression) {
        if (expression.getType() != ASTCssNodeType.VARIABLE) {
            return false;
        }
        Variable variable = (Variable)expression;
        return variable.isCollector();
    }

    public MixinReference getReference() {
        return this.reference;
    }

    public List<Expression> getPositionalParameters() {
        return this.positionalParameters;
    }

    public Expression getPositionalParameter(int parameterNumber) {
        return this.getPositionalParameters().get(parameterNumber);
    }

    public boolean hasPositionalParameter(int parameterNumber) {
        return this.getPositionalParameters().size() > parameterNumber;
    }

    public int getNumberOfDeclaredParameters() {
        return this.positionalParameters.size() + this.namedParameters.size();
    }

    public boolean hasNamedParameter(Variable variable) {
        return this.namedParameters.containsKey(variable.getName());
    }

    public Expression getNamedParameter(Variable variable) {
        return this.namedParameters.get(variable.getName());
    }
}

