/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.LogFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public final class TypeSystemDescriptionFactory {
    private static final Object SCAN_LOCK = new Object();
    private static String[] typeDescriptorLocations;

    private TypeSystemDescriptionFactory() {
    }

    public static TypeSystemDescription createTypeSystemDescription(String ... descriptorNames) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorName : descriptorNames) {
            Import_impl imp = new Import_impl();
            imp.setName(descriptorName);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescriptionFromPath(String ... descriptorURIs) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorURI : descriptorURIs) {
            Import_impl imp = new Import_impl();
            imp.setLocation(descriptorURI);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescription() throws ResourceInitializationException {
        ArrayList<TypeSystemDescription> tsdList = new ArrayList<TypeSystemDescription>();
        for (String location : TypeSystemDescriptionFactory.scanTypeDescriptors()) {
            try {
                XMLInputSource xmlInputType1 = new XMLInputSource(location);
                tsdList.add(UIMAFramework.getXMLParser().parseTypeSystemDescription(xmlInputType1));
                LogFactory.getLog(TypeSystemDescription.class).debug((Object)("Detected type system at [" + location + "]"));
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (InvalidXMLException e) {
                LogFactory.getLog(TypeSystemDescription.class).warn((Object)("[" + location + "] is not a type file. Ignoring."), (Throwable)e);
            }
        }
        ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
        return CasCreationUtils.mergeTypeSystems(tsdList, (ResourceManager)resMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanTypeDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            if (typeDescriptorLocations == null) {
                typeDescriptorLocations = MetaDataUtil.scanDescriptors(MetaDataType.TYPE_SYSTEM);
            }
            return typeDescriptorLocations;
        }
    }

    public static void forceTypeDescriptorsScan() {
        typeDescriptorLocations = null;
    }
}

