/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.apache.sis.geometry.CurveExtremum;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.WraparoundInEnvelope;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class Shapes2D
extends Static {
    private Shapes2D() {
    }

    public static Point2D intersectionPoint(Line2D line2D, Line2D line2D2) {
        return ShapeUtilities.intersectionPoint(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), line2D2.getX1(), line2D2.getY1(), line2D2.getX2(), line2D2.getY2());
    }

    public static Point2D nearestColinearPoint(Line2D line2D, Point2D point2D) {
        return ShapeUtilities.nearestColinearPoint(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), point2D.getX(), point2D.getY());
    }

    public static Point2D colinearPoint(Line2D line2D, Point2D point2D, double d) {
        return ShapeUtilities.colinearPoint(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), point2D.getX(), point2D.getY(), d);
    }

    public static Ellipse2D circle(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        Point2D.Double double_ = ShapeUtilities.circleCentre(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
        double d = double_.distance(point2D2);
        return new Ellipse2D.Double(double_.x - d, double_.y - d, 2.0 * d, 2.0 * d);
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform2D);
        if (mathTransform2D instanceof AffineTransform) {
            return AffineTransforms2D.transform((AffineTransform)mathTransform2D, rectangle2D, rectangle2D2);
        }
        return Shapes2D.transform(mathTransform2D, rectangle2D, rectangle2D2, new double[2]);
    }

    private static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double[] dArray) throws TransformException {
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        WraparoundInEnvelope.Controller controller = new WraparoundInEnvelope.Controller((MathTransform)mathTransform2D);
        do {
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            Matrix matrix = null;
            Matrix matrix2 = null;
            Matrix matrix3 = null;
            boolean bl = true;
            CurveExtremum curveExtremum = new CurveExtremum();
            for (int i = 0; i <= 8; ++i) {
                double d13;
                double d14;
                switch (i) {
                    case 0: 
                    case 6: 
                    case 7: {
                        d14 = rectangle2D.getMinX();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: {
                        d14 = rectangle2D.getCenterX();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        d14 = rectangle2D.getMaxX();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: {
                        d13 = rectangle2D.getMinY();
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        d13 = rectangle2D.getCenterY();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        d13 = rectangle2D.getMaxY();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                dArray[0] = d14;
                dArray[1] = d13;
                try {
                    matrix2 = matrix3;
                    matrix3 = Envelopes.derivativeAndTransform(controller.transform, dArray, dArray, 0, bl && i != 8);
                }
                catch (TransformException transformException) {
                    if (!bl) {
                        throw transformException;
                    }
                    bl = false;
                    matrix3 = null;
                    dArray[0] = d14;
                    dArray[1] = d13;
                    controller.transform.transform(dArray, 0, dArray, 0, 1);
                    Envelopes.recoverableException(Shapes2D.class, transformException);
                }
                double d15 = dArray[0];
                double d16 = dArray[1];
                if (d15 < d) {
                    d = d15;
                }
                if (d15 > d3) {
                    d3 = d15;
                }
                if (d16 < d2) {
                    d2 = d16;
                }
                if (d16 > d4) {
                    d4 = d16;
                }
                switch (i) {
                    case 0: {
                        d7 = d14;
                        d5 = d15;
                        d8 = d13;
                        d6 = d16;
                        matrix = matrix3;
                        break;
                    }
                    case 8: {
                        d14 = d7;
                        d15 = d5;
                        d13 = d8;
                        d16 = d6;
                        matrix3 = matrix;
                    }
                }
                if (matrix2 != null && matrix3 != null) {
                    double d17;
                    double d18;
                    double d19;
                    double d20;
                    int n;
                    switch (i) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            assert (d13 == d12);
                            n = 0;
                            d20 = d11;
                            d19 = d14;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 7: 
                        case 8: {
                            assert (d14 == d11);
                            n = 1;
                            d20 = d12;
                            d19 = d13;
                            break;
                        }
                        default: {
                            throw new AssertionError(i);
                        }
                    }
                    if (d20 < d19) {
                        d18 = d20;
                        d17 = d19;
                    } else {
                        d18 = d19;
                        d17 = d20;
                    }
                    int n2 = 0;
                    do {
                        curveExtremum.resolve(d20, n2 == 0 ? d9 : d10, matrix2.getElement(n2, n), d19, n2 == 0 ? d15 : d16, matrix3.getElement(n2, n));
                        boolean bl2 = false;
                        do {
                            double d21;
                            double d22;
                            double d23 = d22 = bl2 ? curveExtremum.ex2 : curveExtremum.ex1;
                            if (!(d22 > d18) || !(d22 < d17)) continue;
                            double d24 = d21 = bl2 ? curveExtremum.ey2 : curveExtremum.ey1;
                            if (!(n2 == 0 ? d21 < d || d21 > d3 : d21 < d2 || d21 > d4)) continue;
                            double d25 = dArray[0];
                            double d26 = dArray[1];
                            if (n == 0) {
                                dArray[0] = d22;
                                dArray[1] = d12;
                            } else {
                                dArray[0] = d11;
                                dArray[1] = d22;
                            }
                            controller.transform.transform(dArray, 0, dArray, 0, 1);
                            double d27 = dArray[0];
                            double d28 = dArray[1];
                            if (d27 < d) {
                                d = d27;
                            }
                            if (d27 > d3) {
                                d3 = d27;
                            }
                            if (d28 < d2) {
                                d2 = d28;
                            }
                            if (d28 > d4) {
                                d4 = d28;
                            }
                            dArray[0] = d25;
                            dArray[1] = d26;
                        } while (bl2 = !bl2);
                    } while (++n2 == 1);
                }
                d11 = d14;
                d9 = d15;
                d12 = d13;
                d10 = d16;
                matrix2 = matrix3;
            }
        } while (controller.translate());
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
        } else {
            rectangle2D2 = new IntervalRectangle(d, d2, d3, d4);
        }
        return rectangle2D2;
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        Point2D point2D;
        CoordinateSystem coordinateSystem;
        CoordinateSystem coordinateSystem2;
        ArgumentChecks.ensureNonNull("operation", coordinateOperation);
        if (rectangle2D == null) {
            return null;
        }
        MathTransform2D mathTransform2D = MathTransforms.bidimensional(coordinateOperation.getMathTransform());
        double[] dArray = new double[2];
        rectangle2D2 = Shapes2D.transform(mathTransform2D, rectangle2D, rectangle2D2, dArray);
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem()) != null && coordinateSystem2.getDimension() == 2) {
            coordinateSystem = coordinateSystem2.getAxis(0);
            double d3 = rectangle2D.getMinX();
            double d4 = rectangle2D.getMaxX();
            point2D = null;
            for (n3 = 0; n3 < 4; ++n3) {
                double d5;
                if (n3 == 2) {
                    coordinateSystem = coordinateSystem2.getAxis(1);
                    d3 = rectangle2D.getMinY();
                    d4 = rectangle2D.getMaxY();
                }
                double d6 = d5 = (n3 & 1) == 0 ? coordinateSystem.getMinimumValue() : coordinateSystem.getMaximumValue();
                if (!(d5 > d3) || !(d5 < d4)) continue;
                if (point2D == null) {
                    point2D = new Point2D.Double();
                }
                if ((n3 & 2) == 0) {
                    ((Point2D.Double)point2D).x = d5;
                    ((Point2D.Double)point2D).y = rectangle2D.getCenterY();
                } else {
                    ((Point2D.Double)point2D).x = rectangle2D.getCenterX();
                    ((Point2D.Double)point2D).y = d5;
                }
                rectangle2D2.add(mathTransform2D.transform(point2D, point2D));
            }
        }
        if ((coordinateSystem2 = coordinateOperation.getTargetCRS()) == null) {
            return rectangle2D2;
        }
        coordinateSystem = coordinateSystem2.getCoordinateSystem();
        if (coordinateSystem == null || coordinateSystem.getDimension() != 2) {
            return rectangle2D2;
        }
        MathTransform2D mathTransform2D2 = null;
        TransformException transformException = null;
        Point2D point2D2 = null;
        Point2D point2D3 = null;
        point2D = null;
        n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            double d7;
            n = n2 >>> 1;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
            if (coordinateSystemAxis == null) continue;
            double d8 = d7 = (n2 & 1) == 0 ? coordinateSystemAxis.getMinimumValue() : coordinateSystemAxis.getMaximumValue();
            if (!Double.isFinite(d7)) continue;
            if (mathTransform2D2 == null) {
                try {
                    mathTransform2D2 = mathTransform2D.inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    Envelopes.recoverableException(Shapes2D.class, (TransformException)((Object)noninvertibleTransformException));
                    return rectangle2D2;
                }
                point2D3 = new Point2D.Double();
            }
            switch (n) {
                case 0: {
                    point2D3.setLocation(d7, dArray[1]);
                    break;
                }
                case 1: {
                    point2D3.setLocation(dArray[0], d7);
                    break;
                }
                default: {
                    throw new AssertionError(n2);
                }
            }
            try {
                point2D2 = mathTransform2D2.transform(point2D3, point2D2);
                if (CoordinateOperations.isWrapAround(coordinateSystemAxis)) {
                    point2D = mathTransform2D.transform(point2D2, point2D);
                    double d9 = Math.abs((n == 0 ? point2D.getX() : point2D.getY()) - d7);
                    if (!(d9 < 0.25 * (coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue()))) continue;
                }
                if (!rectangle2D.contains(point2D2)) continue;
                rectangle2D2.add(point2D3);
                n3 |= 1 << n2;
                continue;
            }
            catch (TransformException transformException2) {
                if (transformException == null) {
                    transformException = transformException2;
                    continue;
                }
                transformException.addSuppressed((Throwable)transformException2);
            }
        }
        if (n3 != 0) {
            n2 = (n3 & 1) << 3 | (n3 & 4) >>> 1 | (n3 & 2) << 6 | (n3 & 8) << 2;
            n2 |= n2 >>> 1;
            if (((n2 &= ~(n3 | n3 << 4)) & 0x33333333) != 0 && !CoordinateOperations.isWrapAround(coordinateSystem.getAxis(0))) {
                n2 &= 0xCCCCCCCC;
            }
            if ((n2 & 0xCCCCCCCC) != 0 && !CoordinateOperations.isWrapAround(coordinateSystem.getAxis(1))) {
                n2 &= 0x33333333;
            }
            while (n2 != 0) {
                n = Integer.numberOfTrailingZeros(n2);
                int n4 = 1 << n;
                n2 &= ~n4;
                int n5 = n >>> 1 & 1;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n5);
                CoordinateSystemAxis coordinateSystemAxis2 = coordinateSystem.getAxis(n5 ^ 1);
                d2 = (n & 1) == 0 ? coordinateSystemAxis.getMinimumValue() : coordinateSystemAxis.getMaximumValue();
                double d10 = d = (n & 4) == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue();
                if (n5 == 0) {
                    point2D3.setLocation(d2, d);
                } else {
                    point2D3.setLocation(d, d2);
                }
                try {
                    if (!rectangle2D.contains(point2D2 = mathTransform2D2.transform(point2D3, point2D2))) continue;
                    rectangle2D2.add(point2D3);
                }
                catch (TransformException transformException3) {
                    if (transformException == null) {
                        transformException = transformException3;
                        continue;
                    }
                    transformException.addSuppressed((Throwable)transformException3);
                }
            }
        }
        Set<Integer> set = coordinateOperation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)coordinateOperation).getWrapAroundChanges() : CoordinateOperations.wrapAroundChanges(coordinateReferenceSystem, coordinateSystem);
        for (int n6 : set) {
            double d11;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n6);
            double d12 = coordinateSystemAxis.getMinimumValue();
            d2 = coordinateSystemAxis.getMaximumValue();
            if (n6 == 0) {
                d = rectangle2D2.getMinX();
                d11 = rectangle2D2.getMaxX();
            } else {
                d = rectangle2D2.getMinY();
                d11 = rectangle2D2.getMaxY();
            }
            if (!(d < d12) && !(d11 > d2)) continue;
            double d13 = d2 - d12;
            if (n6 == 0) {
                rectangle2D2.setRect(d12, rectangle2D2.getY(), d13, rectangle2D2.getHeight());
                continue;
            }
            rectangle2D2.setRect(rectangle2D2.getX(), d12, rectangle2D2.getWidth(), d13);
        }
        if (transformException != null) {
            Envelopes.recoverableException(Shapes2D.class, transformException);
        }
        return rectangle2D2;
    }
}

