/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.TreeNode;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

final class TreeNodeChildren
extends AbstractCollection<TreeTable.Node> {
    private final TreeNode parent;
    final Object metadata;
    final PropertyAccessor accessor;
    private final TreeNode.Element[] children;
    final int titleProperty;
    int modCount;

    TreeNodeChildren(TreeNode treeNode, Object object, PropertyAccessor propertyAccessor) {
        this.parent = treeNode;
        this.metadata = object;
        this.accessor = propertyAccessor;
        this.children = new TreeNode.Element[propertyAccessor.count()];
        if (treeNode.table.valuePolicy == ValueExistencePolicy.COMPACT) {
            int n;
            Class<?> clazz;
            Class<?> clazz2;
            TitleProperty titleProperty = propertyAccessor.implementation.getAnnotation(TitleProperty.class);
            if (titleProperty == null && (clazz2 = treeNode.table.standard.getImplementation(propertyAccessor.type)) != null) {
                titleProperty = clazz2.getAnnotation(TitleProperty.class);
            }
            if (titleProperty != null && (clazz = propertyAccessor.type(n = propertyAccessor.indexOf(titleProperty.name(), false), TypeValuePolicy.ELEMENT_TYPE)) != null && !treeNode.isMetadata(clazz) && clazz == propertyAccessor.type(n, TypeValuePolicy.PROPERTY_TYPE)) {
                this.titleProperty = n;
                return;
            }
        }
        this.titleProperty = -1;
    }

    final Class<?> getParentType() {
        return this.titleProperty >= 0 ? this.accessor.type(this.titleProperty, TypeValuePolicy.ELEMENT_TYPE) : null;
    }

    final Object getParentTitle() {
        return this.titleProperty >= 0 ? this.valueAt(this.titleProperty) : null;
    }

    final boolean setParentTitle(Object object) {
        if (this.titleProperty < 0) {
            return false;
        }
        this.accessor.set(this.titleProperty, this.metadata, object, 0);
        return true;
    }

    final void clearAt(int n) {
        this.accessor.set(n, this.metadata, null, 0);
    }

    final Object valueAt(int n) {
        return this.accessor.get(n, this.metadata);
    }

    final boolean isCollectionOrMap(int n) {
        return this.accessor.isCollectionOrMap(n);
    }

    final boolean isSkipped(Object object) {
        return this.parent.table.valuePolicy.isSkipped(object);
    }

    final TreeNode.Element childAt(int n, int n2) {
        TreeNode.Element element = this.children[n];
        if (n2 >= 0) {
            if (element == null || ((TreeNode.CollectionElement)element).indexInList != n2) {
                element = new TreeNode.CollectionElement(this.parent, this.metadata, this.accessor, n, n2);
            }
        } else if (element == null) {
            element = new TreeNode.Element(this.parent, this.metadata, this.accessor, n);
        }
        this.children[n] = element;
        return element;
    }

    final int childCount() {
        return this.children.length;
    }

    @Override
    public int size() {
        int n = this.accessor.count(this.metadata, this.parent.table.valuePolicy, 2);
        if (this.titleProperty >= 0 && !this.isSkipped(this.valueAt(this.titleProperty))) {
            --n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        if (this.titleProperty >= 0) {
            return this.size() == 0;
        }
        return this.accessor.count(this.metadata, this.parent.table.valuePolicy, 0) == 0;
    }

    @Override
    public void clear() {
        int n = this.childCount();
        while (--n >= 0) {
            this.clearAt(n);
        }
    }

    @Override
    public Iterator<TreeTable.Node> iterator() {
        return new Iter();
    }

    @Override
    public boolean add(TreeTable.Node node) throws IllegalStateException {
        String string = node.getValue(TableColumn.IDENTIFIER);
        if (string == null) {
            throw new IllegalArgumentException(Errors.format((short)90, TableColumn.IDENTIFIER.getHeader()));
        }
        return this.add(this.accessor.indexOf(string, true), node.getValue(TableColumn.VALUE));
    }

    final boolean add(int n, Object object) throws IllegalStateException {
        if (ValueExistencePolicy.isNullOrEmpty(object)) {
            return false;
        }
        Boolean bl = (Boolean)this.accessor.set(n, this.metadata, object, 2);
        if (bl == null) {
            throw new IllegalStateException(Errors.format((short)164, this.accessor.name(n, KeyNamePolicy.UML_IDENTIFIER)));
        }
        if (bl.booleanValue()) {
            ++this.modCount;
        }
        return bl;
    }

    @Override
    public String toString() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder(512);
        this.parent.appendStringTo(stringBuilder);
        stringBuilder.append(string);
        for (TreeTable.Node node : this) {
            stringBuilder.append("  ");
            ((TreeNode)node).appendStringTo(stringBuilder);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private final class Iter
    implements Iterator<TreeTable.Node> {
        private int nextInAccessor;
        private int previousInAccessor = -1;
        private boolean isNextVerified;
        private Object nextValue;
        private Iterator<?> subIterator;
        private int subIndex = -1;
        private int modCountCheck;

        Iter() {
            this.modCountCheck = TreeNodeChildren.this.modCount;
        }

        final void checkConcurrentModification() {
            if (this.modCountCheck != TreeNodeChildren.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkConcurrentModification();
            if (this.isNextVerified) {
                return true;
            }
            if (this.subIterator != null) {
                if (this.subIterator.hasNext()) {
                    this.nextValue = this.subIterator.next();
                    ++this.subIndex;
                    this.isNextVerified = true;
                    return true;
                }
                this.subIterator = null;
                this.subIndex = -1;
                ++this.nextInAccessor;
            }
            int n = TreeNodeChildren.this.childCount();
            while (this.nextInAccessor < n) {
                if (this.nextInAccessor != TreeNodeChildren.this.titleProperty) {
                    this.nextValue = TreeNodeChildren.this.valueAt(this.nextInAccessor);
                    if (!TreeNodeChildren.this.isSkipped(this.nextValue)) {
                        if (TreeNodeChildren.this.isCollectionOrMap(this.nextInAccessor)) {
                            this.subIterator = this.nextValue == null ? Collections.emptyIterator() : (this.nextValue instanceof Iterable ? ((Iterable)this.nextValue).iterator() : ((Map)this.nextValue).entrySet().iterator());
                            this.subIndex = 0;
                            this.nextValue = this.subIterator.hasNext() ? this.subIterator.next() : null;
                        }
                        this.isNextVerified = true;
                        return true;
                    }
                }
                ++this.nextInAccessor;
            }
            return false;
        }

        @Override
        public TreeTable.Node next() {
            if (this.hasNext()) {
                TreeNode.Element element = TreeNodeChildren.this.childAt(this.nextInAccessor, this.subIndex);
                element.cachedValue = this.nextValue;
                this.previousInAccessor = this.nextInAccessor++;
                if (this.subIterator == null) {
                    // empty if block
                }
                this.isNextVerified = false;
                return element.decorator == null ? element : element.decorator.apply(element);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.previousInAccessor < 0) {
                throw new IllegalStateException();
            }
            this.checkConcurrentModification();
            if (this.subIterator != null) {
                this.subIterator.remove();
            } else {
                TreeNodeChildren.this.clearAt(this.previousInAccessor);
                this.previousInAccessor = -1;
            }
            this.modCountCheck = ++TreeNodeChildren.this.modCount;
        }
    }
}

