/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.Emptiable;
import org.opengis.util.CodeList;

final class Pruner
extends MetadataVisitor<Boolean> {
    private static final ThreadLocal<Pruner> VISITORS = ThreadLocal.withInitial(Pruner::new);
    private boolean prune;
    private boolean isEmpty;

    private Pruner() {
    }

    @Override
    final ThreadLocal<Pruner> creator() {
        return VISITORS;
    }

    static boolean isEmpty(AbstractMetadata abstractMetadata, boolean bl) {
        Pruner pruner = VISITORS.get();
        boolean bl2 = pruner.prune;
        pruner.prune = bl;
        Boolean bl3 = (Boolean)pruner.walk(abstractMetadata.getStandard(), abstractMetadata.getInterface(), abstractMetadata, false);
        pruner.prune = bl2;
        return bl3 != null && bl3 != false;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor propertyAccessor) {
        this.isEmpty = true;
        return MetadataVisitor.Filter.NON_EMPTY;
    }

    @Override
    Object visit(Class<?> clazz, Object object) {
        boolean bl = this.isEmpty;
        boolean bl2 = true;
        Collection<?> collection = CollectionsExt.toCollection(object);
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!ValueExistencePolicy.isNullOrEmpty(obj)) {
                Object object2;
                boolean bl3 = false;
                if (obj instanceof AbstractMetadata) {
                    object2 = (AbstractMetadata)obj;
                    if (this.prune) {
                        ((AbstractMetadata)object2).prune();
                    }
                    bl3 = ((AbstractMetadata)object2).isEmpty();
                } else if (!this.prune && obj instanceof Emptiable) {
                    bl3 = ((Emptiable)obj).isEmpty();
                } else if (!(obj instanceof Enum) && !(obj instanceof CodeList)) {
                    object2 = MetadataStandard.forClass(obj.getClass());
                    if (object2 != null) {
                        Boolean bl4 = (Boolean)this.walk((MetadataStandard)object2, clazz, obj, false);
                        if (bl4 != null && !(bl3 = bl4.booleanValue()) && obj instanceof Emptiable) {
                            bl3 = ((Emptiable)obj).isEmpty();
                        }
                    } else if (obj instanceof Number) {
                        bl3 = Double.isNaN(((Number)obj).doubleValue());
                    } else if (obj instanceof Boolean) {
                        boolean bl5 = bl3 = (Boolean)obj == false;
                    }
                }
                if (!bl3) {
                    if (!this.prune) {
                        this.isEmpty = false;
                        return SKIP_SIBLINGS;
                    }
                    bl2 = false;
                    continue;
                }
            }
            if (!this.prune || collection != object) continue;
            iterator.remove();
        }
        this.isEmpty = bl & bl2;
        return bl2 & this.prune ? null : object;
    }

    @Override
    Boolean result() {
        return this.isEmpty;
    }
}

