/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AWS4Signer
extends AbstractAWSSigner
implements ServiceAwareSigner,
RegionAwareSigner,
Presigner {
    protected static final String ALGORITHM = "AWS4-HMAC-SHA256";
    protected static final String TERMINATOR = "aws4_request";
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd").withZoneUTC();
    private static final DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmmss'Z'").withZoneUTC();
    private static final long MAX_EXPIRATION_TIME_IN_SECONDS = 604800L;
    protected String serviceName;
    protected String regionName;
    protected Date overriddenDate;
    protected boolean doubleUrlEncode;
    protected static final Log log = LogFactory.getLog(AWS4Signer.class);

    public AWS4Signer() {
        this(true);
    }

    public AWS4Signer(boolean doubleUrlEncoding) {
        this.doubleUrlEncode = doubleUrlEncoding;
    }

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) {
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        this.addHostHeader(request);
        long dateMilli = this.getDateFromRequest(request);
        String dateStamp = this.getDateStamp(dateMilli);
        String scope = this.getScope(request, dateStamp);
        String contentSha256 = this.calculateContentHash(request);
        String timeStamp = this.getTimeStamp(dateMilli);
        request.addHeader("X-Amz-Date", timeStamp);
        if (request.getHeaders().get("x-amz-content-sha256") != null && request.getHeaders().get("x-amz-content-sha256").equals("required")) {
            request.addHeader("x-amz-content-sha256", contentSha256);
        }
        String signingCredentials = sanitizedCredentials.getAWSAccessKeyId() + "/" + scope;
        HeaderSigningResult headerSigningResult = this.computeSignature(request, dateStamp, timeStamp, ALGORITHM, contentSha256, sanitizedCredentials);
        String credentialsAuthorizationHeader = "Credential=" + signingCredentials;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + this.getSignedHeadersString(request);
        String signatureAuthorizationHeader = "Signature=" + BinaryUtils.toHex(headerSigningResult.getSignature());
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        request.addHeader("Authorization", authorizationHeader);
        this.processRequestPayload(request, headerSigningResult);
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addHeader("x-amz-security-token", credentials.getSessionToken());
    }

    protected String extractRegionName(URI endpoint) {
        if (this.regionName != null) {
            return this.regionName;
        }
        return AwsHostNameUtils.parseRegionName(endpoint.getHost(), this.serviceName);
    }

    protected String extractServiceName(URI endpoint) {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        return AwsHostNameUtils.parseServiceName(endpoint);
    }

    void overrideDate(Date overriddenDate) {
        this.overriddenDate = overriddenDate;
    }

    protected String getCanonicalizedHeaderString(Request<?> request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            String key = header.toLowerCase().replaceAll("\\s+", " ");
            String value = request.getHeaders().get(header);
            buffer.append(key).append(":");
            if (value != null) {
                buffer.append(value.replaceAll("\\s+", " "));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected String getSignedHeadersString(Request<?> request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(header.toLowerCase());
        }
        return buffer.toString();
    }

    protected String getCanonicalRequest(Request<?> request, String contentSha256) {
        String path = HttpUtils.appendUri(request.getEndpoint().getPath(), request.getResourcePath());
        String canonicalRequest = request.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(path, this.doubleUrlEncode) + "\n" + this.getCanonicalizedQueryString(request) + "\n" + this.getCanonicalizedHeaderString(request) + "\n" + this.getSignedHeadersString(request) + "\n" + contentSha256;
        log.debug((Object)("AWS4 Canonical Request: '\"" + canonicalRequest + "\""));
        return canonicalRequest;
    }

    protected String getStringToSign(String algorithm, String dateTime, String scope, String canonicalRequest) {
        String stringToSign = algorithm + "\n" + dateTime + "\n" + scope + "\n" + BinaryUtils.toHex(this.hash(canonicalRequest));
        log.debug((Object)("AWS4 String to Sign: '\"" + stringToSign + "\""));
        return stringToSign;
    }

    protected final HeaderSigningResult computeSignature(Request<?> request, String dateStamp, String timeStamp, String algorithm, String contentSha256, AWSCredentials sanitizedCredentials) {
        String regionName = this.extractRegionName(request.getEndpoint());
        String serviceName = this.extractServiceName(request.getEndpoint());
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + TERMINATOR;
        String stringToSign = this.getStringToSign(algorithm, timeStamp, scope, this.getCanonicalRequest(request, contentSha256));
        byte[] kSecret = ("AWS4" + sanitizedCredentials.getAWSSecretKey()).getBytes();
        byte[] kDate = this.sign(dateStamp, kSecret, SigningAlgorithm.HmacSHA256);
        byte[] kRegion = this.sign(regionName, kDate, SigningAlgorithm.HmacSHA256);
        byte[] kService = this.sign(serviceName, kRegion, SigningAlgorithm.HmacSHA256);
        byte[] kSigning = this.sign(TERMINATOR, kService, SigningAlgorithm.HmacSHA256);
        byte[] signature = this.sign(stringToSign.getBytes(), kSigning, SigningAlgorithm.HmacSHA256);
        return new HeaderSigningResult(timeStamp, scope, kSigning, signature);
    }

    protected final String getTimeStamp(long dateMilli) {
        return timeFormatter.print(dateMilli);
    }

    protected final String getDateStamp(long dateMilli) {
        return dateFormatter.print(dateMilli);
    }

    protected final long getDateFromRequest(Request<?> request) {
        int timeOffset = request.getTimeOffset();
        Date date = this.getSignatureDate(timeOffset);
        if (this.overriddenDate != null) {
            date = this.overriddenDate;
        }
        return date.getTime();
    }

    protected void addHostHeader(Request<?> request) {
        String hostHeader = request.getEndpoint().getHost();
        if (HttpUtils.isUsingNonDefaultPort(request.getEndpoint())) {
            hostHeader = hostHeader + ":" + request.getEndpoint().getPort();
        }
        request.addHeader("Host", hostHeader);
    }

    protected String getScope(Request<?> request, String dateStamp) {
        String regionName = this.extractRegionName(request.getEndpoint());
        String serviceName = this.extractServiceName(request.getEndpoint());
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + TERMINATOR;
        return scope;
    }

    protected String calculateContentHash(Request<?> request) {
        InputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        AmazonWebServiceRequest req = request.getOriginalRequest();
        payloadStream.mark(req == null ? -1 : req.getReadLimit());
        String contentSha256 = BinaryUtils.toHex(this.hash(payloadStream));
        try {
            payloadStream.reset();
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to reset stream after calculating AWS4 signature", e);
        }
        return contentSha256;
    }

    protected void processRequestPayload(Request<?> request, HeaderSigningResult headerSigningResult) {
    }

    @Override
    public void presignRequest(Request<?> request, AWSCredentials credentials, Date expiration) {
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        long expirationInSeconds = 604800L;
        if (expiration != null) {
            expirationInSeconds = (expiration.getTime() - System.currentTimeMillis()) / 1000L;
        }
        if (expirationInSeconds > 604800L) {
            throw new AmazonClientException("Requests that are pre-signed by SigV4 algorithm are valid for at most 7 days. The expiration date set on the current request [" + this.getTimeStamp(expiration.getTime()) + "] has exceeded this limit.");
        }
        this.addHostHeader(request);
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            request.addParameter("X-Amz-Security-Token", ((AWSSessionCredentials)sanitizedCredentials).getSessionToken());
        }
        long dateMilli = this.getDateFromRequest(request);
        String dateStamp = this.getDateStamp(dateMilli);
        String scope = this.getScope(request, dateStamp);
        String signingCredentials = sanitizedCredentials.getAWSAccessKeyId() + "/" + scope;
        long now = System.currentTimeMillis();
        String timeStamp = this.getTimeStamp(now);
        request.addParameter("X-Amz-Algorithm", ALGORITHM);
        request.addParameter("X-Amz-Date", timeStamp);
        request.addParameter("X-Amz-SignedHeaders", this.getSignedHeadersString(request));
        request.addParameter("X-Amz-Expires", Long.toString(expirationInSeconds));
        request.addParameter("X-Amz-Credential", signingCredentials);
        String contentSha256 = this.calculateContentHashPresign(request);
        HeaderSigningResult headerSigningResult = this.computeSignature(request, dateStamp, timeStamp, ALGORITHM, contentSha256, sanitizedCredentials);
        request.addParameter("X-Amz-Signature", BinaryUtils.toHex(headerSigningResult.getSignature()));
    }

    protected String calculateContentHashPresign(Request<?> request) {
        return this.calculateContentHash(request);
    }

    protected static class HeaderSigningResult {
        private String dateTime;
        private String scope;
        private byte[] kSigning;
        private byte[] signature;

        public HeaderSigningResult(String dateTime, String scope, byte[] kSigning, byte[] signature) {
            this.dateTime = dateTime;
            this.scope = scope;
            this.kSigning = kSigning;
            this.signature = signature;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public String getScope() {
            return this.scope;
        }

        public byte[] getKSigning() {
            byte[] kSigningCopy = new byte[this.kSigning.length];
            System.arraycopy(this.kSigning, 0, kSigningCopy, 0, this.kSigning.length);
            return kSigningCopy;
        }

        public byte[] getSignature() {
            byte[] signatureCopy = new byte[this.signature.length];
            System.arraycopy(this.signature, 0, signatureCopy, 0, this.signature.length);
            return signatureCopy;
        }
    }
}

